// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * This data type represents the information you need to connect to an Amazon Aurora DB cluster.
 * This data type is used as a response element in the following actions:
 *
 *
 *
 * CreateDBClusterEndpoint
 *
 *
 *
 * DescribeDBClusterEndpoints
 *
 *
 *
 * ModifyDBClusterEndpoint
 *
 *
 *
 * DeleteDBClusterEndpoint
 *
 *
 *
 * For the data structure that represents Amazon RDS DB instance endpoints,
 * see Endpoint.
 */
class ModifyDbClusterEndpointResponse private constructor(builder: Builder) {
    /**
     * The type associated with a custom endpoint. One of: READER,
     * WRITER, ANY.
     */
    val customEndpointType: kotlin.String? = builder.customEndpointType
    /**
     * The Amazon Resource Name (ARN) for the endpoint.
     */
    val dbClusterEndpointArn: kotlin.String? = builder.dbClusterEndpointArn
    /**
     * The identifier associated with the endpoint. This parameter is stored as a lowercase string.
     */
    val dbClusterEndpointIdentifier: kotlin.String? = builder.dbClusterEndpointIdentifier
    /**
     * A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.
     */
    val dbClusterEndpointResourceIdentifier: kotlin.String? = builder.dbClusterEndpointResourceIdentifier
    /**
     * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
     * stored as a lowercase string.
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The DNS address of the endpoint.
     */
    val endpoint: kotlin.String? = builder.endpoint
    /**
     * The type of the endpoint. One of: READER, WRITER, CUSTOM.
     */
    val endpointType: kotlin.String? = builder.endpointType
    /**
     * List of DB instance identifiers that aren't part of the custom endpoint group.
     * All other eligible instances are reachable through the custom endpoint.
     * Only relevant if the list of static members is empty.
     */
    val excludedMembers: List<String>? = builder.excludedMembers
    /**
     * List of DB instance identifiers that are part of the custom endpoint group.
     */
    val staticMembers: List<String>? = builder.staticMembers
    /**
     * The current status of the endpoint. One of: creating, available, deleting, inactive, modifying. The inactive state applies to an endpoint that can't be used for a certain kind of cluster,
     * such as a writer endpoint for a read-only secondary cluster in a global database.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbClusterEndpointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterEndpointResponse(")
        append("customEndpointType=$customEndpointType,")
        append("dbClusterEndpointArn=$dbClusterEndpointArn,")
        append("dbClusterEndpointIdentifier=$dbClusterEndpointIdentifier,")
        append("dbClusterEndpointResourceIdentifier=$dbClusterEndpointResourceIdentifier,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("endpoint=$endpoint,")
        append("endpointType=$endpointType,")
        append("excludedMembers=$excludedMembers,")
        append("staticMembers=$staticMembers,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customEndpointType?.hashCode() ?: 0
        result = 31 * result + (dbClusterEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterEndpointIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterEndpointResourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (excludedMembers?.hashCode() ?: 0)
        result = 31 * result + (staticMembers?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbClusterEndpointResponse

        if (customEndpointType != other.customEndpointType) return false
        if (dbClusterEndpointArn != other.dbClusterEndpointArn) return false
        if (dbClusterEndpointIdentifier != other.dbClusterEndpointIdentifier) return false
        if (dbClusterEndpointResourceIdentifier != other.dbClusterEndpointResourceIdentifier) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (endpoint != other.endpoint) return false
        if (endpointType != other.endpointType) return false
        if (excludedMembers != other.excludedMembers) return false
        if (staticMembers != other.staticMembers) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbClusterEndpointResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type associated with a custom endpoint. One of: READER,
         * WRITER, ANY.
         */
        var customEndpointType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the endpoint.
         */
        var dbClusterEndpointArn: kotlin.String? = null
        /**
         * The identifier associated with the endpoint. This parameter is stored as a lowercase string.
         */
        var dbClusterEndpointIdentifier: kotlin.String? = null
        /**
         * A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.
         */
        var dbClusterEndpointResourceIdentifier: kotlin.String? = null
        /**
         * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
         * stored as a lowercase string.
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The DNS address of the endpoint.
         */
        var endpoint: kotlin.String? = null
        /**
         * The type of the endpoint. One of: READER, WRITER, CUSTOM.
         */
        var endpointType: kotlin.String? = null
        /**
         * List of DB instance identifiers that aren't part of the custom endpoint group.
         * All other eligible instances are reachable through the custom endpoint.
         * Only relevant if the list of static members is empty.
         */
        var excludedMembers: List<String>? = null
        /**
         * List of DB instance identifiers that are part of the custom endpoint group.
         */
        var staticMembers: List<String>? = null
        /**
         * The current status of the endpoint. One of: creating, available, deleting, inactive, modifying. The inactive state applies to an endpoint that can't be used for a certain kind of cluster,
         * such as a writer endpoint for a read-only secondary cluster in a global database.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbClusterEndpointResponse) : this() {
            this.customEndpointType = x.customEndpointType
            this.dbClusterEndpointArn = x.dbClusterEndpointArn
            this.dbClusterEndpointIdentifier = x.dbClusterEndpointIdentifier
            this.dbClusterEndpointResourceIdentifier = x.dbClusterEndpointResourceIdentifier
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.endpoint = x.endpoint
            this.endpointType = x.endpointType
            this.excludedMembers = x.excludedMembers
            this.staticMembers = x.staticMembers
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbClusterEndpointResponse = ModifyDbClusterEndpointResponse(this)
    }
}
