// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class ModifyDbInstanceRequest private constructor(builder: Builder) {
    /**
     * The new amount of storage in gibibytes (GiB) to allocate for the DB instance.
     * For MariaDB, MySQL, Oracle, and PostgreSQL,
     * the value supplied must be at least 10% greater than the current value.
     * Values that are not at least 10% greater than the existing value are rounded up
     * so that they are 10% greater than the current value.
     * For the valid values for allocated storage for each engine,
     * see CreateDBInstance.
     */
    val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't
     * result in an outage and the change is asynchronously applied as soon as possible.
     * This setting doesn't apply to RDS Custom.
     * Constraints: Major version upgrades must be allowed when specifying a value
     * for the EngineVersion parameter that is a different major version than the DB instance's current version.
     */
    val allowMajorVersionUpgrade: kotlin.Boolean = builder.allowMajorVersionUpgrade
    /**
     * A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible,
     * regardless of the PreferredMaintenanceWindow setting for the DB instance. By default, this parameter is disabled.
     * If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage
     * and are applied on the next call to RebootDBInstance, or the next failure reboot. Review the table of parameters in
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB Instance in the
     * Amazon RDS User Guide to see the impact of enabling or disabling ApplyImmediately for each modified parameter and to
     * determine when the changes are applied.
     */
    val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * A value that indicates whether minor version upgrades are applied automatically to the DB instance
     * during the maintenance window. An outage occurs when all the following conditions are met:
     *
     *
     * The automatic upgrade is enabled for the maintenance window.
     *
     * A newer minor version is available.
     *
     * RDS has enabled automatic patching for the engine version.
     *
     *
     * If any of the preceding conditions isn't met, RDS applies the change as soon as possible and
     * doesn't cause an outage.
     * For an RDS Custom DB instance, set AutoMinorVersionUpgrade
     * to false. Otherwise, the operation returns an error.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The automation mode of the RDS Custom DB instance: full or all paused.
     * If full, the DB instance automates monitoring and instance recovery. If
     * all paused, the instance pauses automation for the duration set by
     * ResumeFullAutomationModeMinutes.
     */
    val automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = builder.automationMode
    /**
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     * This setting doesn't apply to RDS Custom.
     */
    val awsBackupRecoveryPointArn: kotlin.String? = builder.awsBackupRecoveryPointArn
    /**
     * The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
     *
     * Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few minutes, depending on the size and class of your DB instance.
     *
     * These changes are applied during the next maintenance window unless the ApplyImmediately parameter is enabled
     * for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously
     * applied as soon as possible.
     *
     * Amazon Aurora
     *
     * Not applicable. The retention period for automated backups is managed by the DB
     * cluster. For more information, see ModifyDBCluster.
     * Default: Uses existing setting
     * Constraints:
     *
     *
     * It must be a value from 0 to 35. It can't be set to 0 if the DB instance is a source to
     * read replicas. It can't be set to 0 or 35 for an RDS Custom for Oracle DB instance.
     *
     * It can be specified for a MySQL read replica only if the source is running MySQL 5.6 or
     * later.
     *
     * It can be specified for a PostgreSQL read replica only if the source is running PostgreSQL
     * 9.3.5.
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * Specifies the certificate to associate with the DB instance.
     * This setting doesn't apply to RDS Custom.
     */
    val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * A value that indicates whether the DB instance is restarted when you rotate your
     * SSL/TLS certificate.
     * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate
     * is not updated until the DB instance is restarted.
     *
     * Set this parameter only if you are not using SSL/TLS to connect to the DB instance.
     *
     * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your
     * DB engine to rotate your SSL/TLS certificate:
     *
     *
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate. in the Amazon RDS User Guide.
     *
     *
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate in the Amazon Aurora User Guide.
     *
     *
     * This setting doesn't apply to RDS Custom.
     */
    val certificateRotationRestart: kotlin.Boolean? = builder.certificateRotationRestart
    /**
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a
     * specific DB instance.
     * A change to the CloudwatchLogsExportConfiguration parameter is always applied to the DB instance
     * immediately. Therefore, the ApplyImmediately parameter has no effect.
     * This setting doesn't apply to RDS Custom.
     */
    val cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
     *
     * Amazon Aurora
     *
     * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this
     * value for an Aurora DB instance has no effect on the DB cluster setting. For more
     * information, see ModifyDBCluster.
     */
    val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The new compute and memory capacity of the DB instance, for example db.m4.large.
     * Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     * For the full list of DB instance classes,
     * and availability for your engine, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class in the Amazon RDS User Guide.
     * If you modify the DB instance class, an outage occurs during the change.
     * The change is applied during the next maintenance window,
     * unless ApplyImmediately is enabled for this request.
     * This setting doesn't apply to RDS Custom for Oracle.
     * Default: Uses existing setting
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The DB instance identifier. This value is stored as a lowercase string.
     * Constraints:
     *
     *
     * Must match the identifier of an existing DBInstance.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name of the DB parameter group to apply to the DB instance.
     * Changing this setting doesn't result in an outage. The parameter group name itself is changed
     * immediately, but the actual parameter changes are not applied until you reboot the
     * instance without failover. In this case, the DB instance isn't rebooted automatically, and the
     * parameter changes aren't applied during the next maintenance window. However, if you modify
     * dynamic parameters in the newly associated DB parameter group, these changes are applied
     * immediately without a reboot.
     * This setting doesn't apply to RDS Custom.
     * Default: Uses existing setting
     * Constraints: The DB parameter group must be in the same DB parameter group family as the DB instance.
     */
    val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * The port number on which the database accepts connections.
     * The value of the DBPortNumber parameter must not match any of the port values
     * specified for options in the option group for the DB instance.
     * If you change the DBPortNumber value, your database restarts regardless of
     * the value of the ApplyImmediately parameter.
     * This setting doesn't apply to RDS Custom.
     *
     * MySQL
     *
     * Default: 3306
     *
     * Valid values: 1150-65535
     *
     *
     * MariaDB
     *
     * Default: 3306
     *
     * Valid values: 1150-65535
     *
     *
     * PostgreSQL
     *
     * Default: 5432
     *
     * Valid values: 1150-65535
     *
     * Type: Integer
     *
     * Oracle
     *
     * Default: 1521
     *
     * Valid values: 1150-65535
     *
     *
     * SQL Server
     *
     * Default: 1433
     *
     * Valid values: 1150-65535 except 1234, 1434,
     * 3260, 3343, 3389, 47001, and
     * 49152-49156.
     *
     * Amazon Aurora
     *
     * Default: 3306
     *
     * Valid values: 1150-65535
     */
    val dbPortNumber: kotlin.Int? = builder.dbPortNumber
    /**
     * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't
     * result in an outage and the change is asynchronously applied as soon as possible.
     * This setting doesn't apply to RDS Custom.
     * Constraints:
     *
     *
     * If supplied, must match existing DBSecurityGroups.
     */
    val dbSecurityGroups: List<String>? = builder.dbSecurityGroups
    /**
     * The new DB subnet group for the DB instance.
     * You can use this parameter to move your DB instance to a different VPC.
     *
     *
     * If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC">Working with a DB instance in a VPC
     * in the Amazon RDS User Guide.
     * Changing the subnet group causes an outage during the change.
     * The change is applied during the next maintenance window,
     * unless you enable ApplyImmediately.
     * This parameter doesn't apply to RDS Custom.
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * Example: mydbsubnetgroup
     */
    val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB instance has deletion protection enabled.
     * The database can't be deleted when deletion protection is enabled. By default,
     * deletion protection isn't enabled. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
     * Deleting a DB Instance.
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to move the DB instance to.
     * Specify none to remove the instance from its current domain.
     * You must create the domain before this operation. Currently, you can create only MySQL, Microsoft SQL
     * Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
     * Kerberos Authentication in the Amazon RDS User Guide.
     * This setting doesn't apply to RDS Custom.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     * This setting doesn't apply to RDS Custom.
     */
    val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
     * A CoIP provides local or external connectivity to resources in
     * your Outpost subnets through your on-premises network. For some use cases, a CoIP can
     * provide lower latency for connections to the DB instance from outside of its virtual
     * private cloud (VPC) on your local network.
     * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts
     * in the Amazon RDS User Guide.
     * For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses
     * in the Amazon Web Services Outposts User Guide.
     */
    val enableCustomerOwnedIp: kotlin.Boolean? = builder.enableCustomerOwnedIp
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
     * (IAM) accounts to database accounts. By default, mapping isn't enabled.
     * This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB
     * cluster.
     * For more information about IAM database authentication, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
     * IAM Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide.
     *
     * This setting doesn't apply to RDS Custom.
     */
    val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * A value that indicates whether to enable Performance Insights for the DB instance.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights in the Amazon RDS User Guide..
     * This setting doesn't apply to RDS Custom.
     */
    val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The version number of the database engine to upgrade to.
     * Changing this parameter results in an outage and the change
     * is applied during the next maintenance window
     * unless the ApplyImmediately parameter is enabled for this request.
     * For major version upgrades, if a nondefault DB parameter group is currently in use, a
     * new DB parameter group in the DB parameter group family for the new engine version must
     * be specified. The new DB parameter group can be the default for that DB parameter group
     * family.
     * If you specify only a major version, Amazon RDS will update the DB instance to the
     * default minor version if the current minor version is lower.
     * For information about valid engine versions, see CreateDBInstance,
     * or call DescribeDBEngineVersions.
     * In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the
     * PATCH_DB_FAILURE lifecycle.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
     * Changing this setting doesn't result in an outage and
     * the change is applied during the next maintenance window
     * unless the ApplyImmediately parameter is enabled for this request.
     * If you are migrating from Provisioned IOPS to standard storage, set this value to 0.
     * The DB instance will require a reboot for the change in storage type to take effect.
     * If you choose to migrate your DB instance from using standard storage to using
     * Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process
     * can take time. The duration of the migration depends on several factors such as database
     * load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS
     * provisioned (if any), and the number of prior scale storage operations. Typical
     * migration times are under 24 hours, but the process can take up to several days in some
     * cases. During the migration, the DB instance is available for use, but might experience
     * performance degradation. While the migration takes place, nightly backups for the
     * instance are suspended. No other Amazon RDS operations can take place for the instance,
     * including modifying the instance, rebooting the instance, deleting the instance,
     * creating a read replica for the instance, and creating a DB snapshot of the instance.
     * Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL,
     * the value supplied must be at least 10% greater than the current value.
     * Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.
     * Default: Uses existing setting
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The license model for the DB instance.
     * This setting doesn't apply to RDS Custom.
     * Valid values: license-included | bring-your-own-license |
     * general-public-license
     */
    val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The new password for the master user. The password can include any printable ASCII
     * character except "/", """, or "@".
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     * Between the time of the request and the completion of the request,
     * the MasterUserPassword element exists in the
     * PendingModifiedValues element of the operation response.
     * This setting doesn't apply to RDS Custom.
     *
     * Amazon Aurora
     *
     * Not applicable. The password for the master user is managed by the DB cluster. For
     * more information, see ModifyDBCluster.
     * Default: Uses existing setting
     *
     * MariaDB
     *
     * Constraints: Must contain from 8 to 41 characters.
     *
     * Microsoft SQL Server
     *
     * Constraints: Must contain from 8 to 128 characters.
     *
     * MySQL
     *
     * Constraints: Must contain from 8 to 41 characters.
     *
     * Oracle
     *
     * Constraints: Must contain from 8 to 30 characters.
     *
     * PostgreSQL
     *
     * Constraints: Must contain from 8 to 128 characters.
     *
     * Amazon RDS API actions never return the password,
     * so this action provides a way to regain access to a primary instance user if the password is lost.
     * This includes restoring privileges that might have been accidentally revoked.
     */
    val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * For more information about this setting, including limitations that apply to it, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
     * Managing capacity automatically with Amazon RDS storage autoscaling
     * in the Amazon RDS User Guide.
     * This setting doesn't apply to RDS Custom.
     */
    val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected
     * for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0, which is the default.
     * If MonitoringRoleArn is specified, set MonitoringInterval to a value other than 0.
     * This setting doesn't apply to RDS Custom.
     * Valid Values: 0, 1, 5, 10, 15, 30, 60
     */
    val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
     * example, arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
     * create an IAM role for Amazon RDS Enhanced Monitoring in the Amazon RDS User Guide.
     *
     * If MonitoringInterval is set to a value other than 0, supply a MonitoringRoleArn
     * value.
     * This setting doesn't apply to RDS Custom.
     */
    val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result
     * in an outage. The change is applied during the next maintenance window unless the ApplyImmediately
     * parameter is enabled for this request.
     * This setting doesn't apply to RDS Custom.
     */
    val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance
     * identifier, an instance reboot occurs immediately if you enable ApplyImmediately, or will occur
     * during the next maintenance window if you disable Apply Immediately. This value is stored as a lowercase string.
     * This setting doesn't apply to RDS Custom.
     * Constraints:
     *
     *
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     *
     * The first character must be a letter.
     *
     * Can't end with a hyphen or contain two consecutive hyphens.
     *
     *
     * Example: mydbinstance
     */
    val newDbInstanceIdentifier: kotlin.String? = builder.newDbInstanceIdentifier
    /**
     * A value that indicates the DB instance should be associated with the specified option group.
     * Changing this parameter doesn't result in an outage, with one exception. If the parameter change results
     * in an option group that enables OEM, it can cause a brief period, lasting less than a second, during which
     * new connections are rejected but existing connections aren't interrupted.
     * The change is applied during the next maintenance window unless the ApplyImmediately parameter
     * is enabled for this request.
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed
     * from an option group, and that option group can't be removed from a DB instance after
     * it is associated with a DB instance.
     * This setting doesn't apply to RDS Custom.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon RDS
     * uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
     * Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     * This setting doesn't apply to RDS Custom.
     */
    val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
     * This setting doesn't apply to RDS Custom.
     */
    val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The daily time range during which automated backups are created
     * if automated backups are enabled,
     * as determined by the BackupRetentionPeriod parameter.
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     * The default is a 30-minute window selected at random from an
     * 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window in the Amazon RDS User Guide.
     *
     *
     * Amazon Aurora
     *
     * Not applicable. The daily time range for creating automated backups is managed by
     * the DB cluster. For more information, see ModifyDBCluster.
     * Constraints:
     *
     *
     * Must be in the format hh24:mi-hh24:mi
     *
     * Must be in Universal Time Coordinated (UTC)
     *
     * Must not conflict with the preferred maintenance window
     *
     * Must be at least 30 minutes
     */
    val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range (in UTC) during which system maintenance can occur, which
     * might result in an outage. Changing this parameter doesn't result in an outage, except
     * in the following situation, and the change is asynchronously applied as soon as
     * possible. If there are pending actions that cause a reboot, and the maintenance window
     * is changed to include the current time, then changing this parameter will cause a reboot
     * of the DB instance. If moving this window to the current time, there must be at least 30
     * minutes between the current time and end of the window to ensure pending changes are
     * applied.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window in the Amazon RDS User Guide.
     *
     * Default: Uses existing setting
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * Constraints: Must be at least 30 minutes
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * This setting doesn't apply to RDS Custom.
     */
    val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance
     * after a failure of the existing primary instance. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance">
     * Fault Tolerance for an Aurora DB Cluster in the Amazon Aurora User Guide.
     * This setting doesn't apply to RDS Custom.
     * Default: 1
     * Valid Values: 0 - 15
     */
    val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * A value that indicates whether the DB instance is publicly accessible.
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint
     * resolves to the private IP address from within the DB cluster's virtual private cloud
     * (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access
     * to the DB cluster is ultimately controlled by the security group it uses. That public
     * access isn't permitted if the security group assigned to the DB cluster doesn't permit
     * it.
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     *
     * PubliclyAccessible only applies to DB instances in a VPC. The DB instance must be part of a
     * public subnet and PubliclyAccessible must be enabled for it to be publicly accessible.
     * Changes to the PubliclyAccessible parameter are applied immediately regardless
     * of the value of the ApplyImmediately parameter.
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * A value that sets the open mode of a replica database to either mounted or read-only.
     *
     * Currently, this parameter is only supported for Oracle DB instances.
     *
     * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for
     * mounted replicas is cross-Region disaster recovery. The primary database doesn't use
     * Active Data Guard to transmit information to the mounted replica. Because it doesn't
     * accept user connections, a mounted replica can't serve a read-only workload.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS
     * in the Amazon RDS User Guide.
     * This setting doesn't apply to RDS Custom.
     */
    val replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = builder.replicaMode
    /**
     * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes
     * full automation. The minimum value is 60 (default). The maximum value is 1,440.
     */
    val resumeFullAutomationModeMinutes: kotlin.Int? = builder.resumeFullAutomationModeMinutes
    /**
     * Specifies the storage type to be associated with the DB instance.
     * If you specify Provisioned IOPS (io1),
     * you must also include a value for the Iops parameter.
     * If you choose to migrate your DB instance from using standard storage to using
     * Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process
     * can take time. The duration of the migration depends on several factors such as database
     * load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS
     * provisioned (if any), and the number of prior scale storage operations. Typical
     * migration times are under 24 hours, but the process can take up to several days in some
     * cases. During the migration, the DB instance is available for use, but might experience
     * performance degradation. While the migration takes place, nightly backups for the
     * instance are suspended. No other Amazon RDS operations can take place for the instance,
     * including modifying the instance, rebooting the instance, deleting the instance,
     * creating a read replica for the instance, and creating a DB snapshot of the instance.
     * Valid values: standard | gp2 | io1
     *
     * Default: io1 if the Iops parameter
     * is specified, otherwise gp2
     */
    val storageType: kotlin.String? = builder.storageType
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * This setting doesn't apply to RDS Custom.
     */
    val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The password for the given ARN from the key store in order to access the device.
     * This setting doesn't apply to RDS Custom.
     */
    val tdeCredentialPassword: kotlin.String? = builder.tdeCredentialPassword
    /**
     * A value that indicates whether the DB instance class of the DB instance uses its default
     * processor features.
     * This setting doesn't apply to RDS Custom.
     */
    val useDefaultProcessorFeatures: kotlin.Boolean? = builder.useDefaultProcessorFeatures
    /**
     * A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is
     * asynchronously applied as soon as possible.
     * This setting doesn't apply to RDS Custom.
     *
     * Amazon Aurora
     *
     * Not applicable. The associated list of EC2 VPC security groups is managed by
     * the DB cluster. For more information, see ModifyDBCluster.
     * Constraints:
     *
     *
     * If supplied, must match existing VpcSecurityGroupIds.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbInstanceRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("allowMajorVersionUpgrade=$allowMajorVersionUpgrade,")
        append("applyImmediately=$applyImmediately,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automationMode=$automationMode,")
        append("awsBackupRecoveryPointArn=$awsBackupRecoveryPointArn,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("certificateRotationRestart=$certificateRotationRestart,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbPortNumber=$dbPortNumber,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCustomerOwnedIp=$enableCustomerOwnedIp,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("masterUserPassword=$masterUserPassword,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("newDbInstanceIdentifier=$newDbInstanceIdentifier,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("processorFeatures=$processorFeatures,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("replicaMode=$replicaMode,")
        append("resumeFullAutomationModeMinutes=$resumeFullAutomationModeMinutes,")
        append("storageType=$storageType,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("tdeCredentialPassword=$tdeCredentialPassword,")
        append("useDefaultProcessorFeatures=$useDefaultProcessorFeatures,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (allowMajorVersionUpgrade.hashCode())
        result = 31 * result + (applyImmediately.hashCode())
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (automationMode?.hashCode() ?: 0)
        result = 31 * result + (awsBackupRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (certificateRotationRestart?.hashCode() ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbPortNumber ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCustomerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (newDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (replicaMode?.hashCode() ?: 0)
        result = 31 * result + (resumeFullAutomationModeMinutes ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialPassword?.hashCode() ?: 0)
        result = 31 * result + (useDefaultProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbInstanceRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (allowMajorVersionUpgrade != other.allowMajorVersionUpgrade) return false
        if (applyImmediately != other.applyImmediately) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automationMode != other.automationMode) return false
        if (awsBackupRecoveryPointArn != other.awsBackupRecoveryPointArn) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (certificateRotationRestart != other.certificateRotationRestart) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbPortNumber != other.dbPortNumber) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCustomerOwnedIp != other.enableCustomerOwnedIp) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (newDbInstanceIdentifier != other.newDbInstanceIdentifier) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (processorFeatures != other.processorFeatures) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (replicaMode != other.replicaMode) return false
        if (resumeFullAutomationModeMinutes != other.resumeFullAutomationModeMinutes) return false
        if (storageType != other.storageType) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (tdeCredentialPassword != other.tdeCredentialPassword) return false
        if (useDefaultProcessorFeatures != other.useDefaultProcessorFeatures) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The new amount of storage in gibibytes (GiB) to allocate for the DB instance.
         * For MariaDB, MySQL, Oracle, and PostgreSQL,
         * the value supplied must be at least 10% greater than the current value.
         * Values that are not at least 10% greater than the existing value are rounded up
         * so that they are 10% greater than the current value.
         * For the valid values for allocated storage for each engine,
         * see CreateDBInstance.
         */
        var allocatedStorage: kotlin.Int? = null
        /**
         * A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't
         * result in an outage and the change is asynchronously applied as soon as possible.
         * This setting doesn't apply to RDS Custom.
         * Constraints: Major version upgrades must be allowed when specifying a value
         * for the EngineVersion parameter that is a different major version than the DB instance's current version.
         */
        var allowMajorVersionUpgrade: kotlin.Boolean = false
        /**
         * A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible,
         * regardless of the PreferredMaintenanceWindow setting for the DB instance. By default, this parameter is disabled.
         * If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage
         * and are applied on the next call to RebootDBInstance, or the next failure reboot. Review the table of parameters in
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB Instance in the
         * Amazon RDS User Guide to see the impact of enabling or disabling ApplyImmediately for each modified parameter and to
         * determine when the changes are applied.
         */
        var applyImmediately: kotlin.Boolean = false
        /**
         * A value that indicates whether minor version upgrades are applied automatically to the DB instance
         * during the maintenance window. An outage occurs when all the following conditions are met:
         *
         *
         * The automatic upgrade is enabled for the maintenance window.
         *
         * A newer minor version is available.
         *
         * RDS has enabled automatic patching for the engine version.
         *
         *
         * If any of the preceding conditions isn't met, RDS applies the change as soon as possible and
         * doesn't cause an outage.
         * For an RDS Custom DB instance, set AutoMinorVersionUpgrade
         * to false. Otherwise, the operation returns an error.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The automation mode of the RDS Custom DB instance: full or all paused.
         * If full, the DB instance automates monitoring and instance recovery. If
         * all paused, the instance pauses automation for the duration set by
         * ResumeFullAutomationModeMinutes.
         */
        var automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = null
        /**
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         * This setting doesn't apply to RDS Custom.
         */
        var awsBackupRecoveryPointArn: kotlin.String? = null
        /**
         * The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
         *
         * Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few minutes, depending on the size and class of your DB instance.
         *
         * These changes are applied during the next maintenance window unless the ApplyImmediately parameter is enabled
         * for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously
         * applied as soon as possible.
         *
         * Amazon Aurora
         *
         * Not applicable. The retention period for automated backups is managed by the DB
         * cluster. For more information, see ModifyDBCluster.
         * Default: Uses existing setting
         * Constraints:
         *
         *
         * It must be a value from 0 to 35. It can't be set to 0 if the DB instance is a source to
         * read replicas. It can't be set to 0 or 35 for an RDS Custom for Oracle DB instance.
         *
         * It can be specified for a MySQL read replica only if the source is running MySQL 5.6 or
         * later.
         *
         * It can be specified for a PostgreSQL read replica only if the source is running PostgreSQL
         * 9.3.5.
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * Specifies the certificate to associate with the DB instance.
         * This setting doesn't apply to RDS Custom.
         */
        var caCertificateIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance is restarted when you rotate your
         * SSL/TLS certificate.
         * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate
         * is not updated until the DB instance is restarted.
         *
         * Set this parameter only if you are not using SSL/TLS to connect to the DB instance.
         *
         * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your
         * DB engine to rotate your SSL/TLS certificate:
         *
         *
         * For more information about rotating your SSL/TLS certificate for RDS DB engines, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
         * Rotating Your SSL/TLS Certificate. in the Amazon RDS User Guide.
         *
         *
         * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
         * Rotating Your SSL/TLS Certificate in the Amazon Aurora User Guide.
         *
         *
         * This setting doesn't apply to RDS Custom.
         */
        var certificateRotationRestart: kotlin.Boolean? = null
        /**
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a
         * specific DB instance.
         * A change to the CloudwatchLogsExportConfiguration parameter is always applied to the DB instance
         * immediately. Therefore, the ApplyImmediately parameter has no effect.
         * This setting doesn't apply to RDS Custom.
         */
        var cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = null
        /**
         * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
         *
         * Amazon Aurora
         *
         * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this
         * value for an Aurora DB instance has no effect on the DB cluster setting. For more
         * information, see ModifyDBCluster.
         */
        var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The new compute and memory capacity of the DB instance, for example db.m4.large.
         * Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
         * For the full list of DB instance classes,
         * and availability for your engine, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class in the Amazon RDS User Guide.
         * If you modify the DB instance class, an outage occurs during the change.
         * The change is applied during the next maintenance window,
         * unless ApplyImmediately is enabled for this request.
         * This setting doesn't apply to RDS Custom for Oracle.
         * Default: Uses existing setting
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * The DB instance identifier. This value is stored as a lowercase string.
         * Constraints:
         *
         *
         * Must match the identifier of an existing DBInstance.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name of the DB parameter group to apply to the DB instance.
         * Changing this setting doesn't result in an outage. The parameter group name itself is changed
         * immediately, but the actual parameter changes are not applied until you reboot the
         * instance without failover. In this case, the DB instance isn't rebooted automatically, and the
         * parameter changes aren't applied during the next maintenance window. However, if you modify
         * dynamic parameters in the newly associated DB parameter group, these changes are applied
         * immediately without a reboot.
         * This setting doesn't apply to RDS Custom.
         * Default: Uses existing setting
         * Constraints: The DB parameter group must be in the same DB parameter group family as the DB instance.
         */
        var dbParameterGroupName: kotlin.String? = null
        /**
         * The port number on which the database accepts connections.
         * The value of the DBPortNumber parameter must not match any of the port values
         * specified for options in the option group for the DB instance.
         * If you change the DBPortNumber value, your database restarts regardless of
         * the value of the ApplyImmediately parameter.
         * This setting doesn't apply to RDS Custom.
         *
         * MySQL
         *
         * Default: 3306
         *
         * Valid values: 1150-65535
         *
         *
         * MariaDB
         *
         * Default: 3306
         *
         * Valid values: 1150-65535
         *
         *
         * PostgreSQL
         *
         * Default: 5432
         *
         * Valid values: 1150-65535
         *
         * Type: Integer
         *
         * Oracle
         *
         * Default: 1521
         *
         * Valid values: 1150-65535
         *
         *
         * SQL Server
         *
         * Default: 1433
         *
         * Valid values: 1150-65535 except 1234, 1434,
         * 3260, 3343, 3389, 47001, and
         * 49152-49156.
         *
         * Amazon Aurora
         *
         * Default: 3306
         *
         * Valid values: 1150-65535
         */
        var dbPortNumber: kotlin.Int? = null
        /**
         * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't
         * result in an outage and the change is asynchronously applied as soon as possible.
         * This setting doesn't apply to RDS Custom.
         * Constraints:
         *
         *
         * If supplied, must match existing DBSecurityGroups.
         */
        var dbSecurityGroups: List<String>? = null
        /**
         * The new DB subnet group for the DB instance.
         * You can use this parameter to move your DB instance to a different VPC.
         *
         *
         * If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC">Working with a DB instance in a VPC
         * in the Amazon RDS User Guide.
         * Changing the subnet group causes an outage during the change.
         * The change is applied during the next maintenance window,
         * unless you enable ApplyImmediately.
         * This parameter doesn't apply to RDS Custom.
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * Example: mydbsubnetgroup
         */
        var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance has deletion protection enabled.
         * The database can't be deleted when deletion protection is enabled. By default,
         * deletion protection isn't enabled. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
         * Deleting a DB Instance.
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to move the DB instance to.
         * Specify none to remove the instance from its current domain.
         * You must create the domain before this operation. Currently, you can create only MySQL, Microsoft SQL
         * Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
         * Kerberos Authentication in the Amazon RDS User Guide.
         * This setting doesn't apply to RDS Custom.
         */
        var domain: kotlin.String? = null
        /**
         * The name of the IAM role to use when making API calls to the Directory Service.
         * This setting doesn't apply to RDS Custom.
         */
        var domainIamRoleName: kotlin.String? = null
        /**
         * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
         * A CoIP provides local or external connectivity to resources in
         * your Outpost subnets through your on-premises network. For some use cases, a CoIP can
         * provide lower latency for connections to the DB instance from outside of its virtual
         * private cloud (VPC) on your local network.
         * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts
         * in the Amazon RDS User Guide.
         * For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses
         * in the Amazon Web Services Outposts User Guide.
         */
        var enableCustomerOwnedIp: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
         * (IAM) accounts to database accounts. By default, mapping isn't enabled.
         * This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB
         * cluster.
         * For more information about IAM database authentication, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
         * IAM Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide.
         *
         * This setting doesn't apply to RDS Custom.
         */
        var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable Performance Insights for the DB instance.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights in the Amazon RDS User Guide..
         * This setting doesn't apply to RDS Custom.
         */
        var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The version number of the database engine to upgrade to.
         * Changing this parameter results in an outage and the change
         * is applied during the next maintenance window
         * unless the ApplyImmediately parameter is enabled for this request.
         * For major version upgrades, if a nondefault DB parameter group is currently in use, a
         * new DB parameter group in the DB parameter group family for the new engine version must
         * be specified. The new DB parameter group can be the default for that DB parameter group
         * family.
         * If you specify only a major version, Amazon RDS will update the DB instance to the
         * default minor version if the current minor version is lower.
         * For information about valid engine versions, see CreateDBInstance,
         * or call DescribeDBEngineVersions.
         * In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the
         * PATCH_DB_FAILURE lifecycle.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
         * Changing this setting doesn't result in an outage and
         * the change is applied during the next maintenance window
         * unless the ApplyImmediately parameter is enabled for this request.
         * If you are migrating from Provisioned IOPS to standard storage, set this value to 0.
         * The DB instance will require a reboot for the change in storage type to take effect.
         * If you choose to migrate your DB instance from using standard storage to using
         * Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process
         * can take time. The duration of the migration depends on several factors such as database
         * load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS
         * provisioned (if any), and the number of prior scale storage operations. Typical
         * migration times are under 24 hours, but the process can take up to several days in some
         * cases. During the migration, the DB instance is available for use, but might experience
         * performance degradation. While the migration takes place, nightly backups for the
         * instance are suspended. No other Amazon RDS operations can take place for the instance,
         * including modifying the instance, rebooting the instance, deleting the instance,
         * creating a read replica for the instance, and creating a DB snapshot of the instance.
         * Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL,
         * the value supplied must be at least 10% greater than the current value.
         * Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.
         * Default: Uses existing setting
         */
        var iops: kotlin.Int? = null
        /**
         * The license model for the DB instance.
         * This setting doesn't apply to RDS Custom.
         * Valid values: license-included | bring-your-own-license |
         * general-public-license
         */
        var licenseModel: kotlin.String? = null
        /**
         * The new password for the master user. The password can include any printable ASCII
         * character except "/", """, or "@".
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         * Between the time of the request and the completion of the request,
         * the MasterUserPassword element exists in the
         * PendingModifiedValues element of the operation response.
         * This setting doesn't apply to RDS Custom.
         *
         * Amazon Aurora
         *
         * Not applicable. The password for the master user is managed by the DB cluster. For
         * more information, see ModifyDBCluster.
         * Default: Uses existing setting
         *
         * MariaDB
         *
         * Constraints: Must contain from 8 to 41 characters.
         *
         * Microsoft SQL Server
         *
         * Constraints: Must contain from 8 to 128 characters.
         *
         * MySQL
         *
         * Constraints: Must contain from 8 to 41 characters.
         *
         * Oracle
         *
         * Constraints: Must contain from 8 to 30 characters.
         *
         * PostgreSQL
         *
         * Constraints: Must contain from 8 to 128 characters.
         *
         * Amazon RDS API actions never return the password,
         * so this action provides a way to regain access to a primary instance user if the password is lost.
         * This includes restoring privileges that might have been accidentally revoked.
         */
        var masterUserPassword: kotlin.String? = null
        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         * For more information about this setting, including limitations that apply to it, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
         * Managing capacity automatically with Amazon RDS storage autoscaling
         * in the Amazon RDS User Guide.
         * This setting doesn't apply to RDS Custom.
         */
        var maxAllocatedStorage: kotlin.Int? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected
         * for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0, which is the default.
         * If MonitoringRoleArn is specified, set MonitoringInterval to a value other than 0.
         * This setting doesn't apply to RDS Custom.
         * Valid Values: 0, 1, 5, 10, 15, 30, 60
         */
        var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
         * example, arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role,
         * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
         * create an IAM role for Amazon RDS Enhanced Monitoring in the Amazon RDS User Guide.
         *
         * If MonitoringInterval is set to a value other than 0, supply a MonitoringRoleArn
         * value.
         * This setting doesn't apply to RDS Custom.
         */
        var monitoringRoleArn: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result
         * in an outage. The change is applied during the next maintenance window unless the ApplyImmediately
         * parameter is enabled for this request.
         * This setting doesn't apply to RDS Custom.
         */
        var multiAz: kotlin.Boolean? = null
        /**
         * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance
         * identifier, an instance reboot occurs immediately if you enable ApplyImmediately, or will occur
         * during the next maintenance window if you disable Apply Immediately. This value is stored as a lowercase string.
         * This setting doesn't apply to RDS Custom.
         * Constraints:
         *
         *
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         *
         * The first character must be a letter.
         *
         * Can't end with a hyphen or contain two consecutive hyphens.
         *
         *
         * Example: mydbinstance
         */
        var newDbInstanceIdentifier: kotlin.String? = null
        /**
         * A value that indicates the DB instance should be associated with the specified option group.
         * Changing this parameter doesn't result in an outage, with one exception. If the parameter change results
         * in an option group that enables OEM, it can cause a brief period, lasting less than a second, during which
         * new connections are rejected but existing connections aren't interrupted.
         * The change is applied during the next maintenance window unless the ApplyImmediately parameter
         * is enabled for this request.
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed
         * from an option group, and that option group can't be removed from a DB instance after
         * it is associated with a DB instance.
         * This setting doesn't apply to RDS Custom.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon RDS
         * uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
         * Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         * This setting doesn't apply to RDS Custom.
         */
        var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
         * This setting doesn't apply to RDS Custom.
         */
        var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created
         * if automated backups are enabled,
         * as determined by the BackupRetentionPeriod parameter.
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         * The default is a 30-minute window selected at random from an
         * 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window in the Amazon RDS User Guide.
         *
         *
         * Amazon Aurora
         *
         * Not applicable. The daily time range for creating automated backups is managed by
         * the DB cluster. For more information, see ModifyDBCluster.
         * Constraints:
         *
         *
         * Must be in the format hh24:mi-hh24:mi
         *
         * Must be in Universal Time Coordinated (UTC)
         *
         * Must not conflict with the preferred maintenance window
         *
         * Must be at least 30 minutes
         */
        var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range (in UTC) during which system maintenance can occur, which
         * might result in an outage. Changing this parameter doesn't result in an outage, except
         * in the following situation, and the change is asynchronously applied as soon as
         * possible. If there are pending actions that cause a reboot, and the maintenance window
         * is changed to include the current time, then changing this parameter will cause a reboot
         * of the DB instance. If moving this window to the current time, there must be at least 30
         * minutes between the current time and end of the window to ensure pending changes are
         * applied.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window in the Amazon RDS User Guide.
         *
         * Default: Uses existing setting
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * Constraints: Must be at least 30 minutes
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * This setting doesn't apply to RDS Custom.
         */
        var processorFeatures: List<ProcessorFeature>? = null
        /**
         * A value that specifies the order in which an Aurora Replica is promoted to the primary instance
         * after a failure of the existing primary instance. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance">
         * Fault Tolerance for an Aurora DB Cluster in the Amazon Aurora User Guide.
         * This setting doesn't apply to RDS Custom.
         * Default: 1
         * Valid Values: 0 - 15
         */
        var promotionTier: kotlin.Int? = null
        /**
         * A value that indicates whether the DB instance is publicly accessible.
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint
         * resolves to the private IP address from within the DB cluster's virtual private cloud
         * (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access
         * to the DB cluster is ultimately controlled by the security group it uses. That public
         * access isn't permitted if the security group assigned to the DB cluster doesn't permit
         * it.
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         *
         * PubliclyAccessible only applies to DB instances in a VPC. The DB instance must be part of a
         * public subnet and PubliclyAccessible must be enabled for it to be publicly accessible.
         * Changes to the PubliclyAccessible parameter are applied immediately regardless
         * of the value of the ApplyImmediately parameter.
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * A value that sets the open mode of a replica database to either mounted or read-only.
         *
         * Currently, this parameter is only supported for Oracle DB instances.
         *
         * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for
         * mounted replicas is cross-Region disaster recovery. The primary database doesn't use
         * Active Data Guard to transmit information to the mounted replica. Because it doesn't
         * accept user connections, a mounted replica can't serve a read-only workload.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS
         * in the Amazon RDS User Guide.
         * This setting doesn't apply to RDS Custom.
         */
        var replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = null
        /**
         * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes
         * full automation. The minimum value is 60 (default). The maximum value is 1,440.
         */
        var resumeFullAutomationModeMinutes: kotlin.Int? = null
        /**
         * Specifies the storage type to be associated with the DB instance.
         * If you specify Provisioned IOPS (io1),
         * you must also include a value for the Iops parameter.
         * If you choose to migrate your DB instance from using standard storage to using
         * Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process
         * can take time. The duration of the migration depends on several factors such as database
         * load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS
         * provisioned (if any), and the number of prior scale storage operations. Typical
         * migration times are under 24 hours, but the process can take up to several days in some
         * cases. During the migration, the DB instance is available for use, but might experience
         * performance degradation. While the migration takes place, nightly backups for the
         * instance are suspended. No other Amazon RDS operations can take place for the instance,
         * including modifying the instance, rebooting the instance, deleting the instance,
         * creating a read replica for the instance, and creating a DB snapshot of the instance.
         * Valid values: standard | gp2 | io1
         *
         * Default: io1 if the Iops parameter
         * is specified, otherwise gp2
         */
        var storageType: kotlin.String? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         * This setting doesn't apply to RDS Custom.
         */
        var tdeCredentialArn: kotlin.String? = null
        /**
         * The password for the given ARN from the key store in order to access the device.
         * This setting doesn't apply to RDS Custom.
         */
        var tdeCredentialPassword: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance class of the DB instance uses its default
         * processor features.
         * This setting doesn't apply to RDS Custom.
         */
        var useDefaultProcessorFeatures: kotlin.Boolean? = null
        /**
         * A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is
         * asynchronously applied as soon as possible.
         * This setting doesn't apply to RDS Custom.
         *
         * Amazon Aurora
         *
         * Not applicable. The associated list of EC2 VPC security groups is managed by
         * the DB cluster. For more information, see ModifyDBCluster.
         * Constraints:
         *
         *
         * If supplied, must match existing VpcSecurityGroupIds.
         */
        var vpcSecurityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.allowMajorVersionUpgrade = x.allowMajorVersionUpgrade
            this.applyImmediately = x.applyImmediately
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automationMode = x.automationMode
            this.awsBackupRecoveryPointArn = x.awsBackupRecoveryPointArn
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.certificateRotationRestart = x.certificateRotationRestart
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbPortNumber = x.dbPortNumber
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCustomerOwnedIp = x.enableCustomerOwnedIp
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.masterUserPassword = x.masterUserPassword
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.newDbInstanceIdentifier = x.newDbInstanceIdentifier
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.processorFeatures = x.processorFeatures
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.replicaMode = x.replicaMode
            this.resumeFullAutomationModeMinutes = x.resumeFullAutomationModeMinutes
            this.storageType = x.storageType
            this.tdeCredentialArn = x.tdeCredentialArn
            this.tdeCredentialPassword = x.tdeCredentialPassword
            this.useDefaultProcessorFeatures = x.useDefaultProcessorFeatures
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest = ModifyDbInstanceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        fun cloudwatchLogsExportConfiguration(block: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.invoke(block)
        }
    }
}
