// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class ModifyDbSnapshotRequest private constructor(builder: Builder) {
    /**
     * The identifier of the DB snapshot to modify.
     */
    val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * The engine version to upgrade the DB snapshot to.
     * The following are the database engines and engine versions that are available when you upgrade a DB snapshot.
     *
     * MySQL
     *
     *
     *
     *
     * 5.5.46 (supported for 5.1 DB snapshots)
     *
     *
     *
     * Oracle
     *
     *
     *
     *
     * 12.1.0.2.v8  (supported for 12.1.0.1 DB snapshots)
     *
     *
     * 11.2.0.4.v12 (supported for 11.2.0.2 DB snapshots)
     *
     *
     * 11.2.0.4.v11 (supported for 11.2.0.3 DB snapshots)
     *
     *
     *
     * PostgreSQL
     *
     * For the list of engine versions that are available for upgrading a DB snapshot, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.PostgreSQL.html#USER_UpgradeDBInstance.PostgreSQL.MajorVersion">
     * Upgrading the PostgreSQL DB Engine for Amazon RDS.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The option group to identify with the upgraded DB snapshot.
     * You can specify this parameter when you upgrade an Oracle DB snapshot.
     * The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG">Option group considerations in the Amazon RDS User Guide.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbSnapshotRequest(")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("engineVersion=$engineVersion,")
        append("optionGroupName=$optionGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbSnapshotIdentifier?.hashCode() ?: 0
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbSnapshotRequest

        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (engineVersion != other.engineVersion) return false
        if (optionGroupName != other.optionGroupName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the DB snapshot to modify.
         */
        var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * The engine version to upgrade the DB snapshot to.
         * The following are the database engines and engine versions that are available when you upgrade a DB snapshot.
         *
         * MySQL
         *
         *
         *
         *
         * 5.5.46 (supported for 5.1 DB snapshots)
         *
         *
         *
         * Oracle
         *
         *
         *
         *
         * 12.1.0.2.v8  (supported for 12.1.0.1 DB snapshots)
         *
         *
         * 11.2.0.4.v12 (supported for 11.2.0.2 DB snapshots)
         *
         *
         * 11.2.0.4.v11 (supported for 11.2.0.3 DB snapshots)
         *
         *
         *
         * PostgreSQL
         *
         * For the list of engine versions that are available for upgrading a DB snapshot, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.PostgreSQL.html#USER_UpgradeDBInstance.PostgreSQL.MajorVersion">
         * Upgrading the PostgreSQL DB Engine for Amazon RDS.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The option group to identify with the upgraded DB snapshot.
         * You can specify this parameter when you upgrade an Oracle DB snapshot.
         * The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG">Option group considerations in the Amazon RDS User Guide.
         */
        var optionGroupName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest) : this() {
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.engineVersion = x.engineVersion
            this.optionGroupName = x.optionGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotRequest = ModifyDbSnapshotRequest(this)
    }
}
