// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class ModifyEventSubscriptionRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether to activate the subscription.
     */
    val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A list of event categories for a source type (SourceType) that you want to subscribe to.
     * You can see a list of the categories for a given source type
     * in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events in the Amazon RDS User Guide
     * or by using the DescribeEventCategories operation.
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify db-proxy. If this value isn't specified, all events are returned.
     * Valid values: db-instance | db-cluster | db-parameter-group | db-security-group | db-snapshot | db-cluster-snapshot | db-proxy
     */
    val sourceType: kotlin.String? = builder.sourceType
    /**
     * The name of the RDS event notification subscription.
     */
    val subscriptionName: kotlin.String? = builder.subscriptionName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyEventSubscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyEventSubscriptionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that indicates whether to activate the subscription.
         */
        var enabled: kotlin.Boolean? = null
        /**
         * A list of event categories for a source type (SourceType) that you want to subscribe to.
         * You can see a list of the categories for a given source type
         * in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events in the Amazon RDS User Guide
         * or by using the DescribeEventCategories operation.
         */
        var eventCategories: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
         */
        var snsTopicArn: kotlin.String? = null
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify db-proxy. If this value isn't specified, all events are returned.
         * Valid values: db-instance | db-cluster | db-parameter-group | db-security-group | db-snapshot | db-cluster-snapshot | db-proxy
         */
        var sourceType: kotlin.String? = null
        /**
         * The name of the RDS event notification subscription.
         */
        var subscriptionName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.snsTopicArn = x.snsTopicArn
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyEventSubscriptionRequest = ModifyEventSubscriptionRequest(this)
    }
}
