// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class OptionGroup private constructor(builder: Builder) {
    /**
     * Indicates whether this option group can be applied to both VPC
     * and non-VPC instances. The value true indicates the option group
     * can be applied to both VPC and non-VPC instances.
     */
    val allowsVpcAndNonVpcInstanceMemberships: kotlin.Boolean = builder.allowsVpcAndNonVpcInstanceMemberships
    /**
     * Indicates the name of the engine that this option group can be applied to.
     */
    val engineName: kotlin.String? = builder.engineName
    /**
     * Indicates the major engine version associated with this option group.
     */
    val majorEngineVersion: kotlin.String? = builder.majorEngineVersion
    /**
     * The Amazon Resource Name (ARN) for the option group.
     */
    val optionGroupArn: kotlin.String? = builder.optionGroupArn
    /**
     * Provides a description of the option group.
     */
    val optionGroupDescription: kotlin.String? = builder.optionGroupDescription
    /**
     * Specifies the name of the option group.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * Indicates what options are available in the option group.
     */
    val options: List<Option>? = builder.options
    /**
     * If AllowsVpcAndNonVpcInstanceMemberships is false, this field is blank.
     * If AllowsVpcAndNonVpcInstanceMemberships is true and this field is blank,
     * then this option group can be applied to both VPC and non-VPC instances.
     * If this field contains a value, then this option group can only be
     * applied to instances that are in the VPC indicated by this field.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.OptionGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptionGroup(")
        append("allowsVpcAndNonVpcInstanceMemberships=$allowsVpcAndNonVpcInstanceMemberships,")
        append("engineName=$engineName,")
        append("majorEngineVersion=$majorEngineVersion,")
        append("optionGroupArn=$optionGroupArn,")
        append("optionGroupDescription=$optionGroupDescription,")
        append("optionGroupName=$optionGroupName,")
        append("options=$options,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsVpcAndNonVpcInstanceMemberships.hashCode()
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (majorEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (optionGroupArn?.hashCode() ?: 0)
        result = 31 * result + (optionGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptionGroup

        if (allowsVpcAndNonVpcInstanceMemberships != other.allowsVpcAndNonVpcInstanceMemberships) return false
        if (engineName != other.engineName) return false
        if (majorEngineVersion != other.majorEngineVersion) return false
        if (optionGroupArn != other.optionGroupArn) return false
        if (optionGroupDescription != other.optionGroupDescription) return false
        if (optionGroupName != other.optionGroupName) return false
        if (options != other.options) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.OptionGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether this option group can be applied to both VPC
         * and non-VPC instances. The value true indicates the option group
         * can be applied to both VPC and non-VPC instances.
         */
        var allowsVpcAndNonVpcInstanceMemberships: kotlin.Boolean = false
        /**
         * Indicates the name of the engine that this option group can be applied to.
         */
        var engineName: kotlin.String? = null
        /**
         * Indicates the major engine version associated with this option group.
         */
        var majorEngineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the option group.
         */
        var optionGroupArn: kotlin.String? = null
        /**
         * Provides a description of the option group.
         */
        var optionGroupDescription: kotlin.String? = null
        /**
         * Specifies the name of the option group.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * Indicates what options are available in the option group.
         */
        var options: List<Option>? = null
        /**
         * If AllowsVpcAndNonVpcInstanceMemberships is false, this field is blank.
         * If AllowsVpcAndNonVpcInstanceMemberships is true and this field is blank,
         * then this option group can be applied to both VPC and non-VPC instances.
         * If this field contains a value, then this option group can only be
         * applied to instances that are in the VPC indicated by this field.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.OptionGroup) : this() {
            this.allowsVpcAndNonVpcInstanceMemberships = x.allowsVpcAndNonVpcInstanceMemberships
            this.engineName = x.engineName
            this.majorEngineVersion = x.majorEngineVersion
            this.optionGroupArn = x.optionGroupArn
            this.optionGroupDescription = x.optionGroupDescription
            this.optionGroupName = x.optionGroupName
            this.options = x.options
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.OptionGroup = OptionGroup(this)
    }
}
