// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Available option.
 */
class OptionGroupOption private constructor(builder: Builder) {
    /**
     * If the option requires a port, specifies the default port for the option.
     */
    val defaultPort: kotlin.Int? = builder.defaultPort
    /**
     * The description of the option.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the engine that this option can be applied to.
     */
    val engineName: kotlin.String? = builder.engineName
    /**
     * Indicates the major engine version that the option is available for.
     */
    val majorEngineVersion: kotlin.String? = builder.majorEngineVersion
    /**
     * The minimum required engine version for the option to be applied.
     */
    val minimumRequiredMinorEngineVersion: kotlin.String? = builder.minimumRequiredMinorEngineVersion
    /**
     * The name of the option.
     */
    val name: kotlin.String? = builder.name
    /**
     * The option settings that are available (and the default value) for each option in an option group.
     */
    val optionGroupOptionSettings: List<OptionGroupOptionSetting>? = builder.optionGroupOptionSettings
    /**
     * The versions that are available for the option.
     */
    val optionGroupOptionVersions: List<OptionVersion>? = builder.optionGroupOptionVersions
    /**
     * The options that conflict with this option.
     */
    val optionsConflictsWith: List<String>? = builder.optionsConflictsWith
    /**
     * The options that are prerequisites for this option.
     */
    val optionsDependedOn: List<String>? = builder.optionsDependedOn
    /**
     * Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.
     */
    val permanent: kotlin.Boolean = builder.permanent
    /**
     * Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.
     */
    val persistent: kotlin.Boolean = builder.persistent
    /**
     * Specifies whether the option requires a port.
     */
    val portRequired: kotlin.Boolean = builder.portRequired
    /**
     * If true, you must enable the Auto Minor Version Upgrade setting for your DB instance
     * before you can use this option.
     * You can enable Auto Minor Version Upgrade when you first create your DB instance,
     * or by modifying your DB instance later.
     */
    val requiresAutoMinorEngineVersionUpgrade: kotlin.Boolean = builder.requiresAutoMinorEngineVersionUpgrade
    /**
     * If true, you can change the option to an earlier version of the option.
     * This only applies to options that have different versions available.
     */
    val supportsOptionVersionDowngrade: kotlin.Boolean? = builder.supportsOptionVersionDowngrade
    /**
     * If true, you can only use this option with a DB instance that is in a VPC.
     */
    val vpcOnly: kotlin.Boolean = builder.vpcOnly

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.OptionGroupOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptionGroupOption(")
        append("defaultPort=$defaultPort,")
        append("description=$description,")
        append("engineName=$engineName,")
        append("majorEngineVersion=$majorEngineVersion,")
        append("minimumRequiredMinorEngineVersion=$minimumRequiredMinorEngineVersion,")
        append("name=$name,")
        append("optionGroupOptionSettings=$optionGroupOptionSettings,")
        append("optionGroupOptionVersions=$optionGroupOptionVersions,")
        append("optionsConflictsWith=$optionsConflictsWith,")
        append("optionsDependedOn=$optionsDependedOn,")
        append("permanent=$permanent,")
        append("persistent=$persistent,")
        append("portRequired=$portRequired,")
        append("requiresAutoMinorEngineVersionUpgrade=$requiresAutoMinorEngineVersionUpgrade,")
        append("supportsOptionVersionDowngrade=$supportsOptionVersionDowngrade,")
        append("vpcOnly=$vpcOnly)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultPort ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (majorEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (minimumRequiredMinorEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (optionGroupOptionSettings?.hashCode() ?: 0)
        result = 31 * result + (optionGroupOptionVersions?.hashCode() ?: 0)
        result = 31 * result + (optionsConflictsWith?.hashCode() ?: 0)
        result = 31 * result + (optionsDependedOn?.hashCode() ?: 0)
        result = 31 * result + (permanent.hashCode())
        result = 31 * result + (persistent.hashCode())
        result = 31 * result + (portRequired.hashCode())
        result = 31 * result + (requiresAutoMinorEngineVersionUpgrade.hashCode())
        result = 31 * result + (supportsOptionVersionDowngrade?.hashCode() ?: 0)
        result = 31 * result + (vpcOnly.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptionGroupOption

        if (defaultPort != other.defaultPort) return false
        if (description != other.description) return false
        if (engineName != other.engineName) return false
        if (majorEngineVersion != other.majorEngineVersion) return false
        if (minimumRequiredMinorEngineVersion != other.minimumRequiredMinorEngineVersion) return false
        if (name != other.name) return false
        if (optionGroupOptionSettings != other.optionGroupOptionSettings) return false
        if (optionGroupOptionVersions != other.optionGroupOptionVersions) return false
        if (optionsConflictsWith != other.optionsConflictsWith) return false
        if (optionsDependedOn != other.optionsDependedOn) return false
        if (permanent != other.permanent) return false
        if (persistent != other.persistent) return false
        if (portRequired != other.portRequired) return false
        if (requiresAutoMinorEngineVersionUpgrade != other.requiresAutoMinorEngineVersionUpgrade) return false
        if (supportsOptionVersionDowngrade != other.supportsOptionVersionDowngrade) return false
        if (vpcOnly != other.vpcOnly) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.OptionGroupOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the option requires a port, specifies the default port for the option.
         */
        var defaultPort: kotlin.Int? = null
        /**
         * The description of the option.
         */
        var description: kotlin.String? = null
        /**
         * The name of the engine that this option can be applied to.
         */
        var engineName: kotlin.String? = null
        /**
         * Indicates the major engine version that the option is available for.
         */
        var majorEngineVersion: kotlin.String? = null
        /**
         * The minimum required engine version for the option to be applied.
         */
        var minimumRequiredMinorEngineVersion: kotlin.String? = null
        /**
         * The name of the option.
         */
        var name: kotlin.String? = null
        /**
         * The option settings that are available (and the default value) for each option in an option group.
         */
        var optionGroupOptionSettings: List<OptionGroupOptionSetting>? = null
        /**
         * The versions that are available for the option.
         */
        var optionGroupOptionVersions: List<OptionVersion>? = null
        /**
         * The options that conflict with this option.
         */
        var optionsConflictsWith: List<String>? = null
        /**
         * The options that are prerequisites for this option.
         */
        var optionsDependedOn: List<String>? = null
        /**
         * Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.
         */
        var permanent: kotlin.Boolean = false
        /**
         * Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.
         */
        var persistent: kotlin.Boolean = false
        /**
         * Specifies whether the option requires a port.
         */
        var portRequired: kotlin.Boolean = false
        /**
         * If true, you must enable the Auto Minor Version Upgrade setting for your DB instance
         * before you can use this option.
         * You can enable Auto Minor Version Upgrade when you first create your DB instance,
         * or by modifying your DB instance later.
         */
        var requiresAutoMinorEngineVersionUpgrade: kotlin.Boolean = false
        /**
         * If true, you can change the option to an earlier version of the option.
         * This only applies to options that have different versions available.
         */
        var supportsOptionVersionDowngrade: kotlin.Boolean? = null
        /**
         * If true, you can only use this option with a DB instance that is in a VPC.
         */
        var vpcOnly: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.OptionGroupOption) : this() {
            this.defaultPort = x.defaultPort
            this.description = x.description
            this.engineName = x.engineName
            this.majorEngineVersion = x.majorEngineVersion
            this.minimumRequiredMinorEngineVersion = x.minimumRequiredMinorEngineVersion
            this.name = x.name
            this.optionGroupOptionSettings = x.optionGroupOptionSettings
            this.optionGroupOptionVersions = x.optionGroupOptionVersions
            this.optionsConflictsWith = x.optionsConflictsWith
            this.optionsDependedOn = x.optionsDependedOn
            this.permanent = x.permanent
            this.persistent = x.persistent
            this.portRequired = x.portRequired
            this.requiresAutoMinorEngineVersionUpgrade = x.requiresAutoMinorEngineVersionUpgrade
            this.supportsOptionVersionDowngrade = x.supportsOptionVersionDowngrade
            this.vpcOnly = x.vpcOnly
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.OptionGroupOption = OptionGroupOption(this)
    }
}
