// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.
 */
class OptionSetting private constructor(builder: Builder) {
    /**
     * The allowed values of the option setting.
     */
    val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * The DB engine specific parameter type.
     */
    val applyType: kotlin.String? = builder.applyType
    /**
     * The data type of the option setting.
     */
    val dataType: kotlin.String? = builder.dataType
    /**
     * The default value of the option setting.
     */
    val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * The description of the option setting.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates if the option setting is part of a collection.
     */
    val isCollection: kotlin.Boolean = builder.isCollection
    /**
     * A Boolean value that, when true, indicates the option setting can be modified from the default.
     */
    val isModifiable: kotlin.Boolean = builder.isModifiable
    /**
     * The name of the option that has settings that you can set.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current value of the option setting.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.OptionSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptionSetting(")
        append("allowedValues=$allowedValues,")
        append("applyType=$applyType,")
        append("dataType=$dataType,")
        append("defaultValue=$defaultValue,")
        append("description=$description,")
        append("isCollection=$isCollection,")
        append("isModifiable=$isModifiable,")
        append("name=$name,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (applyType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isCollection.hashCode())
        result = 31 * result + (isModifiable.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptionSetting

        if (allowedValues != other.allowedValues) return false
        if (applyType != other.applyType) return false
        if (dataType != other.dataType) return false
        if (defaultValue != other.defaultValue) return false
        if (description != other.description) return false
        if (isCollection != other.isCollection) return false
        if (isModifiable != other.isModifiable) return false
        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.OptionSetting = Builder(this).apply(block).build()

    class Builder {
        /**
         * The allowed values of the option setting.
         */
        var allowedValues: kotlin.String? = null
        /**
         * The DB engine specific parameter type.
         */
        var applyType: kotlin.String? = null
        /**
         * The data type of the option setting.
         */
        var dataType: kotlin.String? = null
        /**
         * The default value of the option setting.
         */
        var defaultValue: kotlin.String? = null
        /**
         * The description of the option setting.
         */
        var description: kotlin.String? = null
        /**
         * Indicates if the option setting is part of a collection.
         */
        var isCollection: kotlin.Boolean = false
        /**
         * A Boolean value that, when true, indicates the option setting can be modified from the default.
         */
        var isModifiable: kotlin.Boolean = false
        /**
         * The name of the option that has settings that you can set.
         */
        var name: kotlin.String? = null
        /**
         * The current value of the option setting.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.OptionSetting) : this() {
            this.allowedValues = x.allowedValues
            this.applyType = x.applyType
            this.dataType = x.dataType
            this.defaultValue = x.defaultValue
            this.description = x.description
            this.isCollection = x.isCollection
            this.isModifiable = x.isModifiable
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.OptionSetting = OptionSetting(this)
    }
}
