// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains a list of available options for a DB instance.
 * This data type is used as a response element in the DescribeOrderableDBInstanceOptions action.
 */
class OrderableDbInstanceOption private constructor(builder: Builder) {
    /**
     * The Availability Zone group for a DB instance.
     */
    val availabilityZoneGroup: kotlin.String? = builder.availabilityZoneGroup
    /**
     * A list of Availability Zones for a DB instance.
     */
    val availabilityZones: List<AvailabilityZone>? = builder.availabilityZones
    /**
     * A list of the available processor features for the DB instance class of a DB instance.
     */
    val availableProcessorFeatures: List<AvailableProcessorFeature>? = builder.availableProcessorFeatures
    /**
     * The DB instance class for a DB instance.
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The engine type of a DB instance.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The engine version of a DB instance.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The license model for a DB instance.
     */
    val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Maximum total provisioned IOPS for a DB instance.
     */
    val maxIopsPerDbInstance: kotlin.Int? = builder.maxIopsPerDbInstance
    /**
     * Maximum provisioned IOPS per GiB for a DB instance.
     */
    val maxIopsPerGib: kotlin.Double? = builder.maxIopsPerGib
    /**
     * Maximum storage size for a DB instance.
     */
    val maxStorageSize: kotlin.Int? = builder.maxStorageSize
    /**
     * Minimum total provisioned IOPS for a DB instance.
     */
    val minIopsPerDbInstance: kotlin.Int? = builder.minIopsPerDbInstance
    /**
     * Minimum provisioned IOPS per GiB for a DB instance.
     */
    val minIopsPerGib: kotlin.Double? = builder.minIopsPerGib
    /**
     * Minimum storage size for a DB instance.
     */
    val minStorageSize: kotlin.Int? = builder.minStorageSize
    /**
     * Indicates whether a DB instance is Multi-AZ capable.
     */
    val multiAzCapable: kotlin.Boolean = builder.multiAzCapable
    /**
     * Whether a DB instance supports RDS on Outposts.
     * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts
     * in the Amazon RDS User Guide.
     */
    val outpostCapable: kotlin.Boolean = builder.outpostCapable
    /**
     * Indicates whether a DB instance can have a read replica.
     */
    val readReplicaCapable: kotlin.Boolean = builder.readReplicaCapable
    /**
     * Indicates the storage type for a DB instance.
     */
    val storageType: kotlin.String? = builder.storageType
    /**
     * The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value &#91;sync,
     * async&#93;. Aurora MySQL and RDS for Oracle return &#91;async&#93; only. If Database Activity Streams
     * isn't supported, the return value is an empty list.
     */
    val supportedActivityStreamModes: List<String>? = builder.supportedActivityStreamModes
    /**
     * A list of the supported DB engine modes.
     */
    val supportedEngineModes: List<String>? = builder.supportedEngineModes
    /**
     * Whether DB instances can be configured as a Multi-AZ DB cluster.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    val supportsClusters: kotlin.Boolean = builder.supportsClusters
    /**
     * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     */
    val supportsEnhancedMonitoring: kotlin.Boolean = builder.supportsEnhancedMonitoring
    /**
     * A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.
     */
    val supportsGlobalDatabases: kotlin.Boolean = builder.supportsGlobalDatabases
    /**
     * Indicates whether a DB instance supports IAM database authentication.
     */
    val supportsIamDatabaseAuthentication: kotlin.Boolean = builder.supportsIamDatabaseAuthentication
    /**
     * Indicates whether a DB instance supports provisioned IOPS.
     */
    val supportsIops: kotlin.Boolean = builder.supportsIops
    /**
     * Whether a DB instance supports Kerberos Authentication.
     */
    val supportsKerberosAuthentication: kotlin.Boolean? = builder.supportsKerberosAuthentication
    /**
     * True if a DB instance supports Performance Insights, otherwise false.
     */
    val supportsPerformanceInsights: kotlin.Boolean = builder.supportsPerformanceInsights
    /**
     * Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
     */
    val supportsStorageAutoscaling: kotlin.Boolean? = builder.supportsStorageAutoscaling
    /**
     * Indicates whether a DB instance supports encrypted storage.
     */
    val supportsStorageEncryption: kotlin.Boolean = builder.supportsStorageEncryption
    /**
     * Indicates whether a DB instance is in a VPC.
     */
    val vpc: kotlin.Boolean = builder.vpc

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrderableDbInstanceOption(")
        append("availabilityZoneGroup=$availabilityZoneGroup,")
        append("availabilityZones=$availabilityZones,")
        append("availableProcessorFeatures=$availableProcessorFeatures,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("licenseModel=$licenseModel,")
        append("maxIopsPerDbInstance=$maxIopsPerDbInstance,")
        append("maxIopsPerGib=$maxIopsPerGib,")
        append("maxStorageSize=$maxStorageSize,")
        append("minIopsPerDbInstance=$minIopsPerDbInstance,")
        append("minIopsPerGib=$minIopsPerGib,")
        append("minStorageSize=$minStorageSize,")
        append("multiAzCapable=$multiAzCapable,")
        append("outpostCapable=$outpostCapable,")
        append("readReplicaCapable=$readReplicaCapable,")
        append("storageType=$storageType,")
        append("supportedActivityStreamModes=$supportedActivityStreamModes,")
        append("supportedEngineModes=$supportedEngineModes,")
        append("supportsClusters=$supportsClusters,")
        append("supportsEnhancedMonitoring=$supportsEnhancedMonitoring,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases,")
        append("supportsIamDatabaseAuthentication=$supportsIamDatabaseAuthentication,")
        append("supportsIops=$supportsIops,")
        append("supportsKerberosAuthentication=$supportsKerberosAuthentication,")
        append("supportsPerformanceInsights=$supportsPerformanceInsights,")
        append("supportsStorageAutoscaling=$supportsStorageAutoscaling,")
        append("supportsStorageEncryption=$supportsStorageEncryption,")
        append("vpc=$vpc)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneGroup?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (availableProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (maxIopsPerDbInstance ?: 0)
        result = 31 * result + (maxIopsPerGib?.hashCode() ?: 0)
        result = 31 * result + (maxStorageSize ?: 0)
        result = 31 * result + (minIopsPerDbInstance ?: 0)
        result = 31 * result + (minIopsPerGib?.hashCode() ?: 0)
        result = 31 * result + (minStorageSize ?: 0)
        result = 31 * result + (multiAzCapable.hashCode())
        result = 31 * result + (outpostCapable.hashCode())
        result = 31 * result + (readReplicaCapable.hashCode())
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (supportedActivityStreamModes?.hashCode() ?: 0)
        result = 31 * result + (supportedEngineModes?.hashCode() ?: 0)
        result = 31 * result + (supportsClusters.hashCode())
        result = 31 * result + (supportsEnhancedMonitoring.hashCode())
        result = 31 * result + (supportsGlobalDatabases.hashCode())
        result = 31 * result + (supportsIamDatabaseAuthentication.hashCode())
        result = 31 * result + (supportsIops.hashCode())
        result = 31 * result + (supportsKerberosAuthentication?.hashCode() ?: 0)
        result = 31 * result + (supportsPerformanceInsights.hashCode())
        result = 31 * result + (supportsStorageAutoscaling?.hashCode() ?: 0)
        result = 31 * result + (supportsStorageEncryption.hashCode())
        result = 31 * result + (vpc.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrderableDbInstanceOption

        if (availabilityZoneGroup != other.availabilityZoneGroup) return false
        if (availabilityZones != other.availabilityZones) return false
        if (availableProcessorFeatures != other.availableProcessorFeatures) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (licenseModel != other.licenseModel) return false
        if (maxIopsPerDbInstance != other.maxIopsPerDbInstance) return false
        if (maxIopsPerGib != other.maxIopsPerGib) return false
        if (maxStorageSize != other.maxStorageSize) return false
        if (minIopsPerDbInstance != other.minIopsPerDbInstance) return false
        if (minIopsPerGib != other.minIopsPerGib) return false
        if (minStorageSize != other.minStorageSize) return false
        if (multiAzCapable != other.multiAzCapable) return false
        if (outpostCapable != other.outpostCapable) return false
        if (readReplicaCapable != other.readReplicaCapable) return false
        if (storageType != other.storageType) return false
        if (supportedActivityStreamModes != other.supportedActivityStreamModes) return false
        if (supportedEngineModes != other.supportedEngineModes) return false
        if (supportsClusters != other.supportsClusters) return false
        if (supportsEnhancedMonitoring != other.supportsEnhancedMonitoring) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false
        if (supportsIamDatabaseAuthentication != other.supportsIamDatabaseAuthentication) return false
        if (supportsIops != other.supportsIops) return false
        if (supportsKerberosAuthentication != other.supportsKerberosAuthentication) return false
        if (supportsPerformanceInsights != other.supportsPerformanceInsights) return false
        if (supportsStorageAutoscaling != other.supportsStorageAutoscaling) return false
        if (supportsStorageEncryption != other.supportsStorageEncryption) return false
        if (vpc != other.vpc) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone group for a DB instance.
         */
        var availabilityZoneGroup: kotlin.String? = null
        /**
         * A list of Availability Zones for a DB instance.
         */
        var availabilityZones: List<AvailabilityZone>? = null
        /**
         * A list of the available processor features for the DB instance class of a DB instance.
         */
        var availableProcessorFeatures: List<AvailableProcessorFeature>? = null
        /**
         * The DB instance class for a DB instance.
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * The engine type of a DB instance.
         */
        var engine: kotlin.String? = null
        /**
         * The engine version of a DB instance.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The license model for a DB instance.
         */
        var licenseModel: kotlin.String? = null
        /**
         * Maximum total provisioned IOPS for a DB instance.
         */
        var maxIopsPerDbInstance: kotlin.Int? = null
        /**
         * Maximum provisioned IOPS per GiB for a DB instance.
         */
        var maxIopsPerGib: kotlin.Double? = null
        /**
         * Maximum storage size for a DB instance.
         */
        var maxStorageSize: kotlin.Int? = null
        /**
         * Minimum total provisioned IOPS for a DB instance.
         */
        var minIopsPerDbInstance: kotlin.Int? = null
        /**
         * Minimum provisioned IOPS per GiB for a DB instance.
         */
        var minIopsPerGib: kotlin.Double? = null
        /**
         * Minimum storage size for a DB instance.
         */
        var minStorageSize: kotlin.Int? = null
        /**
         * Indicates whether a DB instance is Multi-AZ capable.
         */
        var multiAzCapable: kotlin.Boolean = false
        /**
         * Whether a DB instance supports RDS on Outposts.
         * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts
         * in the Amazon RDS User Guide.
         */
        var outpostCapable: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance can have a read replica.
         */
        var readReplicaCapable: kotlin.Boolean = false
        /**
         * Indicates the storage type for a DB instance.
         */
        var storageType: kotlin.String? = null
        /**
         * The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value &#91;sync,
         * async&#93;. Aurora MySQL and RDS for Oracle return &#91;async&#93; only. If Database Activity Streams
         * isn't supported, the return value is an empty list.
         */
        var supportedActivityStreamModes: List<String>? = null
        /**
         * A list of the supported DB engine modes.
         */
        var supportedEngineModes: List<String>? = null
        /**
         * Whether DB instances can be configured as a Multi-AZ DB cluster.
         * For more information on Multi-AZ DB clusters, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
         * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
         */
        var supportsClusters: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
         */
        var supportsEnhancedMonitoring: kotlin.Boolean = false
        /**
         * A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.
         */
        var supportsGlobalDatabases: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance supports IAM database authentication.
         */
        var supportsIamDatabaseAuthentication: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance supports provisioned IOPS.
         */
        var supportsIops: kotlin.Boolean = false
        /**
         * Whether a DB instance supports Kerberos Authentication.
         */
        var supportsKerberosAuthentication: kotlin.Boolean? = null
        /**
         * True if a DB instance supports Performance Insights, otherwise false.
         */
        var supportsPerformanceInsights: kotlin.Boolean = false
        /**
         * Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
         */
        var supportsStorageAutoscaling: kotlin.Boolean? = null
        /**
         * Indicates whether a DB instance supports encrypted storage.
         */
        var supportsStorageEncryption: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance is in a VPC.
         */
        var vpc: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption) : this() {
            this.availabilityZoneGroup = x.availabilityZoneGroup
            this.availabilityZones = x.availabilityZones
            this.availableProcessorFeatures = x.availableProcessorFeatures
            this.dbInstanceClass = x.dbInstanceClass
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.licenseModel = x.licenseModel
            this.maxIopsPerDbInstance = x.maxIopsPerDbInstance
            this.maxIopsPerGib = x.maxIopsPerGib
            this.maxStorageSize = x.maxStorageSize
            this.minIopsPerDbInstance = x.minIopsPerDbInstance
            this.minIopsPerGib = x.minIopsPerGib
            this.minStorageSize = x.minStorageSize
            this.multiAzCapable = x.multiAzCapable
            this.outpostCapable = x.outpostCapable
            this.readReplicaCapable = x.readReplicaCapable
            this.storageType = x.storageType
            this.supportedActivityStreamModes = x.supportedActivityStreamModes
            this.supportedEngineModes = x.supportedEngineModes
            this.supportsClusters = x.supportsClusters
            this.supportsEnhancedMonitoring = x.supportsEnhancedMonitoring
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
            this.supportsIamDatabaseAuthentication = x.supportsIamDatabaseAuthentication
            this.supportsIops = x.supportsIops
            this.supportsKerberosAuthentication = x.supportsKerberosAuthentication
            this.supportsPerformanceInsights = x.supportsPerformanceInsights
            this.supportsStorageAutoscaling = x.supportsStorageAutoscaling
            this.supportsStorageEncryption = x.supportsStorageEncryption
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption = OrderableDbInstanceOption(this)
    }
}
