// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * This data type is used as a request parameter in the
 * ModifyDBParameterGroup and ResetDBParameterGroup actions.
 * This data type is used as a response element in the
 * DescribeEngineDefaultParameters and DescribeDBParameters actions.
 */
class Parameter private constructor(builder: Builder) {
    /**
     * Specifies the valid range of values for the parameter.
     */
    val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * Indicates when to apply parameter updates.
     */
    val applyMethod: aws.sdk.kotlin.services.rds.model.ApplyMethod? = builder.applyMethod
    /**
     * Specifies the engine specific parameters type.
     */
    val applyType: kotlin.String? = builder.applyType
    /**
     * Specifies the valid data type for the parameter.
     */
    val dataType: kotlin.String? = builder.dataType
    /**
     * Provides a description of the parameter.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates whether (true) or not (false) the parameter can be modified.
     * Some parameters have security or operational implications
     * that prevent them from being changed.
     */
    val isModifiable: kotlin.Boolean = builder.isModifiable
    /**
     * The earliest engine version to which the parameter can apply.
     */
    val minimumEngineVersion: kotlin.String? = builder.minimumEngineVersion
    /**
     * Specifies the name of the parameter.
     */
    val parameterName: kotlin.String? = builder.parameterName
    /**
     * Specifies the value of the parameter.
     */
    val parameterValue: kotlin.String? = builder.parameterValue
    /**
     * Indicates the source of the parameter value.
     */
    val source: kotlin.String? = builder.source
    /**
     * The valid DB engine modes.
     */
    val supportedEngineModes: List<String>? = builder.supportedEngineModes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.Parameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("allowedValues=$allowedValues,")
        append("applyMethod=$applyMethod,")
        append("applyType=$applyType,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isModifiable=$isModifiable,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("parameterName=$parameterName,")
        append("parameterValue=$parameterValue,")
        append("source=$source,")
        append("supportedEngineModes=$supportedEngineModes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (applyMethod?.hashCode() ?: 0)
        result = 31 * result + (applyType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isModifiable.hashCode())
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (parameterValue?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (supportedEngineModes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parameter

        if (allowedValues != other.allowedValues) return false
        if (applyMethod != other.applyMethod) return false
        if (applyType != other.applyType) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isModifiable != other.isModifiable) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (parameterName != other.parameterName) return false
        if (parameterValue != other.parameterValue) return false
        if (source != other.source) return false
        if (supportedEngineModes != other.supportedEngineModes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.Parameter = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the valid range of values for the parameter.
         */
        var allowedValues: kotlin.String? = null
        /**
         * Indicates when to apply parameter updates.
         */
        var applyMethod: aws.sdk.kotlin.services.rds.model.ApplyMethod? = null
        /**
         * Specifies the engine specific parameters type.
         */
        var applyType: kotlin.String? = null
        /**
         * Specifies the valid data type for the parameter.
         */
        var dataType: kotlin.String? = null
        /**
         * Provides a description of the parameter.
         */
        var description: kotlin.String? = null
        /**
         * Indicates whether (true) or not (false) the parameter can be modified.
         * Some parameters have security or operational implications
         * that prevent them from being changed.
         */
        var isModifiable: kotlin.Boolean = false
        /**
         * The earliest engine version to which the parameter can apply.
         */
        var minimumEngineVersion: kotlin.String? = null
        /**
         * Specifies the name of the parameter.
         */
        var parameterName: kotlin.String? = null
        /**
         * Specifies the value of the parameter.
         */
        var parameterValue: kotlin.String? = null
        /**
         * Indicates the source of the parameter value.
         */
        var source: kotlin.String? = null
        /**
         * The valid DB engine modes.
         */
        var supportedEngineModes: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.Parameter) : this() {
            this.allowedValues = x.allowedValues
            this.applyMethod = x.applyMethod
            this.applyType = x.applyType
            this.dataType = x.dataType
            this.description = x.description
            this.isModifiable = x.isModifiable
            this.minimumEngineVersion = x.minimumEngineVersion
            this.parameterName = x.parameterName
            this.parameterValue = x.parameterValue
            this.source = x.source
            this.supportedEngineModes = x.supportedEngineModes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.Parameter = Parameter(this)
    }
}
