// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a pending maintenance action for a resource.
 */
class PendingMaintenanceAction private constructor(builder: Builder) {
    /**
     * The type of pending maintenance action that is available for the resource.
     * Valid actions are system-update, db-upgrade, hardware-maintenance,
     * and ca-certificate-rotation.
     */
    val action: kotlin.String? = builder.action
    /**
     * The date of the maintenance window when the action is applied.
     * The maintenance action is applied to the resource during
     * its first maintenance window after this date.
     */
    val autoAppliedAfterDate: aws.smithy.kotlin.runtime.time.Instant? = builder.autoAppliedAfterDate
    /**
     * The effective date when the pending maintenance action is applied
     * to the resource. This date takes into account opt-in requests received from
     * the ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate,
     * and the ForcedApplyDate. This value is blank if an
     * opt-in request has not been received and nothing has been specified as
     * AutoAppliedAfterDate or ForcedApplyDate.
     */
    val currentApplyDate: aws.smithy.kotlin.runtime.time.Instant? = builder.currentApplyDate
    /**
     * A description providing more detail about the maintenance action.
     */
    val description: kotlin.String? = builder.description
    /**
     * The date when the maintenance action is automatically applied.
     * On this date, the maintenance action is applied to the resource as soon as possible,
     * regardless of the maintenance window for the resource. There might be a delay of
     * one or more days from this date before the maintenance action is applied.
     */
    val forcedApplyDate: aws.smithy.kotlin.runtime.time.Instant? = builder.forcedApplyDate
    /**
     * Indicates the type of opt-in request that has been received for the resource.
     */
    val optInStatus: kotlin.String? = builder.optInStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.PendingMaintenanceAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingMaintenanceAction(")
        append("action=$action,")
        append("autoAppliedAfterDate=$autoAppliedAfterDate,")
        append("currentApplyDate=$currentApplyDate,")
        append("description=$description,")
        append("forcedApplyDate=$forcedApplyDate,")
        append("optInStatus=$optInStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (autoAppliedAfterDate?.hashCode() ?: 0)
        result = 31 * result + (currentApplyDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forcedApplyDate?.hashCode() ?: 0)
        result = 31 * result + (optInStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingMaintenanceAction

        if (action != other.action) return false
        if (autoAppliedAfterDate != other.autoAppliedAfterDate) return false
        if (currentApplyDate != other.currentApplyDate) return false
        if (description != other.description) return false
        if (forcedApplyDate != other.forcedApplyDate) return false
        if (optInStatus != other.optInStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.PendingMaintenanceAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of pending maintenance action that is available for the resource.
         * Valid actions are system-update, db-upgrade, hardware-maintenance,
         * and ca-certificate-rotation.
         */
        var action: kotlin.String? = null
        /**
         * The date of the maintenance window when the action is applied.
         * The maintenance action is applied to the resource during
         * its first maintenance window after this date.
         */
        var autoAppliedAfterDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The effective date when the pending maintenance action is applied
         * to the resource. This date takes into account opt-in requests received from
         * the ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate,
         * and the ForcedApplyDate. This value is blank if an
         * opt-in request has not been received and nothing has been specified as
         * AutoAppliedAfterDate or ForcedApplyDate.
         */
        var currentApplyDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description providing more detail about the maintenance action.
         */
        var description: kotlin.String? = null
        /**
         * The date when the maintenance action is automatically applied.
         * On this date, the maintenance action is applied to the resource as soon as possible,
         * regardless of the maintenance window for the resource. There might be a delay of
         * one or more days from this date before the maintenance action is applied.
         */
        var forcedApplyDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the type of opt-in request that has been received for the resource.
         */
        var optInStatus: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.PendingMaintenanceAction) : this() {
            this.action = x.action
            this.autoAppliedAfterDate = x.autoAppliedAfterDate
            this.currentApplyDate = x.currentApplyDate
            this.description = x.description
            this.forcedApplyDate = x.forcedApplyDate
            this.optInStatus = x.optInStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.PendingMaintenanceAction = PendingMaintenanceAction(this)
    }
}
