// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This data type is used as a response element in the ModifyDBInstance operation and
 * contains changes that will be applied during the next maintenance window.
 */
class PendingModifiedValues private constructor(builder: Builder) {
    /**
     * The allocated storage size for the DB instance specified in gibibytes (GiB).
     */
    val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The automation mode of the RDS Custom DB instance: full or all-paused.
     * If full, the DB instance automates monitoring and instance recovery. If
     * all-paused, the instance pauses automation for the duration set by
     * --resume-full-automation-mode-minutes.
     */
    val automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = builder.automationMode
    /**
     * The number of days for which automated backups are retained.
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The identifier of the CA certificate for the DB instance.
     */
    val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * The name of the compute and memory capacity class for the DB instance.
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The  database identifier for the DB instance.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The DB subnet group for the DB instance.
     */
    val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * The database engine version.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * The Provisioned IOPS value for the DB instance.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The license model for the DB instance.
     * Valid values: license-included | bring-your-own-license |
     * general-public-license
     */
    val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The master credentials for the DB instance.
     */
    val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * A value that indicates that the Single-AZ DB instance will change to a Multi-AZ deployment.
     */
    val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.
     */
    val pendingCloudwatchLogsExports: aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports? = builder.pendingCloudwatchLogsExports
    /**
     * The port for the DB instance.
     */
    val port: kotlin.Int? = builder.port
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class
     * of the DB instance.
     */
    val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation.
     * The minimum value is 60 (default). The maximum value is 1,440.
     */
    val resumeFullAutomationModeTime: aws.smithy.kotlin.runtime.time.Instant? = builder.resumeFullAutomationModeTime
    /**
     * The storage type of the DB instance.
     */
    val storageType: kotlin.String? = builder.storageType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.PendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingModifiedValues(")
        append("allocatedStorage=$allocatedStorage,")
        append("automationMode=$automationMode,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("masterUserPassword=$masterUserPassword,")
        append("multiAz=$multiAz,")
        append("pendingCloudwatchLogsExports=$pendingCloudwatchLogsExports,")
        append("port=$port,")
        append("processorFeatures=$processorFeatures,")
        append("resumeFullAutomationModeTime=$resumeFullAutomationModeTime,")
        append("storageType=$storageType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (automationMode?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (pendingCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (resumeFullAutomationModeTime?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingModifiedValues

        if (allocatedStorage != other.allocatedStorage) return false
        if (automationMode != other.automationMode) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (multiAz != other.multiAz) return false
        if (pendingCloudwatchLogsExports != other.pendingCloudwatchLogsExports) return false
        if (port != other.port) return false
        if (processorFeatures != other.processorFeatures) return false
        if (resumeFullAutomationModeTime != other.resumeFullAutomationModeTime) return false
        if (storageType != other.storageType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.PendingModifiedValues = Builder(this).apply(block).build()

    class Builder {
        /**
         * The allocated storage size for the DB instance specified in gibibytes (GiB).
         */
        var allocatedStorage: kotlin.Int? = null
        /**
         * The automation mode of the RDS Custom DB instance: full or all-paused.
         * If full, the DB instance automates monitoring and instance recovery. If
         * all-paused, the instance pauses automation for the duration set by
         * --resume-full-automation-mode-minutes.
         */
        var automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = null
        /**
         * The number of days for which automated backups are retained.
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The identifier of the CA certificate for the DB instance.
         */
        var caCertificateIdentifier: kotlin.String? = null
        /**
         * The name of the compute and memory capacity class for the DB instance.
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * The  database identifier for the DB instance.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The DB subnet group for the DB instance.
         */
        var dbSubnetGroupName: kotlin.String? = null
        /**
         * The database engine version.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
         */
        var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * The Provisioned IOPS value for the DB instance.
         */
        var iops: kotlin.Int? = null
        /**
         * The license model for the DB instance.
         * Valid values: license-included | bring-your-own-license |
         * general-public-license
         */
        var licenseModel: kotlin.String? = null
        /**
         * The master credentials for the DB instance.
         */
        var masterUserPassword: kotlin.String? = null
        /**
         * A value that indicates that the Single-AZ DB instance will change to a Multi-AZ deployment.
         */
        var multiAz: kotlin.Boolean? = null
        /**
         * A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.
         */
        var pendingCloudwatchLogsExports: aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports? = null
        /**
         * The port for the DB instance.
         */
        var port: kotlin.Int? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class
         * of the DB instance.
         */
        var processorFeatures: List<ProcessorFeature>? = null
        /**
         * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation.
         * The minimum value is 60 (default). The maximum value is 1,440.
         */
        var resumeFullAutomationModeTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The storage type of the DB instance.
         */
        var storageType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.PendingModifiedValues) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.automationMode = x.automationMode
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.masterUserPassword = x.masterUserPassword
            this.multiAz = x.multiAz
            this.pendingCloudwatchLogsExports = x.pendingCloudwatchLogsExports
            this.port = x.port
            this.processorFeatures = x.processorFeatures
            this.resumeFullAutomationModeTime = x.resumeFullAutomationModeTime
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.PendingModifiedValues = PendingModifiedValues(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports] inside the given [block]
         */
        fun pendingCloudwatchLogsExports(block: aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports.Builder.() -> kotlin.Unit) {
            this.pendingCloudwatchLogsExports = aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports.invoke(block)
        }
    }
}
