// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the processor features of a DB instance class.
 * To specify the number of CPU cores, use the coreCount feature name
 * for the Name parameter. To specify the number of threads per core, use the
 * threadsPerCore feature name for the Name parameter.
 * You can set the processor features of the DB instance class for a DB instance when you
 * call one of the following actions:
 *
 *
 *
 * CreateDBInstance
 *
 *
 *
 * ModifyDBInstance
 *
 *
 *
 * RestoreDBInstanceFromDBSnapshot
 *
 *
 *
 * RestoreDBInstanceFromS3
 *
 *
 *
 * RestoreDBInstanceToPointInTime
 *
 *
 *
 * You can view the valid processor values for a particular instance class by calling the
 * DescribeOrderableDBInstanceOptions action and specifying the
 * instance class for the DBInstanceClass parameter.
 * In addition, you can use the following actions for DB instance class processor information:
 *
 *
 *
 * DescribeDBInstances
 *
 *
 *
 * DescribeDBSnapshots
 *
 *
 *
 * DescribeValidDBInstanceModifications
 *
 *
 *
 * If you call DescribeDBInstances, ProcessorFeature returns
 * non-null values only if the following conditions are met:
 *
 *
 * You are accessing an Oracle DB instance.
 *
 * Your Oracle DB instance class supports configuring the number of CPU cores and threads per core.
 *
 * The current number CPU cores and threads is set to a non-default value.
 *
 *
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor">Configuring the
 * Processor of the DB Instance Class in the Amazon RDS User Guide.
 */
class ProcessorFeature private constructor(builder: Builder) {
    /**
     * The name of the processor feature. Valid names are coreCount and threadsPerCore.
     */
    val name: kotlin.String? = builder.name
    /**
     * The value of a processor feature name.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ProcessorFeature = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessorFeature(")
        append("name=$name,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessorFeature

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ProcessorFeature = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the processor feature. Valid names are coreCount and threadsPerCore.
         */
        var name: kotlin.String? = null
        /**
         * The value of a processor feature name.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ProcessorFeature) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ProcessorFeature = ProcessorFeature(this)
    }
}
