// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This data type is used as a response element in the
 * DescribeReservedDBInstances and
 * PurchaseReservedDBInstancesOffering actions.
 */
class ReservedDbInstance private constructor(builder: Builder) {
    /**
     * The currency code for the reserved DB instance.
     */
    val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The DB instance class for the reserved DB instance.
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The number of reserved DB instances.
     */
    val dbInstanceCount: kotlin.Int = builder.dbInstanceCount
    /**
     * The duration of the reservation in seconds.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * The fixed price charged for this reserved DB instance.
     */
    val fixedPrice: kotlin.Double = builder.fixedPrice
    /**
     * The unique identifier for the lease associated with the reserved DB instance.
     *
     * Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.
     */
    val leaseId: kotlin.String? = builder.leaseId
    /**
     * Indicates if the reservation applies to Multi-AZ deployments.
     */
    val multiAz: kotlin.Boolean = builder.multiAz
    /**
     * The offering type of this reserved DB instance.
     */
    val offeringType: kotlin.String? = builder.offeringType
    /**
     * The description of the reserved DB instance.
     */
    val productDescription: kotlin.String? = builder.productDescription
    /**
     * The recurring price charged to run this reserved DB instance.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The Amazon Resource Name (ARN) for the reserved DB instance.
     */
    val reservedDbInstanceArn: kotlin.String? = builder.reservedDbInstanceArn
    /**
     * The unique identifier for the reservation.
     */
    val reservedDbInstanceId: kotlin.String? = builder.reservedDbInstanceId
    /**
     * The offering identifier.
     */
    val reservedDbInstancesOfferingId: kotlin.String? = builder.reservedDbInstancesOfferingId
    /**
     * The time the reservation started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the reserved DB instance.
     */
    val state: kotlin.String? = builder.state
    /**
     * The hourly price charged for this reserved DB instance.
     */
    val usagePrice: kotlin.Double = builder.usagePrice

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ReservedDbInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedDbInstance(")
        append("currencyCode=$currencyCode,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceCount=$dbInstanceCount,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("leaseId=$leaseId,")
        append("multiAz=$multiAz,")
        append("offeringType=$offeringType,")
        append("productDescription=$productDescription,")
        append("recurringCharges=$recurringCharges,")
        append("reservedDbInstanceArn=$reservedDbInstanceArn,")
        append("reservedDbInstanceId=$reservedDbInstanceId,")
        append("reservedDbInstancesOfferingId=$reservedDbInstancesOfferingId,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceCount)
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice.hashCode())
        result = 31 * result + (leaseId?.hashCode() ?: 0)
        result = 31 * result + (multiAz.hashCode())
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedDbInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (reservedDbInstanceId?.hashCode() ?: 0)
        result = 31 * result + (reservedDbInstancesOfferingId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (usagePrice.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedDbInstance

        if (currencyCode != other.currencyCode) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceCount != other.dbInstanceCount) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (leaseId != other.leaseId) return false
        if (multiAz != other.multiAz) return false
        if (offeringType != other.offeringType) return false
        if (productDescription != other.productDescription) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedDbInstanceArn != other.reservedDbInstanceArn) return false
        if (reservedDbInstanceId != other.reservedDbInstanceId) return false
        if (reservedDbInstancesOfferingId != other.reservedDbInstancesOfferingId) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ReservedDbInstance = Builder(this).apply(block).build()

    class Builder {
        /**
         * The currency code for the reserved DB instance.
         */
        var currencyCode: kotlin.String? = null
        /**
         * The DB instance class for the reserved DB instance.
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * The number of reserved DB instances.
         */
        var dbInstanceCount: kotlin.Int = 0
        /**
         * The duration of the reservation in seconds.
         */
        var duration: kotlin.Int = 0
        /**
         * The fixed price charged for this reserved DB instance.
         */
        var fixedPrice: kotlin.Double = 0.0
        /**
         * The unique identifier for the lease associated with the reserved DB instance.
         *
         * Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.
         */
        var leaseId: kotlin.String? = null
        /**
         * Indicates if the reservation applies to Multi-AZ deployments.
         */
        var multiAz: kotlin.Boolean = false
        /**
         * The offering type of this reserved DB instance.
         */
        var offeringType: kotlin.String? = null
        /**
         * The description of the reserved DB instance.
         */
        var productDescription: kotlin.String? = null
        /**
         * The recurring price charged to run this reserved DB instance.
         */
        var recurringCharges: List<RecurringCharge>? = null
        /**
         * The Amazon Resource Name (ARN) for the reserved DB instance.
         */
        var reservedDbInstanceArn: kotlin.String? = null
        /**
         * The unique identifier for the reservation.
         */
        var reservedDbInstanceId: kotlin.String? = null
        /**
         * The offering identifier.
         */
        var reservedDbInstancesOfferingId: kotlin.String? = null
        /**
         * The time the reservation started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the reserved DB instance.
         */
        var state: kotlin.String? = null
        /**
         * The hourly price charged for this reserved DB instance.
         */
        var usagePrice: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ReservedDbInstance) : this() {
            this.currencyCode = x.currencyCode
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceCount = x.dbInstanceCount
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.leaseId = x.leaseId
            this.multiAz = x.multiAz
            this.offeringType = x.offeringType
            this.productDescription = x.productDescription
            this.recurringCharges = x.recurringCharges
            this.reservedDbInstanceArn = x.reservedDbInstanceArn
            this.reservedDbInstanceId = x.reservedDbInstanceId
            this.reservedDbInstancesOfferingId = x.reservedDbInstancesOfferingId
            this.startTime = x.startTime
            this.state = x.state
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ReservedDbInstance = ReservedDbInstance(this)
    }
}
