// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class ResetDbParameterGroupRequest private constructor(builder: Builder) {
    /**
     * The name of the DB parameter group.
     * Constraints:
     *
     *
     * Must match the name of an existing DBParameterGroup.
     */
    val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * To reset the entire DB parameter group, specify the DBParameterGroup
     * name and ResetAllParameters parameters. To reset specific parameters,
     * provide a list of the following: ParameterName and
     * ApplyMethod. A maximum of 20 parameters can be modified in a single
     * request.
     *
     * MySQL
     *
     * Valid Values (for Apply method): immediate | pending-reboot
     *
     * You can use the immediate value with dynamic parameters only. You can use
     * the pending-reboot value for both dynamic and static parameters, and changes
     * are applied when DB instance reboots.
     *
     * MariaDB
     *
     * Valid Values (for Apply method): immediate | pending-reboot
     *
     * You can use the immediate value with dynamic parameters only. You can use
     * the pending-reboot value for both dynamic and static parameters, and changes
     * are applied when DB instance reboots.
     *
     * Oracle
     *
     * Valid Values (for Apply method): pending-reboot
     */
    val parameters: List<Parameter>? = builder.parameters
    /**
     * A value that indicates whether to reset all parameters in the DB parameter group to default values.
     * By default, all parameters in the DB parameter group are reset to default values.
     */
    val resetAllParameters: kotlin.Boolean = builder.resetAllParameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ResetDbParameterGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResetDbParameterGroupRequest(")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("parameters=$parameters,")
        append("resetAllParameters=$resetAllParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbParameterGroupName?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resetAllParameters.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResetDbParameterGroupRequest

        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (parameters != other.parameters) return false
        if (resetAllParameters != other.resetAllParameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ResetDbParameterGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the DB parameter group.
         * Constraints:
         *
         *
         * Must match the name of an existing DBParameterGroup.
         */
        var dbParameterGroupName: kotlin.String? = null
        /**
         * To reset the entire DB parameter group, specify the DBParameterGroup
         * name and ResetAllParameters parameters. To reset specific parameters,
         * provide a list of the following: ParameterName and
         * ApplyMethod. A maximum of 20 parameters can be modified in a single
         * request.
         *
         * MySQL
         *
         * Valid Values (for Apply method): immediate | pending-reboot
         *
         * You can use the immediate value with dynamic parameters only. You can use
         * the pending-reboot value for both dynamic and static parameters, and changes
         * are applied when DB instance reboots.
         *
         * MariaDB
         *
         * Valid Values (for Apply method): immediate | pending-reboot
         *
         * You can use the immediate value with dynamic parameters only. You can use
         * the pending-reboot value for both dynamic and static parameters, and changes
         * are applied when DB instance reboots.
         *
         * Oracle
         *
         * Valid Values (for Apply method): pending-reboot
         */
        var parameters: List<Parameter>? = null
        /**
         * A value that indicates whether to reset all parameters in the DB parameter group to default values.
         * By default, all parameters in the DB parameter group are reset to default values.
         */
        var resetAllParameters: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ResetDbParameterGroupRequest) : this() {
            this.dbParameterGroupName = x.dbParameterGroupName
            this.parameters = x.parameters
            this.resetAllParameters = x.resetAllParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ResetDbParameterGroupRequest = ResetDbParameterGroupRequest(this)
    }
}
