// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class RestoreDbClusterFromS3Request private constructor(builder: Builder) {
    /**
     * A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to
     * 0.
     *
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     *
     * Default: 0
     * Constraints:
     *
     *
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     */
    val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * The number of days for which automated backups of the restored DB cluster are retained. You must specify a minimum value of 1.
     * Default: 1
     * Constraints:
     *
     *
     * Must be a value from 1 to 35
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.
     */
    val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
     */
    val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The database name for the restored DB cluster.
     */
    val databaseName: kotlin.String? = builder.databaseName
    /**
     * The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't case-sensitive.
     * Constraints:
     *
     *
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     *
     * First character must be a letter.
     *
     * Can't end with a hyphen or contain two consecutive hyphens.
     *
     *
     * Example: my-cluster1
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the DB cluster parameter group to associate
     * with the restored DB cluster. If this argument is omitted, default.aurora5.6 is used.
     * Constraints:
     *
     *
     * If supplied, must match the name of an existing DBClusterParameterGroup.
     */
    val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * A DB subnet group to associate with the restored DB cluster.
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * Example: mydbsubnetgroup
     */
    val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * The database can't be deleted when deletion protection is enabled. By default,
     * deletion protection isn't enabled.
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Specify the Active Directory directory ID to restore the DB cluster in.
     * The domain must be created prior to this operation.
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication
     * in the Amazon Aurora User Guide.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     */
    val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values
     * in the list depend on the DB engine being used.
     *
     * Aurora MySQL
     *
     * Possible values are audit, error, general, and slowquery.
     *
     * Aurora PostgreSQL
     *
     * Possible value is postgresql.
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
     */
    val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
     * Management (IAM) accounts to database accounts. By default, mapping isn't
     * enabled.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
     * IAM Database Authentication in the Amazon Aurora User Guide.
     */
    val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The name of the database engine to be used for this DB cluster.
     * Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora), and aurora-postgresql
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine to use.
     * To list all of the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use the following command:
     *
     * aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     * To list all of the available engine versions for aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora), use the following command:
     *
     * aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     * To list all of the available engine versions for aurora-postgresql, use the following command:
     *
     * aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     *
     * Aurora MySQL
     *
     * Example: 5.6.10a, 5.6.mysql_aurora.1.19.2, 5.7.12, 5.7.mysql_aurora.2.04.5, 8.0.mysql_aurora.3.01.0
     *
     *
     * Aurora PostgreSQL
     *
     * Example: 9.6.3, 10.7
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * If the StorageEncrypted parameter is enabled, and you do
     * not specify a value for the KmsKeyId parameter, then
     * Amazon RDS will use your default KMS key. There is a
     * default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services Region.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".
     * Constraints: Must contain from 8 to 41 characters.
     */
    val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The name of the master user for the restored DB cluster.
     * Constraints:
     *
     *
     * Must be 1 to 16 letters or numbers.
     *
     * First character must be a letter.
     *
     * Can't be a reserved word for the chosen database engine.
     */
    val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * A value that indicates that the restored DB cluster should be associated with the specified option group.
     * Permanent options can't be removed from an option group. An option group can't be removed from a
     * DB cluster once it is associated with a DB cluster.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the instances in the restored DB cluster accept connections.
     * Default: 3306
     */
    val port: kotlin.Int? = builder.port
    /**
     * The daily time range during which automated backups are created
     * if automated backups are enabled
     * using the BackupRetentionPeriod parameter.
     * The default is a 30-minute window selected at random from an
     * 8-hour block of time for each Amazon Web Services Region.
     * To view the time blocks available, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">
     * Backup window in the Amazon Aurora User Guide.
     * Constraints:
     *
     *
     * Must be in the format hh24:mi-hh24:mi.
     *
     * Must be in Universal Coordinated Time (UTC).
     *
     * Must not conflict with the preferred maintenance window.
     *
     * Must be at least 30 minutes.
     */
    val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * Format: ddd:hh24:mi-ddd:hh24:mi
     *
     * The default is a 30-minute window selected at random from an
     * 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
     * week. To see the time blocks available, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">
     * Adjusting the Preferred Maintenance Window in the Amazon Aurora User Guide.
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that authorizes
     * Amazon RDS to access the Amazon S3 bucket on your behalf.
     */
    val s3IngestionRoleArn: kotlin.String? = builder.s3IngestionRoleArn
    /**
     * The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster.
     * If you do not specify a SourceS3Prefix value, then the Amazon Aurora DB cluster is
     * created by using all of the files in the Amazon S3 bucket.
     */
    val s3Prefix: kotlin.String? = builder.s3Prefix
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2 in the
     * Amazon Aurora User Guide.
     */
    val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The identifier for the database engine that was backed up to create the files stored in the
     * Amazon S3 bucket.
     * Valid values: mysql
     */
    val sourceEngine: kotlin.String? = builder.sourceEngine
    /**
     * The version of the database that the backup files were created from.
     * MySQL versions 5.5, 5.6, and 5.7 are supported.
     * Example: 5.6.40, 5.7.28
     */
    val sourceEngineVersion: kotlin.String? = builder.sourceEngineVersion
    /**
     * A value that indicates whether the restored DB cluster is encrypted.
     */
    val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * A list of tags.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A list of EC2 VPC security groups to associate with the restored DB cluster.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromS3Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterFromS3Request(")
        append("availabilityZones=$availabilityZones,")
        append("backtrackWindow=$backtrackWindow,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUsername=$masterUsername,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("s3BucketName=$s3BucketName,")
        append("s3IngestionRoleArn=$s3IngestionRoleArn,")
        append("s3Prefix=$s3Prefix,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("sourceEngine=$sourceEngine,")
        append("sourceEngineVersion=$sourceEngineVersion,")
        append("storageEncrypted=$storageEncrypted,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3IngestionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceEngine?.hashCode() ?: 0)
        result = 31 * result + (sourceEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterFromS3Request

        if (availabilityZones != other.availabilityZones) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3IngestionRoleArn != other.s3IngestionRoleArn) return false
        if (s3Prefix != other.s3Prefix) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (sourceEngine != other.sourceEngine) return false
        if (sourceEngineVersion != other.sourceEngineVersion) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromS3Request = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         */
        var availabilityZones: List<String>? = null
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to
         * 0.
         *
         * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         *
         * Default: 0
         * Constraints:
         *
         *
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         */
        var backtrackWindow: kotlin.Long? = null
        /**
         * The number of days for which automated backups of the restored DB cluster are retained. You must specify a minimum value of 1.
         * Default: 1
         * Constraints:
         *
         *
         * Must be a value from 1 to 35
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.
         */
        var characterSetName: kotlin.String? = null
        /**
         * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
         */
        var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The database name for the restored DB cluster.
         */
        var databaseName: kotlin.String? = null
        /**
         * The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't case-sensitive.
         * Constraints:
         *
         *
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         *
         * First character must be a letter.
         *
         * Can't end with a hyphen or contain two consecutive hyphens.
         *
         *
         * Example: my-cluster1
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate
         * with the restored DB cluster. If this argument is omitted, default.aurora5.6 is used.
         * Constraints:
         *
         *
         * If supplied, must match the name of an existing DBClusterParameterGroup.
         */
        var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * A DB subnet group to associate with the restored DB cluster.
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * Example: mydbsubnetgroup
         */
        var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled.
         * The database can't be deleted when deletion protection is enabled. By default,
         * deletion protection isn't enabled.
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * Specify the Active Directory directory ID to restore the DB cluster in.
         * The domain must be created prior to this operation.
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication
         * in the Amazon Aurora User Guide.
         */
        var domain: kotlin.String? = null
        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         */
        var domainIamRoleName: kotlin.String? = null
        /**
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values
         * in the list depend on the DB engine being used.
         *
         * Aurora MySQL
         *
         * Possible values are audit, error, general, and slowquery.
         *
         * Aurora PostgreSQL
         *
         * Possible value is postgresql.
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
         */
        var enableCloudwatchLogsExports: List<String>? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
         * Management (IAM) accounts to database accounts. By default, mapping isn't
         * enabled.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
         * IAM Database Authentication in the Amazon Aurora User Guide.
         */
        var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The name of the database engine to be used for this DB cluster.
         * Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora), and aurora-postgresql
         */
        var engine: kotlin.String? = null
        /**
         * The version number of the database engine to use.
         * To list all of the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use the following command:
         *
         * aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         * To list all of the available engine versions for aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora), use the following command:
         *
         * aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         * To list all of the available engine versions for aurora-postgresql, use the following command:
         *
         * aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         *
         * Aurora MySQL
         *
         * Example: 5.6.10a, 5.6.mysql_aurora.1.19.2, 5.7.12, 5.7.mysql_aurora.2.04.5, 8.0.mysql_aurora.3.01.0
         *
         *
         * Aurora PostgreSQL
         *
         * Example: 9.6.3, 10.7
         */
        var engineVersion: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * If the StorageEncrypted parameter is enabled, and you do
         * not specify a value for the KmsKeyId parameter, then
         * Amazon RDS will use your default KMS key. There is a
         * default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
         * default KMS key for each Amazon Web Services Region.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".
         * Constraints: Must contain from 8 to 41 characters.
         */
        var masterUserPassword: kotlin.String? = null
        /**
         * The name of the master user for the restored DB cluster.
         * Constraints:
         *
         *
         * Must be 1 to 16 letters or numbers.
         *
         * First character must be a letter.
         *
         * Can't be a reserved word for the chosen database engine.
         */
        var masterUsername: kotlin.String? = null
        /**
         * A value that indicates that the restored DB cluster should be associated with the specified option group.
         * Permanent options can't be removed from an option group. An option group can't be removed from a
         * DB cluster once it is associated with a DB cluster.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the instances in the restored DB cluster accept connections.
         * Default: 3306
         */
        var port: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created
         * if automated backups are enabled
         * using the BackupRetentionPeriod parameter.
         * The default is a 30-minute window selected at random from an
         * 8-hour block of time for each Amazon Web Services Region.
         * To view the time blocks available, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">
         * Backup window in the Amazon Aurora User Guide.
         * Constraints:
         *
         *
         * Must be in the format hh24:mi-hh24:mi.
         *
         * Must be in Universal Coordinated Time (UTC).
         *
         * Must not conflict with the preferred maintenance window.
         *
         * Must be at least 30 minutes.
         */
        var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         *
         * The default is a 30-minute window selected at random from an
         * 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
         * week. To see the time blocks available, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">
         * Adjusting the Preferred Maintenance Window in the Amazon Aurora User Guide.
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that authorizes
         * Amazon RDS to access the Amazon S3 bucket on your behalf.
         */
        var s3IngestionRoleArn: kotlin.String? = null
        /**
         * The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster.
         * If you do not specify a SourceS3Prefix value, then the Amazon Aurora DB cluster is
         * created by using all of the files in the Amazon S3 bucket.
         */
        var s3Prefix: kotlin.String? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2 in the
         * Amazon Aurora User Guide.
         */
        var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The identifier for the database engine that was backed up to create the files stored in the
         * Amazon S3 bucket.
         * Valid values: mysql
         */
        var sourceEngine: kotlin.String? = null
        /**
         * The version of the database that the backup files were created from.
         * MySQL versions 5.5, 5.6, and 5.7 are supported.
         * Example: 5.6.40, 5.7.28
         */
        var sourceEngineVersion: kotlin.String? = null
        /**
         * A value that indicates whether the restored DB cluster is encrypted.
         */
        var storageEncrypted: kotlin.Boolean? = null
        /**
         * A list of tags.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
         */
        var tags: List<Tag>? = null
        /**
         * A list of EC2 VPC security groups to associate with the restored DB cluster.
         */
        var vpcSecurityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromS3Request) : this() {
            this.availabilityZones = x.availabilityZones
            this.backtrackWindow = x.backtrackWindow
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.s3BucketName = x.s3BucketName
            this.s3IngestionRoleArn = x.s3IngestionRoleArn
            this.s3Prefix = x.s3Prefix
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.sourceEngine = x.sourceEngine
            this.sourceEngineVersion = x.sourceEngineVersion
            this.storageEncrypted = x.storageEncrypted
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromS3Request = RestoreDbClusterFromS3Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }
    }
}
