// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
class RestoreDbClusterToPointInTimeRequest private constructor(builder: Builder) {
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to
     * 0.
     * Default: 0
     * Constraints:
     *
     *
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *
     *
     * Valid for: Aurora MySQL DB clusters only
     */
    val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The name of the new DB cluster to be created.
     * Constraints:
     *
     *
     * Must contain from 1 to 63 letters, numbers, or hyphens
     *
     * First character must be a letter
     *
     * Can't end with a hyphen or contain two consecutive hyphens
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster,
     * for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services
     * Regions, or for all database engines.
     * For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class in the Amazon RDS User Guide.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * If this argument is omitted, the default DB cluster parameter group for the specified engine is used.
     * Constraints:
     *
     *
     * If supplied, must match the name of an existing DB cluster parameter group.
     *
     * Must be 1 to 255 letters, numbers, or hyphens.
     *
     * First character must be a letter.
     *
     * Can't end with a hyphen or contain two consecutive hyphens.
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The DB subnet group name to use for the new DB cluster.
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * Example: mydbsubnetgroup
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * The database can't be deleted when deletion protection is enabled. By default,
     * deletion protection isn't enabled.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Specify the Active Directory directory ID to restore the DB cluster in.
     * The domain must be created prior to this operation.
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication
     * in the Amazon Aurora User Guide.
     * Valid for: Aurora DB clusters only
     */
    val domain: kotlin.String? = builder.domain
    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * Valid for: Aurora DB clusters only
     */
    val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values
     * in the list depend on the DB engine being used.
     *
     * RDS for MySQL
     *
     * Possible values are error, general, and slowquery.
     *
     * RDS for PostgreSQL
     *
     * Possible values are postgresql and upgrade.
     *
     * Aurora MySQL
     *
     * Possible values are audit, error, general, and slowquery.
     *
     * Aurora PostgreSQL
     *
     * Possible value is postgresql.
     * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide..
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
     * Management (IAM) accounts to database accounts. By default, mapping isn't
     * enabled.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
     * IAM Database Authentication in the Amazon Aurora User Guide.
     * Valid for: Aurora DB clusters only
     */
    val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The engine mode of the new cluster. Specify provisioned or serverless,
     * depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone
     * from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone
     * that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or
     * an encrypted provisioned cluster.
     * Valid for: Aurora DB clusters only
     */
    val engineMode: kotlin.String? = builder.engineMode
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for
     * each DB instance in the Multi-AZ DB cluster.
     * For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance in the Amazon RDS User Guide.
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
     * Valid for: Multi-AZ DB clusters only
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the
     * KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key
     * identified by the KmsKeyId parameter.
     * If you don't specify a value for the KmsKeyId parameter, then the following occurs:
     *
     *
     * If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.
     *
     * If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
     *
     *
     * If DBClusterIdentifier refers to a DB cluster that isn't encrypted, then the restore request
     * is rejected.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the option group for the new DB cluster.
     * DB clusters are associated with a default option group that can't be modified.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the new DB cluster accepts connections.
     * Constraints: A value from 1150-65535.
     * Default: The default port for the engine.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val port: kotlin.Int? = builder.port
    /**
     * A value that indicates whether the DB cluster is publicly accessible.
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address
     * from within the DB cluster's virtual private cloud (VPC). It resolves
     * to the public IP address from outside of the DB cluster's VPC.
     * Access to the DB cluster is ultimately controlled by the security group it uses.
     * That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     * Default: The default behavior varies depending on whether DBSubnetGroupName is specified.
     * If DBSubnetGroupName isn't specified, and PubliclyAccessible isn't specified, the following applies:
     *
     *
     * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
     *
     * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *
     *
     * If DBSubnetGroupName is specified, and PubliclyAccessible isn't specified, the following applies:
     *
     *
     * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     *
     * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     *
     *
     * Valid for: Multi-AZ DB clusters only
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The date and time to restore the DB cluster to.
     * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     * Constraints:
     *
     *
     * Must be before the latest restorable time for the DB instance
     *
     * Must be specified if UseLatestRestorableTime parameter isn't provided
     *
     * Can't be specified if the UseLatestRestorableTime parameter is enabled
     *
     * Can't be specified if the RestoreType parameter is copy-on-write
     *
     *
     *
     * Example: 2015-03-07T23:45:00Z
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreToTime
    /**
     * The type of restore to be performed. You can specify one of the following values:
     *
     *
     *
     * full-copy - The new DB cluster is restored as a full copy of the
     * source DB cluster.
     *
     *
     * copy-on-write - The new DB cluster is restored as a clone of the
     * source DB cluster.
     *
     *
     * Constraints: You can't specify copy-on-write if the engine version of the source DB cluster is earlier than 1.11.
     * If you don't specify a RestoreType value, then the new DB cluster is
     * restored as a full copy of the source DB cluster.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val restoreType: kotlin.String? = builder.restoreType
    /**
     * For DB clusters in serverless DB engine mode, the scaling properties of the DB cluster.
     * Valid for: Aurora DB clusters only
     */
    val scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = builder.scalingConfiguration
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2 in the
     * Amazon Aurora User Guide.
     */
    val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The identifier of the source DB cluster from which to restore.
     * Constraints:
     *
     *
     * Must match the identifier of an existing DBCluster.
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val sourceDbClusterIdentifier: kotlin.String? = builder.sourceDbClusterIdentifier
    /**
     * Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.
     * Valid values: io1
     *
     * When specified, a value for the Iops parameter is required.
     * Default: io1
     *
     * Valid for: Multi-AZ DB clusters only
     */
    val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A value that indicates whether to restore the DB cluster to the latest
     * restorable backup time. By default, the DB cluster isn't restored to the latest
     * restorable backup time.
     * Constraints: Can't be specified if RestoreToTime parameter is provided.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val useLatestRestorableTime: kotlin.Boolean = builder.useLatestRestorableTime
    /**
     * A list of VPC security groups that the new DB cluster belongs to.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterToPointInTimeRequest(")
        append("backtrackWindow=$backtrackWindow,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engineMode=$engineMode,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("restoreToTime=$restoreToTime,")
        append("restoreType=$restoreType,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("useLatestRestorableTime=$useLatestRestorableTime,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backtrackWindow?.hashCode() ?: 0
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (restoreToTime?.hashCode() ?: 0)
        result = 31 * result + (restoreType?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableTime.hashCode())
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterToPointInTimeRequest

        if (backtrackWindow != other.backtrackWindow) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engineMode != other.engineMode) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (restoreToTime != other.restoreToTime) return false
        if (restoreType != other.restoreType) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (useLatestRestorableTime != other.useLatestRestorableTime) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to
         * 0.
         * Default: 0
         * Constraints:
         *
         *
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *
         *
         * Valid for: Aurora MySQL DB clusters only
         */
        var backtrackWindow: kotlin.Long? = null
        /**
         * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The name of the new DB cluster to be created.
         * Constraints:
         *
         *
         * Must contain from 1 to 63 letters, numbers, or hyphens
         *
         * First character must be a letter
         *
         * Can't end with a hyphen or contain two consecutive hyphens
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster,
         * for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services
         * Regions, or for all database engines.
         * For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class in the Amazon RDS User Guide.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate with this DB cluster.
         * If this argument is omitted, the default DB cluster parameter group for the specified engine is used.
         * Constraints:
         *
         *
         * If supplied, must match the name of an existing DB cluster parameter group.
         *
         * Must be 1 to 255 letters, numbers, or hyphens.
         *
         * First character must be a letter.
         *
         * Can't end with a hyphen or contain two consecutive hyphens.
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The DB subnet group name to use for the new DB cluster.
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * Example: mydbsubnetgroup
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled.
         * The database can't be deleted when deletion protection is enabled. By default,
         * deletion protection isn't enabled.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * Specify the Active Directory directory ID to restore the DB cluster in.
         * The domain must be created prior to this operation.
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication
         * in the Amazon Aurora User Guide.
         * Valid for: Aurora DB clusters only
         */
        var domain: kotlin.String? = null
        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * Valid for: Aurora DB clusters only
         */
        var domainIamRoleName: kotlin.String? = null
        /**
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values
         * in the list depend on the DB engine being used.
         *
         * RDS for MySQL
         *
         * Possible values are error, general, and slowquery.
         *
         * RDS for PostgreSQL
         *
         * Possible values are postgresql and upgrade.
         *
         * Aurora MySQL
         *
         * Possible values are audit, error, general, and slowquery.
         *
         * Aurora PostgreSQL
         *
         * Possible value is postgresql.
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide..
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var enableCloudwatchLogsExports: List<String>? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
         * Management (IAM) accounts to database accounts. By default, mapping isn't
         * enabled.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
         * IAM Database Authentication in the Amazon Aurora User Guide.
         * Valid for: Aurora DB clusters only
         */
        var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The engine mode of the new cluster. Specify provisioned or serverless,
         * depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone
         * from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone
         * that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or
         * an encrypted provisioned cluster.
         * Valid for: Aurora DB clusters only
         */
        var engineMode: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for
         * each DB instance in the Multi-AZ DB cluster.
         * For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance in the Amazon RDS User Guide.
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
         * Valid for: Multi-AZ DB clusters only
         */
        var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the
         * KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key
         * identified by the KmsKeyId parameter.
         * If you don't specify a value for the KmsKeyId parameter, then the following occurs:
         *
         *
         * If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.
         *
         * If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
         *
         *
         * If DBClusterIdentifier refers to a DB cluster that isn't encrypted, then the restore request
         * is rejected.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The name of the option group for the new DB cluster.
         * DB clusters are associated with a default option group that can't be modified.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the new DB cluster accepts connections.
         * Constraints: A value from 1150-65535.
         * Default: The default port for the engine.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var port: kotlin.Int? = null
        /**
         * A value that indicates whether the DB cluster is publicly accessible.
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address
         * from within the DB cluster's virtual private cloud (VPC). It resolves
         * to the public IP address from outside of the DB cluster's VPC.
         * Access to the DB cluster is ultimately controlled by the security group it uses.
         * That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         * Default: The default behavior varies depending on whether DBSubnetGroupName is specified.
         * If DBSubnetGroupName isn't specified, and PubliclyAccessible isn't specified, the following applies:
         *
         *
         * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
         *
         * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         *
         *
         * If DBSubnetGroupName is specified, and PubliclyAccessible isn't specified, the following applies:
         *
         *
         * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
         *
         * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         *
         *
         * Valid for: Multi-AZ DB clusters only
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The date and time to restore the DB cluster to.
         * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         * Constraints:
         *
         *
         * Must be before the latest restorable time for the DB instance
         *
         * Must be specified if UseLatestRestorableTime parameter isn't provided
         *
         * Can't be specified if the UseLatestRestorableTime parameter is enabled
         *
         * Can't be specified if the RestoreType parameter is copy-on-write
         *
         *
         *
         * Example: 2015-03-07T23:45:00Z
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of restore to be performed. You can specify one of the following values:
         *
         *
         *
         * full-copy - The new DB cluster is restored as a full copy of the
         * source DB cluster.
         *
         *
         * copy-on-write - The new DB cluster is restored as a clone of the
         * source DB cluster.
         *
         *
         * Constraints: You can't specify copy-on-write if the engine version of the source DB cluster is earlier than 1.11.
         * If you don't specify a RestoreType value, then the new DB cluster is
         * restored as a full copy of the source DB cluster.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var restoreType: kotlin.String? = null
        /**
         * For DB clusters in serverless DB engine mode, the scaling properties of the DB cluster.
         * Valid for: Aurora DB clusters only
         */
        var scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2 in the
         * Amazon Aurora User Guide.
         */
        var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The identifier of the source DB cluster from which to restore.
         * Constraints:
         *
         *
         * Must match the identifier of an existing DBCluster.
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var sourceDbClusterIdentifier: kotlin.String? = null
        /**
         * Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.
         * Valid values: io1
         *
         * When specified, a value for the Iops parameter is required.
         * Default: io1
         *
         * Valid for: Multi-AZ DB clusters only
         */
        var storageType: kotlin.String? = null
        /**
         * A list of tags.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
         */
        var tags: List<Tag>? = null
        /**
         * A value that indicates whether to restore the DB cluster to the latest
         * restorable backup time. By default, the DB cluster isn't restored to the latest
         * restorable backup time.
         * Constraints: Can't be specified if RestoreToTime parameter is provided.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var useLatestRestorableTime: kotlin.Boolean = false
        /**
         * A list of VPC security groups that the new DB cluster belongs to.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var vpcSecurityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest) : this() {
            this.backtrackWindow = x.backtrackWindow
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engineMode = x.engineMode
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.publiclyAccessible = x.publiclyAccessible
            this.restoreToTime = x.restoreToTime
            this.restoreType = x.restoreType
            this.scalingConfiguration = x.scalingConfiguration
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.storageType = x.storageType
            this.tags = x.tags
            this.useLatestRestorableTime = x.useLatestRestorableTime
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest = RestoreDbClusterToPointInTimeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfiguration] inside the given [block]
         */
        fun scalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.rds.model.ScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }
    }
}
