// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
class RestoreDbInstanceToPointInTimeRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether minor version upgrades are applied automatically to the
     * DB instance during the maintenance window.
     * This setting doesn't apply to RDS Custom.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Availability Zone (AZ) where the DB instance will be created.
     * Default: A random, system-chosen Availability Zone.
     * Constraint: You can't specify the AvailabilityZone parameter if the DB instance is a Multi-AZ deployment.
     * Example: us-east-1a
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Specifies where automated backups and manual snapshots are stored for the restored DB instance.
     * Possible values are outposts (Amazon Web Services Outposts) and region (Amazon Web Services Region). The default is region.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working
     * with Amazon RDS on Amazon Web Services Outposts in the Amazon RDS User Guide.
     */
    val backupTarget: kotlin.String? = builder.backupTarget
    /**
     * A value that indicates whether to copy all tags from the restored DB instance to snapshots of the DB instance. By default, tags are not copied.
     */
    val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an
     * RDS Custom DB instance. The instance profile must meet the following requirements:
     *
     *
     * The profile must exist in your account.
     *
     * The profile must have an IAM role that Amazon EC2 has permissions to assume.
     *
     * The instance profile name and the associated IAM role name must start with the prefix AWSRDSCustom.
     *
     *
     * For the list of permissions required for the IAM role, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
     * Configure IAM and your VPC in the Amazon RDS User Guide.
     * This setting is required for RDS Custom.
     */
    val customIamInstanceProfile: kotlin.String? = builder.customIamInstanceProfile
    /**
     * The compute and memory capacity of the Amazon RDS DB instance, for example
     * db.m4.large. Not all DB instance classes are available in all Amazon Web Services
     * Regions, or for all database engines. For the full list of DB instance classes, and
     * availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
     * Class in the Amazon RDS User Guide.
     * Default: The same DBInstanceClass as the original DB instance.
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The database name for the restored DB instance.
     *
     * This parameter isn't supported for the MySQL or MariaDB engines. It also doesn't apply to RDS Custom.
     */
    val dbName: kotlin.String? = builder.dbName
    /**
     * The name of the DB parameter group to associate with this DB instance.
     * If you do not specify a value for DBParameterGroupName, then the default DBParameterGroup
     * for the specified DB engine is used.
     * This setting doesn't apply to RDS Custom.
     * Constraints:
     *
     *
     * If supplied, must match the name of an existing DBParameterGroup.
     *
     * Must be 1 to 255 letters, numbers, or hyphens.
     *
     * First character must be a letter.
     *
     * Can't end with a hyphen or contain two consecutive hyphens.
     */
    val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * The DB subnet group name to use for the new instance.
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     * Example: mydbsubnetgroup
     */
    val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB instance has deletion protection enabled.
     * The database can't be deleted when deletion protection is enabled. By default,
     * deletion protection isn't enabled. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
     * Deleting a DB Instance.
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Specify the Active Directory directory ID to restore the DB instance in.
     * Create the domain before running this command. Currently, you can create only the MySQL, Microsoft SQL
     * Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
     * This setting doesn't apply to RDS Custom.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
     * Kerberos Authentication in the Amazon RDS User Guide.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * This setting doesn't apply to RDS Custom.
     */
    val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of logs that the restored DB instance is to export to CloudWatch Logs. The values
     * in the list depend on the DB engine being used. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide.
     * This setting doesn't apply to RDS Custom.
     */
    val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
     * A CoIP provides local or external connectivity to resources in
     * your Outpost subnets through your on-premises network. For some use cases, a CoIP can
     * provide lower latency for connections to the DB instance from outside of its virtual
     * private cloud (VPC) on your local network.
     * This setting doesn't apply to RDS Custom.
     * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts
     * in the Amazon RDS User Guide.
     * For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses
     * in the Amazon Web Services Outposts User Guide.
     */
    val enableCustomerOwnedIp: kotlin.Boolean? = builder.enableCustomerOwnedIp
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
     * (IAM) accounts to database accounts. By default, mapping isn't enabled.
     * This setting doesn't apply to RDS Custom.
     * For more information about IAM database authentication, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
     * IAM Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide.
     */
    val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The database engine to use for the new instance.
     * This setting doesn't apply to RDS Custom.
     * Default: The same as source
     * Constraint: Must be compatible with the engine of the source
     * Valid Values:
     *
     *
     *
     * mariadb
     *
     *
     *
     * mysql
     *
     *
     *
     * oracle-ee
     *
     *
     *
     * oracle-ee-cdb
     *
     *
     *
     * oracle-se2
     *
     *
     *
     * oracle-se2-cdb
     *
     *
     *
     * postgres
     *
     *
     *
     * sqlserver-ee
     *
     *
     *
     * sqlserver-se
     *
     *
     *
     * sqlserver-ex
     *
     *
     *
     * sqlserver-web
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.
     * Constraints: Must be an integer greater than 1000.
     *
     * SQL Server
     *
     * Setting the IOPS value for the SQL Server database engine isn't supported.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * License model information for the restored DB instance.
     * This setting doesn't apply to RDS Custom.
     * Default: Same as source.
     * Valid values:  license-included | bring-your-own-license | general-public-license
     */
    val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * For more information about this setting, including limitations that apply to it, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
     * Managing capacity automatically with Amazon RDS storage autoscaling
     * in the Amazon RDS User Guide.
     * This setting doesn't apply to RDS Custom.
     */
    val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * A value that indicates whether the DB instance is a Multi-AZ deployment.
     * This setting doesn't apply to RDS Custom.
     * Constraint: You can't specify the AvailabilityZone parameter if the DB instance is a
     * Multi-AZ deployment.
     */
    val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The name of the option group to be used for the restored DB instance.
     *
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
     * option group, and that option group can't be removed from a DB instance after it is associated with a DB instance
     * This setting doesn't apply to RDS Custom.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the database accepts connections.
     * Constraints: Value must be 1150-65535
     *
     * Default: The same port as the original DB instance.
     */
    val port: kotlin.Int? = builder.port
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * This setting doesn't apply to RDS Custom.
     */
    val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * A value that indicates whether the DB instance is publicly accessible.
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint
     * resolves to the private IP address from within the DB cluster's virtual private cloud
     * (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access
     * to the DB cluster is ultimately controlled by the security group it uses. That public
     * access isn't permitted if the security group assigned to the DB cluster doesn't permit
     * it.
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     * For more information, see CreateDBInstance.
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The date and time to restore from.
     * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     * Constraints:
     *
     *
     * Must be before the latest restorable time for the DB instance
     *
     * Can't be specified if the UseLatestRestorableTime parameter is enabled
     *
     *
     * Example: 2009-09-07T23:45:00Z
     */
    val restoreTime: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreTime
    /**
     * The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example,
     * arn:aws:rds:useast-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE.
     * This setting doesn't apply to RDS Custom.
     */
    val sourceDbInstanceAutomatedBackupsArn: kotlin.String? = builder.sourceDbInstanceAutomatedBackupsArn
    /**
     * The identifier of the source DB instance from which to restore.
     * Constraints:
     *
     *
     * Must match the identifier of an existing DB instance.
     */
    val sourceDbInstanceIdentifier: kotlin.String? = builder.sourceDbInstanceIdentifier
    /**
     * The resource ID of the source DB instance from which to restore.
     */
    val sourceDbiResourceId: kotlin.String? = builder.sourceDbiResourceId
    /**
     * Specifies the storage type to be associated with the DB instance.
     * Valid values: standard | gp2 | io1
     *
     * If you specify io1, you must also include a value for the
     * Iops parameter.
     * Default: io1 if the Iops parameter
     * is specified, otherwise gp2
     */
    val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The name of the new DB instance to be created.
     * Constraints:
     *
     *
     * Must contain from 1 to 63 letters, numbers, or hyphens
     *
     * First character must be a letter
     *
     * Can't end with a hyphen or contain two consecutive hyphens
     */
    val targetDbInstanceIdentifier: kotlin.String? = builder.targetDbInstanceIdentifier
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * This setting doesn't apply to RDS Custom.
     */
    val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The password for the given ARN from the key store in order to access the device.
     * This setting doesn't apply to RDS Custom.
     */
    val tdeCredentialPassword: kotlin.String? = builder.tdeCredentialPassword
    /**
     * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
     * This setting doesn't apply to RDS Custom.
     */
    val useDefaultProcessorFeatures: kotlin.Boolean? = builder.useDefaultProcessorFeatures
    /**
     * A value that indicates whether the DB instance is restored from the latest backup time. By default, the DB instance
     * isn't restored from the latest backup time.
     * Constraints: Can't be specified if the RestoreTime parameter is provided.
     */
    val useLatestRestorableTime: kotlin.Boolean = builder.useLatestRestorableTime
    /**
     * A list of EC2 VPC security groups to associate with this DB instance.
     * Default: The default EC2 VPC security group for the DB subnet group's VPC.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceToPointInTimeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbInstanceToPointInTimeRequest(")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupTarget=$backupTarget,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("customIamInstanceProfile=$customIamInstanceProfile,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbName=$dbName,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableCustomerOwnedIp=$enableCustomerOwnedIp,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engine=$engine,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("multiAz=$multiAz,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("processorFeatures=$processorFeatures,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("restoreTime=$restoreTime,")
        append("sourceDbInstanceAutomatedBackupsArn=$sourceDbInstanceAutomatedBackupsArn,")
        append("sourceDbInstanceIdentifier=$sourceDbInstanceIdentifier,")
        append("sourceDbiResourceId=$sourceDbiResourceId,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("targetDbInstanceIdentifier=$targetDbInstanceIdentifier,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("tdeCredentialPassword=$tdeCredentialPassword,")
        append("useDefaultProcessorFeatures=$useDefaultProcessorFeatures,")
        append("useLatestRestorableTime=$useLatestRestorableTime,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMinorVersionUpgrade?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupTarget?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (customIamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableCustomerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (restoreTime?.hashCode() ?: 0)
        result = 31 * result + (sourceDbInstanceAutomatedBackupsArn?.hashCode() ?: 0)
        result = 31 * result + (sourceDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialPassword?.hashCode() ?: 0)
        result = 31 * result + (useDefaultProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableTime.hashCode())
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbInstanceToPointInTimeRequest

        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupTarget != other.backupTarget) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (customIamInstanceProfile != other.customIamInstanceProfile) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbName != other.dbName) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableCustomerOwnedIp != other.enableCustomerOwnedIp) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engine != other.engine) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (multiAz != other.multiAz) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (processorFeatures != other.processorFeatures) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (restoreTime != other.restoreTime) return false
        if (sourceDbInstanceAutomatedBackupsArn != other.sourceDbInstanceAutomatedBackupsArn) return false
        if (sourceDbInstanceIdentifier != other.sourceDbInstanceIdentifier) return false
        if (sourceDbiResourceId != other.sourceDbiResourceId) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (targetDbInstanceIdentifier != other.targetDbInstanceIdentifier) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (tdeCredentialPassword != other.tdeCredentialPassword) return false
        if (useDefaultProcessorFeatures != other.useDefaultProcessorFeatures) return false
        if (useLatestRestorableTime != other.useLatestRestorableTime) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceToPointInTimeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that indicates whether minor version upgrades are applied automatically to the
         * DB instance during the maintenance window.
         * This setting doesn't apply to RDS Custom.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Availability Zone (AZ) where the DB instance will be created.
         * Default: A random, system-chosen Availability Zone.
         * Constraint: You can't specify the AvailabilityZone parameter if the DB instance is a Multi-AZ deployment.
         * Example: us-east-1a
         */
        var availabilityZone: kotlin.String? = null
        /**
         * Specifies where automated backups and manual snapshots are stored for the restored DB instance.
         * Possible values are outposts (Amazon Web Services Outposts) and region (Amazon Web Services Region). The default is region.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working
         * with Amazon RDS on Amazon Web Services Outposts in the Amazon RDS User Guide.
         */
        var backupTarget: kotlin.String? = null
        /**
         * A value that indicates whether to copy all tags from the restored DB instance to snapshots of the DB instance. By default, tags are not copied.
         */
        var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The instance profile associated with the underlying Amazon EC2 instance of an
         * RDS Custom DB instance. The instance profile must meet the following requirements:
         *
         *
         * The profile must exist in your account.
         *
         * The profile must have an IAM role that Amazon EC2 has permissions to assume.
         *
         * The instance profile name and the associated IAM role name must start with the prefix AWSRDSCustom.
         *
         *
         * For the list of permissions required for the IAM role, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
         * Configure IAM and your VPC in the Amazon RDS User Guide.
         * This setting is required for RDS Custom.
         */
        var customIamInstanceProfile: kotlin.String? = null
        /**
         * The compute and memory capacity of the Amazon RDS DB instance, for example
         * db.m4.large. Not all DB instance classes are available in all Amazon Web Services
         * Regions, or for all database engines. For the full list of DB instance classes, and
         * availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
         * Class in the Amazon RDS User Guide.
         * Default: The same DBInstanceClass as the original DB instance.
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * The database name for the restored DB instance.
         *
         * This parameter isn't supported for the MySQL or MariaDB engines. It also doesn't apply to RDS Custom.
         */
        var dbName: kotlin.String? = null
        /**
         * The name of the DB parameter group to associate with this DB instance.
         * If you do not specify a value for DBParameterGroupName, then the default DBParameterGroup
         * for the specified DB engine is used.
         * This setting doesn't apply to RDS Custom.
         * Constraints:
         *
         *
         * If supplied, must match the name of an existing DBParameterGroup.
         *
         * Must be 1 to 255 letters, numbers, or hyphens.
         *
         * First character must be a letter.
         *
         * Can't end with a hyphen or contain two consecutive hyphens.
         */
        var dbParameterGroupName: kotlin.String? = null
        /**
         * The DB subnet group name to use for the new instance.
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         * Example: mydbsubnetgroup
         */
        var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance has deletion protection enabled.
         * The database can't be deleted when deletion protection is enabled. By default,
         * deletion protection isn't enabled. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
         * Deleting a DB Instance.
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * Specify the Active Directory directory ID to restore the DB instance in.
         * Create the domain before running this command. Currently, you can create only the MySQL, Microsoft SQL
         * Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
         * This setting doesn't apply to RDS Custom.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
         * Kerberos Authentication in the Amazon RDS User Guide.
         */
        var domain: kotlin.String? = null
        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * This setting doesn't apply to RDS Custom.
         */
        var domainIamRoleName: kotlin.String? = null
        /**
         * The list of logs that the restored DB instance is to export to CloudWatch Logs. The values
         * in the list depend on the DB engine being used. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide.
         * This setting doesn't apply to RDS Custom.
         */
        var enableCloudwatchLogsExports: List<String>? = null
        /**
         * A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
         * A CoIP provides local or external connectivity to resources in
         * your Outpost subnets through your on-premises network. For some use cases, a CoIP can
         * provide lower latency for connections to the DB instance from outside of its virtual
         * private cloud (VPC) on your local network.
         * This setting doesn't apply to RDS Custom.
         * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts
         * in the Amazon RDS User Guide.
         * For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses
         * in the Amazon Web Services Outposts User Guide.
         */
        var enableCustomerOwnedIp: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management
         * (IAM) accounts to database accounts. By default, mapping isn't enabled.
         * This setting doesn't apply to RDS Custom.
         * For more information about IAM database authentication, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
         * IAM Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide.
         */
        var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The database engine to use for the new instance.
         * This setting doesn't apply to RDS Custom.
         * Default: The same as source
         * Constraint: Must be compatible with the engine of the source
         * Valid Values:
         *
         *
         *
         * mariadb
         *
         *
         *
         * mysql
         *
         *
         *
         * oracle-ee
         *
         *
         *
         * oracle-ee-cdb
         *
         *
         *
         * oracle-se2
         *
         *
         *
         * oracle-se2-cdb
         *
         *
         *
         * postgres
         *
         *
         *
         * sqlserver-ee
         *
         *
         *
         * sqlserver-se
         *
         *
         *
         * sqlserver-ex
         *
         *
         *
         * sqlserver-web
         */
        var engine: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.
         * Constraints: Must be an integer greater than 1000.
         *
         * SQL Server
         *
         * Setting the IOPS value for the SQL Server database engine isn't supported.
         */
        var iops: kotlin.Int? = null
        /**
         * License model information for the restored DB instance.
         * This setting doesn't apply to RDS Custom.
         * Default: Same as source.
         * Valid values:  license-included | bring-your-own-license | general-public-license
         */
        var licenseModel: kotlin.String? = null
        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         * For more information about this setting, including limitations that apply to it, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
         * Managing capacity automatically with Amazon RDS storage autoscaling
         * in the Amazon RDS User Guide.
         * This setting doesn't apply to RDS Custom.
         */
        var maxAllocatedStorage: kotlin.Int? = null
        /**
         * A value that indicates whether the DB instance is a Multi-AZ deployment.
         * This setting doesn't apply to RDS Custom.
         * Constraint: You can't specify the AvailabilityZone parameter if the DB instance is a
         * Multi-AZ deployment.
         */
        var multiAz: kotlin.Boolean? = null
        /**
         * The name of the option group to be used for the restored DB instance.
         *
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
         * option group, and that option group can't be removed from a DB instance after it is associated with a DB instance
         * This setting doesn't apply to RDS Custom.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the database accepts connections.
         * Constraints: Value must be 1150-65535
         *
         * Default: The same port as the original DB instance.
         */
        var port: kotlin.Int? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * This setting doesn't apply to RDS Custom.
         */
        var processorFeatures: List<ProcessorFeature>? = null
        /**
         * A value that indicates whether the DB instance is publicly accessible.
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint
         * resolves to the private IP address from within the DB cluster's virtual private cloud
         * (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access
         * to the DB cluster is ultimately controlled by the security group it uses. That public
         * access isn't permitted if the security group assigned to the DB cluster doesn't permit
         * it.
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         * For more information, see CreateDBInstance.
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The date and time to restore from.
         * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         * Constraints:
         *
         *
         * Must be before the latest restorable time for the DB instance
         *
         * Can't be specified if the UseLatestRestorableTime parameter is enabled
         *
         *
         * Example: 2009-09-07T23:45:00Z
         */
        var restoreTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example,
         * arn:aws:rds:useast-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE.
         * This setting doesn't apply to RDS Custom.
         */
        var sourceDbInstanceAutomatedBackupsArn: kotlin.String? = null
        /**
         * The identifier of the source DB instance from which to restore.
         * Constraints:
         *
         *
         * Must match the identifier of an existing DB instance.
         */
        var sourceDbInstanceIdentifier: kotlin.String? = null
        /**
         * The resource ID of the source DB instance from which to restore.
         */
        var sourceDbiResourceId: kotlin.String? = null
        /**
         * Specifies the storage type to be associated with the DB instance.
         * Valid values: standard | gp2 | io1
         *
         * If you specify io1, you must also include a value for the
         * Iops parameter.
         * Default: io1 if the Iops parameter
         * is specified, otherwise gp2
         */
        var storageType: kotlin.String? = null
        /**
         * A list of tags.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
         */
        var tags: List<Tag>? = null
        /**
         * The name of the new DB instance to be created.
         * Constraints:
         *
         *
         * Must contain from 1 to 63 letters, numbers, or hyphens
         *
         * First character must be a letter
         *
         * Can't end with a hyphen or contain two consecutive hyphens
         */
        var targetDbInstanceIdentifier: kotlin.String? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         * This setting doesn't apply to RDS Custom.
         */
        var tdeCredentialArn: kotlin.String? = null
        /**
         * The password for the given ARN from the key store in order to access the device.
         * This setting doesn't apply to RDS Custom.
         */
        var tdeCredentialPassword: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
         * This setting doesn't apply to RDS Custom.
         */
        var useDefaultProcessorFeatures: kotlin.Boolean? = null
        /**
         * A value that indicates whether the DB instance is restored from the latest backup time. By default, the DB instance
         * isn't restored from the latest backup time.
         * Constraints: Can't be specified if the RestoreTime parameter is provided.
         */
        var useLatestRestorableTime: kotlin.Boolean = false
        /**
         * A list of EC2 VPC security groups to associate with this DB instance.
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         */
        var vpcSecurityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RestoreDbInstanceToPointInTimeRequest) : this() {
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupTarget = x.backupTarget
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.customIamInstanceProfile = x.customIamInstanceProfile
            this.dbInstanceClass = x.dbInstanceClass
            this.dbName = x.dbName
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableCustomerOwnedIp = x.enableCustomerOwnedIp
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engine = x.engine
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.multiAz = x.multiAz
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.processorFeatures = x.processorFeatures
            this.publiclyAccessible = x.publiclyAccessible
            this.restoreTime = x.restoreTime
            this.sourceDbInstanceAutomatedBackupsArn = x.sourceDbInstanceAutomatedBackupsArn
            this.sourceDbInstanceIdentifier = x.sourceDbInstanceIdentifier
            this.sourceDbiResourceId = x.sourceDbiResourceId
            this.storageType = x.storageType
            this.tags = x.tags
            this.targetDbInstanceIdentifier = x.targetDbInstanceIdentifier
            this.tdeCredentialArn = x.tdeCredentialArn
            this.tdeCredentialPassword = x.tdeCredentialPassword
            this.useDefaultProcessorFeatures = x.useDefaultProcessorFeatures
            this.useLatestRestorableTime = x.useLatestRestorableTime
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceToPointInTimeRequest = RestoreDbInstanceToPointInTimeRequest(this)
    }
}
