// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Shows the scaling configuration for an Aurora DB cluster in serverless DB engine mode.
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless v1 in the
 * Amazon Aurora User Guide.
 */
class ScalingConfigurationInfo private constructor(builder: Builder) {
    /**
     * A value that indicates whether automatic pause is allowed for the Aurora DB cluster
     * in serverless DB engine mode.
     * When the value is set to false for an Aurora Serverless v1 DB cluster, the DB cluster automatically resumes.
     */
    val autoPause: kotlin.Boolean? = builder.autoPause
    /**
     * The maximum capacity for an Aurora DB cluster in serverless DB engine mode.
     */
    val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The maximum capacity for the Aurora DB cluster in serverless DB engine
     * mode.
     */
    val minCapacity: kotlin.Int? = builder.minCapacity
    /**
     * The number of seconds before scaling times out. What happens when an attempted scaling action times out
     * is determined by the TimeoutAction setting.
     */
    val secondsBeforeTimeout: kotlin.Int? = builder.secondsBeforeTimeout
    /**
     * The remaining amount of time, in seconds, before the Aurora DB cluster in
     * serverless mode is paused. A DB cluster can be paused only when
     * it's idle (it has no connections).
     */
    val secondsUntilAutoPause: kotlin.Int? = builder.secondsUntilAutoPause
    /**
     * The action that occurs when Aurora times out while attempting to change the capacity of an
     * Aurora Serverless v1 cluster. The value is either ForceApplyCapacityChange or
     * RollbackCapacityChange.
     *
     * ForceApplyCapacityChange, the default, sets the capacity to the specified value as soon as possible.
     *
     * RollbackCapacityChange ignores the capacity change if a scaling point isn't found in the timeout period.
     */
    val timeoutAction: kotlin.String? = builder.timeoutAction

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingConfigurationInfo(")
        append("autoPause=$autoPause,")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity,")
        append("secondsBeforeTimeout=$secondsBeforeTimeout,")
        append("secondsUntilAutoPause=$secondsUntilAutoPause,")
        append("timeoutAction=$timeoutAction)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoPause?.hashCode() ?: 0
        result = 31 * result + (maxCapacity ?: 0)
        result = 31 * result + (minCapacity ?: 0)
        result = 31 * result + (secondsBeforeTimeout ?: 0)
        result = 31 * result + (secondsUntilAutoPause ?: 0)
        result = 31 * result + (timeoutAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingConfigurationInfo

        if (autoPause != other.autoPause) return false
        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false
        if (secondsBeforeTimeout != other.secondsBeforeTimeout) return false
        if (secondsUntilAutoPause != other.secondsUntilAutoPause) return false
        if (timeoutAction != other.timeoutAction) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that indicates whether automatic pause is allowed for the Aurora DB cluster
         * in serverless DB engine mode.
         * When the value is set to false for an Aurora Serverless v1 DB cluster, the DB cluster automatically resumes.
         */
        var autoPause: kotlin.Boolean? = null
        /**
         * The maximum capacity for an Aurora DB cluster in serverless DB engine mode.
         */
        var maxCapacity: kotlin.Int? = null
        /**
         * The maximum capacity for the Aurora DB cluster in serverless DB engine
         * mode.
         */
        var minCapacity: kotlin.Int? = null
        /**
         * The number of seconds before scaling times out. What happens when an attempted scaling action times out
         * is determined by the TimeoutAction setting.
         */
        var secondsBeforeTimeout: kotlin.Int? = null
        /**
         * The remaining amount of time, in seconds, before the Aurora DB cluster in
         * serverless mode is paused. A DB cluster can be paused only when
         * it's idle (it has no connections).
         */
        var secondsUntilAutoPause: kotlin.Int? = null
        /**
         * The action that occurs when Aurora times out while attempting to change the capacity of an
         * Aurora Serverless v1 cluster. The value is either ForceApplyCapacityChange or
         * RollbackCapacityChange.
         *
         * ForceApplyCapacityChange, the default, sets the capacity to the specified value as soon as possible.
         *
         * RollbackCapacityChange ignores the capacity change if a scaling point isn't found in the timeout period.
         */
        var timeoutAction: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo) : this() {
            this.autoPause = x.autoPause
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
            this.secondsBeforeTimeout = x.secondsBeforeTimeout
            this.secondsUntilAutoPause = x.secondsUntilAutoPause
            this.timeoutAction = x.timeoutAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo = ScalingConfigurationInfo(this)
    }
}
