// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class StartActivityStreamRequest private constructor(builder: Builder) {
    /**
     * Specifies whether or not the database activity stream is to start as soon as possible,
     * regardless of the maintenance window for the database.
     */
    val applyImmediately: kotlin.Boolean? = builder.applyImmediately
    /**
     * Specifies whether the database activity stream includes engine-native audit fields. This option only applies
     * to an Oracle DB instance. By default, no engine-native audit fields are included.
     */
    val engineNativeAuditFieldsIncluded: kotlin.Boolean? = builder.engineNativeAuditFieldsIncluded
    /**
     * The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream.
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the mode of the database activity stream.
     * Database events such as a change or access generate an activity stream event.
     * The database session can handle these events either synchronously or asynchronously.
     */
    val mode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = builder.mode
    /**
     * The Amazon Resource Name (ARN) of the DB cluster,
     * for example, arn:aws:rds:us-east-1:12345667890:cluster:das-cluster.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.StartActivityStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartActivityStreamRequest(")
        append("applyImmediately=$applyImmediately,")
        append("engineNativeAuditFieldsIncluded=$engineNativeAuditFieldsIncluded,")
        append("kmsKeyId=$kmsKeyId,")
        append("mode=$mode,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately?.hashCode() ?: 0
        result = 31 * result + (engineNativeAuditFieldsIncluded?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartActivityStreamRequest

        if (applyImmediately != other.applyImmediately) return false
        if (engineNativeAuditFieldsIncluded != other.engineNativeAuditFieldsIncluded) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (mode != other.mode) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.StartActivityStreamRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether or not the database activity stream is to start as soon as possible,
         * regardless of the maintenance window for the database.
         */
        var applyImmediately: kotlin.Boolean? = null
        /**
         * Specifies whether the database activity stream includes engine-native audit fields. This option only applies
         * to an Oracle DB instance. By default, no engine-native audit fields are included.
         */
        var engineNativeAuditFieldsIncluded: kotlin.Boolean? = null
        /**
         * The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream.
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the mode of the database activity stream.
         * Database events such as a change or access generate an activity stream event.
         * The database session can handle these events either synchronously or asynchronously.
         */
        var mode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = null
        /**
         * The Amazon Resource Name (ARN) of the DB cluster,
         * for example, arn:aws:rds:us-east-1:12345667890:cluster:das-cluster.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.StartActivityStreamRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.engineNativeAuditFieldsIncluded = x.engineNativeAuditFieldsIncluded
            this.kmsKeyId = x.kmsKeyId
            this.mode = x.mode
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.StartActivityStreamRequest = StartActivityStreamRequest(this)
    }
}
