// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class StartDbInstanceAutomatedBackupsReplicationRequest private constructor(builder: Builder) {
    /**
     * The retention period for the replicated automated backups.
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the
     * Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for example,
     * arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * A URL that contains a Signature Version 4 signed request for the StartDBInstanceAutomatedBackupsReplication action to be
     * called in the Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for the
     * StartDBInstanceAutomatedBackupsReplication API action that can be executed in the Amazon Web Services Region that contains
     * the source DB instance.
     */
    val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example,
     * arn:aws:rds:us-west-2:123456789012:db:mydatabase.
     */
    val sourceDbInstanceArn: kotlin.String? = builder.sourceDbInstanceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDbInstanceAutomatedBackupsReplicationRequest(")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("kmsKeyId=$kmsKeyId,")
        append("preSignedUrl=$preSignedUrl,")
        append("sourceDbInstanceArn=$sourceDbInstanceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupRetentionPeriod ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceDbInstanceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDbInstanceAutomatedBackupsReplicationRequest

        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (sourceDbInstanceArn != other.sourceDbInstanceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The retention period for the replicated automated backups.
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the
         * Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for example,
         * arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * A URL that contains a Signature Version 4 signed request for the StartDBInstanceAutomatedBackupsReplication action to be
         * called in the Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for the
         * StartDBInstanceAutomatedBackupsReplication API action that can be executed in the Amazon Web Services Region that contains
         * the source DB instance.
         */
        var preSignedUrl: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example,
         * arn:aws:rds:us-west-2:123456789012:db:mydatabase.
         */
        var sourceDbInstanceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest) : this() {
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.kmsKeyId = x.kmsKeyId
            this.preSignedUrl = x.preSignedUrl
            this.sourceDbInstanceArn = x.sourceDbInstanceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = StartDbInstanceAutomatedBackupsReplicationRequest(this)
    }
}
