// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * This data type is used as a response element for the DescribeDBSubnetGroups operation.
 */
class Subnet private constructor(builder: Builder) {
    /**
     * Contains Availability Zone information.
     * This data type is used as an element in the OrderableDBInstanceOption
     * data type.
     */
    val subnetAvailabilityZone: aws.sdk.kotlin.services.rds.model.AvailabilityZone? = builder.subnetAvailabilityZone
    /**
     * The identifier of the subnet.
     */
    val subnetIdentifier: kotlin.String? = builder.subnetIdentifier
    /**
     * If the subnet is associated with an Outpost, this value specifies the Outpost.
     * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts
     * in the Amazon RDS User Guide.
     */
    val subnetOutpost: aws.sdk.kotlin.services.rds.model.Outpost? = builder.subnetOutpost
    /**
     * The status of the subnet.
     */
    val subnetStatus: kotlin.String? = builder.subnetStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.Subnet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Subnet(")
        append("subnetAvailabilityZone=$subnetAvailabilityZone,")
        append("subnetIdentifier=$subnetIdentifier,")
        append("subnetOutpost=$subnetOutpost,")
        append("subnetStatus=$subnetStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = subnetAvailabilityZone?.hashCode() ?: 0
        result = 31 * result + (subnetIdentifier?.hashCode() ?: 0)
        result = 31 * result + (subnetOutpost?.hashCode() ?: 0)
        result = 31 * result + (subnetStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Subnet

        if (subnetAvailabilityZone != other.subnetAvailabilityZone) return false
        if (subnetIdentifier != other.subnetIdentifier) return false
        if (subnetOutpost != other.subnetOutpost) return false
        if (subnetStatus != other.subnetStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.Subnet = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains Availability Zone information.
         * This data type is used as an element in the OrderableDBInstanceOption
         * data type.
         */
        var subnetAvailabilityZone: aws.sdk.kotlin.services.rds.model.AvailabilityZone? = null
        /**
         * The identifier of the subnet.
         */
        var subnetIdentifier: kotlin.String? = null
        /**
         * If the subnet is associated with an Outpost, this value specifies the Outpost.
         * For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts
         * in the Amazon RDS User Guide.
         */
        var subnetOutpost: aws.sdk.kotlin.services.rds.model.Outpost? = null
        /**
         * The status of the subnet.
         */
        var subnetStatus: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.Subnet) : this() {
            this.subnetAvailabilityZone = x.subnetAvailabilityZone
            this.subnetIdentifier = x.subnetIdentifier
            this.subnetOutpost = x.subnetOutpost
            this.subnetStatus = x.subnetStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.Subnet = Subnet(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.AvailabilityZone] inside the given [block]
         */
        fun subnetAvailabilityZone(block: aws.sdk.kotlin.services.rds.model.AvailabilityZone.Builder.() -> kotlin.Unit) {
            this.subnetAvailabilityZone = aws.sdk.kotlin.services.rds.model.AvailabilityZone.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.Outpost] inside the given [block]
         */
        fun subnetOutpost(block: aws.sdk.kotlin.services.rds.model.Outpost.Builder.() -> kotlin.Unit) {
            this.subnetOutpost = aws.sdk.kotlin.services.rds.model.Outpost.invoke(block)
        }
    }
}
