// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Returns the details of authentication used by a proxy to log in as a specific database user.
 */
class UserAuthConfigInfo private constructor(builder: Builder) {
    /**
     * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
     */
    val authScheme: aws.sdk.kotlin.services.rds.model.AuthScheme? = builder.authScheme
    /**
     * A user-specified description about the authentication used by a proxy to log in as a specific database user.
     */
    val description: kotlin.String? = builder.description
    /**
     * Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.
     */
    val iamAuth: aws.sdk.kotlin.services.rds.model.IamAuthMode? = builder.iamAuth
    /**
     * The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate
     * to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * The name of the database user to which the proxy connects.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.UserAuthConfigInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserAuthConfigInfo(")
        append("authScheme=$authScheme,")
        append("description=$description,")
        append("iamAuth=$iamAuth,")
        append("secretArn=$secretArn,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authScheme?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (iamAuth?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserAuthConfigInfo

        if (authScheme != other.authScheme) return false
        if (description != other.description) return false
        if (iamAuth != other.iamAuth) return false
        if (secretArn != other.secretArn) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.UserAuthConfigInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
         */
        var authScheme: aws.sdk.kotlin.services.rds.model.AuthScheme? = null
        /**
         * A user-specified description about the authentication used by a proxy to log in as a specific database user.
         */
        var description: kotlin.String? = null
        /**
         * Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.
         */
        var iamAuth: aws.sdk.kotlin.services.rds.model.IamAuthMode? = null
        /**
         * The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate
         * to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
         */
        var secretArn: kotlin.String? = null
        /**
         * The name of the database user to which the proxy connects.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.UserAuthConfigInfo) : this() {
            this.authScheme = x.authScheme
            this.description = x.description
            this.iamAuth = x.iamAuth
            this.secretArn = x.secretArn
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.UserAuthConfigInfo = UserAuthConfigInfo(this)
    }
}
