// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.rds.model.BacktrackDbClusterResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class BacktrackDBClusterOperationDeserializer: HttpDeserialize<BacktrackDbClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BacktrackDbClusterResponse {
        if (!response.status.isSuccess()) {
            throwBacktrackDbClusterError(context, response)
        }
        val builder = BacktrackDbClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBacktrackDBClusterOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBacktrackDbClusterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBacktrackDBClusterOperationBody(builder: BacktrackDbClusterResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("BacktrackDBClusterResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("BacktrackDBClusterResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap BacktrackDBCluster response")
    }
    // end unwrap response wrapper

    val BACKTRACKIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("BacktrackIdentifier"))
    val BACKTRACKREQUESTCREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("BacktrackRequestCreationTime"))
    val BACKTRACKTO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("BacktrackTo"))
    val BACKTRACKEDFROM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("BacktrackedFrom"))
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterIdentifier"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("BacktrackDBClusterResult"))
        field(BACKTRACKIDENTIFIER_DESCRIPTOR)
        field(BACKTRACKREQUESTCREATIONTIME_DESCRIPTOR)
        field(BACKTRACKTO_DESCRIPTOR)
        field(BACKTRACKEDFROM_DESCRIPTOR)
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKTRACKIDENTIFIER_DESCRIPTOR.index -> builder.backtrackIdentifier = deserializeString()
                BACKTRACKREQUESTCREATIONTIME_DESCRIPTOR.index -> builder.backtrackRequestCreationTime = deserializeString().let { Instant.fromIso8601(it) }
                BACKTRACKTO_DESCRIPTOR.index -> builder.backtrackTo = deserializeString().let { Instant.fromIso8601(it) }
                BACKTRACKEDFROM_DESCRIPTOR.index -> builder.backtrackedFrom = deserializeString().let { Instant.fromIso8601(it) }
                DBCLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterIdentifier = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
