// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.rds.model.CreateDbClusterEndpointResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateDBClusterEndpointOperationDeserializer: HttpDeserialize<CreateDbClusterEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDbClusterEndpointResponse {
        if (!response.status.isSuccess()) {
            throwCreateDbClusterEndpointError(context, response)
        }
        val builder = CreateDbClusterEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBClusterEndpointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateDbClusterEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterEndpointAlreadyExistsFault" -> DbClusterEndpointAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterEndpointQuotaExceededFault" -> DbClusterEndpointQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBClusterEndpointOperationBody(builder: CreateDbClusterEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateDBClusterEndpointResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateDBClusterEndpointResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateDBClusterEndpoint response")
    }
    // end unwrap response wrapper

    val CUSTOMENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CustomEndpointType"))
    val DBCLUSTERENDPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterEndpointArn"))
    val DBCLUSTERENDPOINTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterEndpointIdentifier"))
    val DBCLUSTERENDPOINTRESOURCEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterEndpointResourceIdentifier"))
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterIdentifier"))
    val ENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Endpoint"))
    val ENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EndpointType"))
    val EXCLUDEDMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ExcludedMembers"))
    val STATICMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("StaticMembers"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("CreateDBClusterEndpointResult"))
        field(CUSTOMENDPOINTTYPE_DESCRIPTOR)
        field(DBCLUSTERENDPOINTARN_DESCRIPTOR)
        field(DBCLUSTERENDPOINTIDENTIFIER_DESCRIPTOR)
        field(DBCLUSTERENDPOINTRESOURCEIDENTIFIER_DESCRIPTOR)
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(ENDPOINT_DESCRIPTOR)
        field(ENDPOINTTYPE_DESCRIPTOR)
        field(EXCLUDEDMEMBERS_DESCRIPTOR)
        field(STATICMEMBERS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMENDPOINTTYPE_DESCRIPTOR.index -> builder.customEndpointType = deserializeString()
                DBCLUSTERENDPOINTARN_DESCRIPTOR.index -> builder.dbClusterEndpointArn = deserializeString()
                DBCLUSTERENDPOINTIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterEndpointIdentifier = deserializeString()
                DBCLUSTERENDPOINTRESOURCEIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterEndpointResourceIdentifier = deserializeString()
                DBCLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterIdentifier = deserializeString()
                ENDPOINT_DESCRIPTOR.index -> builder.endpoint = deserializeString()
                ENDPOINTTYPE_DESCRIPTOR.index -> builder.endpointType = deserializeString()
                EXCLUDEDMEMBERS_DESCRIPTOR.index -> builder.excludedMembers =
                    deserializer.deserializeList(EXCLUDEDMEMBERS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATICMEMBERS_DESCRIPTOR.index -> builder.staticMembers =
                    deserializer.deserializeList(STATICMEMBERS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
