// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest
import aws.sdk.kotlin.services.rds.model.EngineFamily
import aws.sdk.kotlin.services.rds.model.Tag
import aws.sdk.kotlin.services.rds.model.UserAuthConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDBProxyOperationSerializer: HttpSerialize<CreateDbProxyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDbProxyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateDBProxyOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateDBProxyOperationBody(context: ExecutionContext, input: CreateDbProxyRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AUTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Auth"))
    val DBPROXYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBProxyName"))
    val DEBUGLOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DebugLogging"))
    val ENGINEFAMILY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EngineFamily"))
    val IDLECLIENTTIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("IdleClientTimeout"))
    val REQUIRETLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("RequireTLS"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RoleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val VPCSECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("VpcSecurityGroupIds"))
    val VPCSUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("VpcSubnetIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateDBProxyRequest"))
        trait(QueryLiteral("Action", "CreateDBProxy"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(AUTH_DESCRIPTOR)
        field(DBPROXYNAME_DESCRIPTOR)
        field(DEBUGLOGGING_DESCRIPTOR)
        field(ENGINEFAMILY_DESCRIPTOR)
        field(IDLECLIENTTIMEOUT_DESCRIPTOR)
        field(REQUIRETLS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCSECURITYGROUPIDS_DESCRIPTOR)
        field(VPCSUBNETIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.auth != null) {
            listField(AUTH_DESCRIPTOR) {
                for (el0 in input.auth) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeUserAuthConfigDocument))
                }
            }
        }
        input.dbProxyName?.let { field(DBPROXYNAME_DESCRIPTOR, it) }
        if (input.debugLogging != false) field(DEBUGLOGGING_DESCRIPTOR, input.debugLogging)
        input.engineFamily?.let { field(ENGINEFAMILY_DESCRIPTOR, it.value) }
        input.idleClientTimeout?.let { field(IDLECLIENTTIMEOUT_DESCRIPTOR, it) }
        if (input.requireTls != false) field(REQUIRETLS_DESCRIPTOR, input.requireTls)
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        if (input.vpcSecurityGroupIds != null) {
            listField(VPCSECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.vpcSecurityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.vpcSubnetIds != null) {
            listField(VPCSUBNETIDS_DESCRIPTOR) {
                for (el0 in input.vpcSubnetIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
