// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.ProcessorFeature
import aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest
import aws.sdk.kotlin.services.rds.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RestoreDBInstanceFromDBSnapshotOperationSerializer: HttpSerialize<RestoreDbInstanceFromDbSnapshotRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RestoreDbInstanceFromDbSnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeRestoreDBInstanceFromDBSnapshotOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeRestoreDBInstanceFromDBSnapshotOperationBody(context: ExecutionContext, input: RestoreDbInstanceFromDbSnapshotRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AutoMinorVersionUpgrade"))
    val AVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AvailabilityZone"))
    val BACKUPTARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("BackupTarget"))
    val COPYTAGSTOSNAPSHOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("CopyTagsToSnapshot"))
    val CUSTOMIAMINSTANCEPROFILE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CustomIamInstanceProfile"))
    val DBINSTANCECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBInstanceClass"))
    val DBINSTANCEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBInstanceIdentifier"))
    val DBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBName"))
    val DBPARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBParameterGroupName"))
    val DBSNAPSHOTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBSnapshotIdentifier"))
    val DBSUBNETGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBSubnetGroupName"))
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DeletionProtection"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Domain"))
    val DOMAINIAMROLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DomainIAMRoleName"))
    val ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("EnableCloudwatchLogsExports"))
    val ENABLECUSTOMEROWNEDIP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnableCustomerOwnedIp"))
    val ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnableIAMDatabaseAuthentication"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Engine"))
    val IOPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Iops"))
    val LICENSEMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LicenseModel"))
    val MULTIAZ_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("MultiAZ"))
    val OPTIONGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OptionGroupName"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Port"))
    val PROCESSORFEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ProcessorFeatures"), FormUrlCollectionName("ProcessorFeature"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("PubliclyAccessible"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StorageType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val TDECREDENTIALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TdeCredentialArn"))
    val TDECREDENTIALPASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TdeCredentialPassword"))
    val USEDEFAULTPROCESSORFEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("UseDefaultProcessorFeatures"))
    val VPCSECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("VpcSecurityGroupIds"), FormUrlCollectionName("VpcSecurityGroupId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("RestoreDBInstanceFromDBSnapshotMessage"))
        trait(QueryLiteral("Action", "RestoreDBInstanceFromDBSnapshot"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(AVAILABILITYZONE_DESCRIPTOR)
        field(BACKUPTARGET_DESCRIPTOR)
        field(COPYTAGSTOSNAPSHOT_DESCRIPTOR)
        field(CUSTOMIAMINSTANCEPROFILE_DESCRIPTOR)
        field(DBINSTANCECLASS_DESCRIPTOR)
        field(DBINSTANCEIDENTIFIER_DESCRIPTOR)
        field(DBNAME_DESCRIPTOR)
        field(DBPARAMETERGROUPNAME_DESCRIPTOR)
        field(DBSNAPSHOTIDENTIFIER_DESCRIPTOR)
        field(DBSUBNETGROUPNAME_DESCRIPTOR)
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(DOMAINIAMROLENAME_DESCRIPTOR)
        field(ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR)
        field(ENABLECUSTOMEROWNEDIP_DESCRIPTOR)
        field(ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(IOPS_DESCRIPTOR)
        field(LICENSEMODEL_DESCRIPTOR)
        field(MULTIAZ_DESCRIPTOR)
        field(OPTIONGROUPNAME_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(PROCESSORFEATURES_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TDECREDENTIALARN_DESCRIPTOR)
        field(TDECREDENTIALPASSWORD_DESCRIPTOR)
        field(USEDEFAULTPROCESSORFEATURES_DESCRIPTOR)
        field(VPCSECURITYGROUPIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.availabilityZone?.let { field(AVAILABILITYZONE_DESCRIPTOR, it) }
        input.backupTarget?.let { field(BACKUPTARGET_DESCRIPTOR, it) }
        input.copyTagsToSnapshot?.let { field(COPYTAGSTOSNAPSHOT_DESCRIPTOR, it) }
        input.customIamInstanceProfile?.let { field(CUSTOMIAMINSTANCEPROFILE_DESCRIPTOR, it) }
        input.dbInstanceClass?.let { field(DBINSTANCECLASS_DESCRIPTOR, it) }
        input.dbInstanceIdentifier?.let { field(DBINSTANCEIDENTIFIER_DESCRIPTOR, it) }
        input.dbName?.let { field(DBNAME_DESCRIPTOR, it) }
        input.dbParameterGroupName?.let { field(DBPARAMETERGROUPNAME_DESCRIPTOR, it) }
        input.dbSnapshotIdentifier?.let { field(DBSNAPSHOTIDENTIFIER_DESCRIPTOR, it) }
        input.dbSubnetGroupName?.let { field(DBSUBNETGROUPNAME_DESCRIPTOR, it) }
        input.deletionProtection?.let { field(DELETIONPROTECTION_DESCRIPTOR, it) }
        input.domain?.let { field(DOMAIN_DESCRIPTOR, it) }
        input.domainIamRoleName?.let { field(DOMAINIAMROLENAME_DESCRIPTOR, it) }
        if (input.enableCloudwatchLogsExports != null) {
            listField(ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR) {
                for (el0 in input.enableCloudwatchLogsExports) {
                    serializeString(el0)
                }
            }
        }
        input.enableCustomerOwnedIp?.let { field(ENABLECUSTOMEROWNEDIP_DESCRIPTOR, it) }
        input.enableIamDatabaseAuthentication?.let { field(ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR, it) }
        input.engine?.let { field(ENGINE_DESCRIPTOR, it) }
        input.iops?.let { field(IOPS_DESCRIPTOR, it) }
        input.licenseModel?.let { field(LICENSEMODEL_DESCRIPTOR, it) }
        input.multiAz?.let { field(MULTIAZ_DESCRIPTOR, it) }
        input.optionGroupName?.let { field(OPTIONGROUPNAME_DESCRIPTOR, it) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        if (input.processorFeatures != null) {
            listField(PROCESSORFEATURES_DESCRIPTOR) {
                for (el0 in input.processorFeatures) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProcessorFeatureDocument))
                }
            }
        }
        input.publiclyAccessible?.let { field(PUBLICLYACCESSIBLE_DESCRIPTOR, it) }
        input.storageType?.let { field(STORAGETYPE_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.tdeCredentialArn?.let { field(TDECREDENTIALARN_DESCRIPTOR, it) }
        input.tdeCredentialPassword?.let { field(TDECREDENTIALPASSWORD_DESCRIPTOR, it) }
        input.useDefaultProcessorFeatures?.let { field(USEDEFAULTPROCESSORFEATURES_DESCRIPTOR, it) }
        if (input.vpcSecurityGroupIds != null) {
            listField(VPCSECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.vpcSecurityGroupIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
