// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.
 *
 * For an Amazon Aurora DB cluster, this data type is used as a response element in the operations `CreateDBCluster`, `DeleteDBCluster`, `DescribeDBClusters`, `FailoverDBCluster`, `ModifyDBCluster`, `PromoteReadReplicaDBCluster`, `RestoreDBClusterFromS3`, `RestoreDBClusterFromSnapshot`, `RestoreDBClusterToPointInTime`, `StartDBCluster`, and `StopDBCluster`.
 *
 * For a Multi-AZ DB cluster, this data type is used as a response element in the operations `CreateDBCluster`, `DeleteDBCluster`, `DescribeDBClusters`, `FailoverDBCluster`, `ModifyDBCluster`, `RebootDBCluster`, `RestoreDBClusterFromSnapshot`, and `RestoreDBClusterToPointInTime`.
 *
 * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide.*
 *
 * For more information on Multi-AZ DB clusters, see [ Multi-AZ deployments with two readable standby DB instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
 */
public class DbCluster private constructor(builder: Builder) {
    /**
     * The name of the Amazon Kinesis data stream used for the database activity stream.
     */
    public val activityStreamKinesisStreamName: kotlin.String? = builder.activityStreamKinesisStreamName
    /**
     * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val activityStreamKmsKeyId: kotlin.String? = builder.activityStreamKmsKeyId
    /**
     * The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.
     */
    public val activityStreamMode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = builder.activityStreamMode
    /**
     * The status of the database activity stream.
     */
    public val activityStreamStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamStatus? = builder.activityStreamStatus
    /**
     * For all database engines except Amazon Aurora, `AllocatedStorage` specifies the allocated storage size in gibibytes (GiB). For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Provides a list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     */
    public val associatedRoles: List<DbClusterRole>? = builder.associatedRoles
    /**
     * A value that indicates that minor version patches are applied automatically.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean = builder.autoMinorVersionUpgrade
    /**
     * The time when a stopped DB cluster is restarted automatically.
     */
    public val automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.automaticRestartTime
    /**
     * Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The number of change records stored for Backtrack.
     */
    public val backtrackConsumedChangeRecords: kotlin.Long? = builder.backtrackConsumedChangeRecords
    /**
     * The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.
     */
    public val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * Specifies the number of days for which automatic DB snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The current capacity of an Aurora Serverless v1 DB cluster. The capacity is 0 (zero) when the cluster is paused.
     *
     * For more information about Aurora Serverless v1, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
     */
    public val capacity: kotlin.Int? = builder.capacity
    /**
     * If present, specifies the name of the character set that this cluster is associated with.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * Identifies the clone group to which the DB cluster is associated.
     */
    public val cloneGroupId: kotlin.String? = builder.cloneGroupId
    /**
     * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
     */
    public val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * Specifies whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
     */
    public val crossAccountClone: kotlin.Boolean? = builder.crossAccountClone
    /**
     * Identifies all custom endpoints associated with the cluster.
     */
    public val customEndpoints: List<String>? = builder.customEndpoints
    /**
     * Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The Amazon Resource Name (ARN) for the DB cluster.
     */
    public val dbClusterArn: kotlin.String? = builder.dbClusterArn
    /**
     * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the compute and memory capacity class of the DB instance.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * Provides the list of instances that make up the DB cluster.
     */
    public val dbClusterMembers: List<DbClusterMember>? = builder.dbClusterMembers
    /**
     * Provides the list of option group memberships for this DB cluster.
     */
    public val dbClusterOptionGroupMemberships: List<DbClusterOptionGroupStatus>? = builder.dbClusterOptionGroupMemberships
    /**
     * Specifies the name of the DB cluster parameter group for the DB cluster.
     */
    public val dbClusterParameterGroup: kotlin.String? = builder.dbClusterParameterGroup
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     */
    public val dbClusterResourceId: kotlin.String? = builder.dbClusterResourceId
    /**
     * Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
     */
    public val dbSubnetGroup: kotlin.String? = builder.dbSubnetGroup
    /**
     * Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory Domain membership records associated with the DB cluster.
     */
    public val domainMemberships: List<DomainMembership>? = builder.domainMemberships
    /**
     * The earliest time to which a DB cluster can be backtracked.
     */
    public val earliestBacktrackTime: aws.smithy.kotlin.runtime.time.Instant? = builder.earliestBacktrackTime
    /**
     * The earliest time to which a database can be restored with point-in-time restore.
     */
    public val earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.earliestRestorableTime
    /**
     * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
     *
     * Log types vary by DB engine. For information about the log types for each DB engine, see [Amazon RDS Database Log Files](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html) in the *Amazon Aurora User Guide.*
     */
    public val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint for the primary instance of the DB cluster.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The name of the database engine to be used for this DB cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The DB engine mode of the DB cluster, either `provisioned`, `serverless`, `parallelquery`, `global`, or `multimaster`.
     *
     * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * Indicates the database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Specifies whether you have requested to enable write forwarding for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of `GlobalWriteForwardingStatus` to confirm that the request has completed before using the write forwarding feature for this cluster.
     */
    public val globalWriteForwardingRequested: kotlin.Boolean? = builder.globalWriteForwardingRequested
    /**
     * Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.
     */
    public val globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = builder.globalWriteForwardingStatus
    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * A value that indicates whether the HTTP endpoint for an Aurora Serverless v1 DB cluster is enabled.
     *
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.
     *
     * For more information, see [Using the Data API for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     */
    public val httpEndpointEnabled: kotlin.Boolean? = builder.httpEndpointEnabled
    /**
     * A value that indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * The Provisioned IOPS (I/O operations per second) value.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * If `StorageEncrypted` is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * Contains the master username for the DB cluster.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Specifies whether the DB cluster has instances in multiple Availability Zones.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * A value that specifies that changes to the DB cluster are pending. This element is only included when changes are pending. Specific changes are identified by subelements.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues? = builder.pendingModifiedValues
    /**
     * Specifies the progress of the operation as a percentage.
     */
    public val percentProgress: kotlin.String? = builder.percentProgress
    /**
     * True if Performance Insights is enabled for the DB cluster, and otherwise false.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val performanceInsightsEnabled: kotlin.Boolean? = builder.performanceInsightsEnabled
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
     * + 7
     * + *month* * 31, where *month* is a number of months from 1-23
     * + 731
     *
     * For example, the following values are valid:
     * + 93 (3 months * 31)
     * + 341 (11 months * 31)
     * + 589 (19 months * 31)
     * + 731
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * Specifies the port that the database engine is listening on.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies the accessibility options for the DB instance.
     *
     * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.
     *
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBInstance.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Contains one or more identifiers of the read replicas associated with this DB cluster.
     */
    public val readReplicaIdentifiers: List<String>? = builder.readReplicaIdentifiers
    /**
     * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.
     *
     * If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.
     */
    public val readerEndpoint: kotlin.String? = builder.readerEndpoint
    /**
     * Contains the identifier of the source DB cluster if this DB cluster is a read replica.
     */
    public val replicationSourceIdentifier: kotlin.String? = builder.replicationSourceIdentifier
    /**
     * Shows the scaling configuration for an Aurora DB cluster in `serverless` DB engine mode.
     *
     * For more information, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
     */
    public val scalingConfigurationInfo: aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo? = builder.scalingConfigurationInfo
    /**
     * Shows the scaling configuration for an Aurora Serverless v2 DB cluster.
     *
     * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo? = builder.serverlessV2ScalingConfiguration
    /**
     * Specifies the current state of this DB cluster.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Specifies whether the DB cluster is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * The storage type associated with the DB cluster.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * Provides a list of VPC security groups that the DB cluster belongs to.
     */
    public val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbCluster(")
        append("activityStreamKinesisStreamName=$activityStreamKinesisStreamName,")
        append("activityStreamKmsKeyId=$activityStreamKmsKeyId,")
        append("activityStreamMode=$activityStreamMode,")
        append("activityStreamStatus=$activityStreamStatus,")
        append("allocatedStorage=$allocatedStorage,")
        append("associatedRoles=$associatedRoles,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticRestartTime=$automaticRestartTime,")
        append("availabilityZones=$availabilityZones,")
        append("backtrackConsumedChangeRecords=$backtrackConsumedChangeRecords,")
        append("backtrackWindow=$backtrackWindow,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("capacity=$capacity,")
        append("characterSetName=$characterSetName,")
        append("cloneGroupId=$cloneGroupId,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("crossAccountClone=$crossAccountClone,")
        append("customEndpoints=$customEndpoints,")
        append("databaseName=$databaseName,")
        append("dbClusterArn=$dbClusterArn,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterMembers=$dbClusterMembers,")
        append("dbClusterOptionGroupMemberships=$dbClusterOptionGroupMemberships,")
        append("dbClusterParameterGroup=$dbClusterParameterGroup,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("deletionProtection=$deletionProtection,")
        append("domainMemberships=$domainMemberships,")
        append("earliestBacktrackTime=$earliestBacktrackTime,")
        append("earliestRestorableTime=$earliestRestorableTime,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("globalWriteForwardingRequested=$globalWriteForwardingRequested,")
        append("globalWriteForwardingStatus=$globalWriteForwardingStatus,")
        append("hostedZoneId=$hostedZoneId,")
        append("httpEndpointEnabled=$httpEndpointEnabled,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("masterUsername=$masterUsername,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("percentProgress=$percentProgress,")
        append("performanceInsightsEnabled=$performanceInsightsEnabled,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("readReplicaIdentifiers=$readReplicaIdentifiers,")
        append("readerEndpoint=$readerEndpoint,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("scalingConfigurationInfo=$scalingConfigurationInfo,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tagList=$tagList,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityStreamKinesisStreamName?.hashCode() ?: 0
        result = 31 * result + (activityStreamKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (activityStreamMode?.hashCode() ?: 0)
        result = 31 * result + (activityStreamStatus?.hashCode() ?: 0)
        result = 31 * result + (allocatedStorage ?: 0)
        result = 31 * result + (associatedRoles?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade.hashCode())
        result = 31 * result + (automaticRestartTime?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (backtrackConsumedChangeRecords?.hashCode() ?: 0)
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (capacity ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (cloneGroupId?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (crossAccountClone?.hashCode() ?: 0)
        result = 31 * result + (customEndpoints?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (dbClusterOptionGroupMemberships?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroup?.hashCode() ?: 0)
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domainMemberships?.hashCode() ?: 0)
        result = 31 * result + (earliestBacktrackTime?.hashCode() ?: 0)
        result = 31 * result + (earliestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalWriteForwardingRequested?.hashCode() ?: 0)
        result = 31 * result + (globalWriteForwardingStatus?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (httpEndpointEnabled?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (percentProgress?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsEnabled?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (readReplicaIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (scalingConfigurationInfo?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbCluster

        if (activityStreamKinesisStreamName != other.activityStreamKinesisStreamName) return false
        if (activityStreamKmsKeyId != other.activityStreamKmsKeyId) return false
        if (activityStreamMode != other.activityStreamMode) return false
        if (activityStreamStatus != other.activityStreamStatus) return false
        if (allocatedStorage != other.allocatedStorage) return false
        if (associatedRoles != other.associatedRoles) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticRestartTime != other.automaticRestartTime) return false
        if (availabilityZones != other.availabilityZones) return false
        if (backtrackConsumedChangeRecords != other.backtrackConsumedChangeRecords) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (capacity != other.capacity) return false
        if (characterSetName != other.characterSetName) return false
        if (cloneGroupId != other.cloneGroupId) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (crossAccountClone != other.crossAccountClone) return false
        if (customEndpoints != other.customEndpoints) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterArn != other.dbClusterArn) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterMembers != other.dbClusterMembers) return false
        if (dbClusterOptionGroupMemberships != other.dbClusterOptionGroupMemberships) return false
        if (dbClusterParameterGroup != other.dbClusterParameterGroup) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domainMemberships != other.domainMemberships) return false
        if (earliestBacktrackTime != other.earliestBacktrackTime) return false
        if (earliestRestorableTime != other.earliestRestorableTime) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (globalWriteForwardingRequested != other.globalWriteForwardingRequested) return false
        if (globalWriteForwardingStatus != other.globalWriteForwardingStatus) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (httpEndpointEnabled != other.httpEndpointEnabled) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (masterUsername != other.masterUsername) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (percentProgress != other.percentProgress) return false
        if (performanceInsightsEnabled != other.performanceInsightsEnabled) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (readReplicaIdentifiers != other.readReplicaIdentifiers) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (scalingConfigurationInfo != other.scalingConfigurationInfo) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tagList != other.tagList) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbCluster = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Amazon Kinesis data stream used for the database activity stream.
         */
        public var activityStreamKinesisStreamName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var activityStreamKmsKeyId: kotlin.String? = null
        /**
         * The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.
         */
        public var activityStreamMode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = null
        /**
         * The status of the database activity stream.
         */
        public var activityStreamStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamStatus? = null
        /**
         * For all database engines except Amazon Aurora, `AllocatedStorage` specifies the allocated storage size in gibibytes (GiB). For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Provides a list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         */
        public var associatedRoles: List<DbClusterRole>? = null
        /**
         * A value that indicates that minor version patches are applied automatically.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean = false
        /**
         * The time when a stopped DB cluster is restarted automatically.
         */
        public var automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The number of change records stored for Backtrack.
         */
        public var backtrackConsumedChangeRecords: kotlin.Long? = null
        /**
         * The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.
         */
        public var backtrackWindow: kotlin.Long? = null
        /**
         * Specifies the number of days for which automatic DB snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The current capacity of an Aurora Serverless v1 DB cluster. The capacity is 0 (zero) when the cluster is paused.
         *
         * For more information about Aurora Serverless v1, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
         */
        public var capacity: kotlin.Int? = null
        /**
         * If present, specifies the name of the character set that this cluster is associated with.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * Identifies the clone group to which the DB cluster is associated.
         */
        public var cloneGroupId: kotlin.String? = null
        /**
         * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
         */
        public var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * Specifies whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
         */
        public var crossAccountClone: kotlin.Boolean? = null
        /**
         * Identifies all custom endpoints associated with the cluster.
         */
        public var customEndpoints: List<String>? = null
        /**
         * Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB cluster.
         */
        public var dbClusterArn: kotlin.String? = null
        /**
         * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the compute and memory capacity class of the DB instance.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var dbClusterInstanceClass: kotlin.String? = null
        /**
         * Provides the list of instances that make up the DB cluster.
         */
        public var dbClusterMembers: List<DbClusterMember>? = null
        /**
         * Provides the list of option group memberships for this DB cluster.
         */
        public var dbClusterOptionGroupMemberships: List<DbClusterOptionGroupStatus>? = null
        /**
         * Specifies the name of the DB cluster parameter group for the DB cluster.
         */
        public var dbClusterParameterGroup: kotlin.String? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
         */
        public var dbClusterResourceId: kotlin.String? = null
        /**
         * Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
         */
        public var dbSubnetGroup: kotlin.String? = null
        /**
         * Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory Domain membership records associated with the DB cluster.
         */
        public var domainMemberships: List<DomainMembership>? = null
        /**
         * The earliest time to which a DB cluster can be backtracked.
         */
        public var earliestBacktrackTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The earliest time to which a database can be restored with point-in-time restore.
         */
        public var earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         *
         * Log types vary by DB engine. For information about the log types for each DB engine, see [Amazon RDS Database Log Files](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html) in the *Amazon Aurora User Guide.*
         */
        public var enabledCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies the connection endpoint for the primary instance of the DB cluster.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The name of the database engine to be used for this DB cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * The DB engine mode of the DB cluster, either `provisioned`, `serverless`, `parallelquery`, `global`, or `multimaster`.
         *
         * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
         */
        public var engineMode: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Specifies whether you have requested to enable write forwarding for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of `GlobalWriteForwardingStatus` to confirm that the request has completed before using the write forwarding feature for this cluster.
         */
        public var globalWriteForwardingRequested: kotlin.Boolean? = null
        /**
         * Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.
         */
        public var globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = null
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        public var hostedZoneId: kotlin.String? = null
        /**
         * A value that indicates whether the HTTP endpoint for an Aurora Serverless v1 DB cluster is enabled.
         *
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.
         *
         * For more information, see [Using the Data API for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         */
        public var httpEndpointEnabled: kotlin.Boolean? = null
        /**
         * A value that indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * The Provisioned IOPS (I/O operations per second) value.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var iops: kotlin.Int? = null
        /**
         * If `StorageEncrypted` is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         */
        public var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains the master username for the DB cluster.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Specifies whether the DB cluster has instances in multiple Availability Zones.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * A value that specifies that changes to the DB cluster are pending. This element is only included when changes are pending. Specific changes are identified by subelements.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues? = null
        /**
         * Specifies the progress of the operation as a percentage.
         */
        public var percentProgress: kotlin.String? = null
        /**
         * True if Performance Insights is enabled for the DB cluster, and otherwise false.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var performanceInsightsEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
         * + 7
         * + *month* * 31, where *month* is a number of months from 1-23
         * + 731
         *
         * For example, the following values are valid:
         * + 93 (3 months * 31)
         * + 341 (11 months * 31)
         * + 589 (19 months * 31)
         * + 731
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * Specifies the port that the database engine is listening on.
         */
        public var port: kotlin.Int? = null
        /**
         * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies the accessibility options for the DB instance.
         *
         * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.
         *
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBInstance.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Contains one or more identifiers of the read replicas associated with this DB cluster.
         */
        public var readReplicaIdentifiers: List<String>? = null
        /**
         * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.
         *
         * If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.
         */
        public var readerEndpoint: kotlin.String? = null
        /**
         * Contains the identifier of the source DB cluster if this DB cluster is a read replica.
         */
        public var replicationSourceIdentifier: kotlin.String? = null
        /**
         * Shows the scaling configuration for an Aurora DB cluster in `serverless` DB engine mode.
         *
         * For more information, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
         */
        public var scalingConfigurationInfo: aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo? = null
        /**
         * Shows the scaling configuration for an Aurora Serverless v2 DB cluster.
         *
         * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo? = null
        /**
         * Specifies the current state of this DB cluster.
         */
        public var status: kotlin.String? = null
        /**
         * Specifies whether the DB cluster is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean = false
        /**
         * The storage type associated with the DB cluster.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * Provides a list of VPC security groups that the DB cluster belongs to.
         */
        public var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbCluster) : this() {
            this.activityStreamKinesisStreamName = x.activityStreamKinesisStreamName
            this.activityStreamKmsKeyId = x.activityStreamKmsKeyId
            this.activityStreamMode = x.activityStreamMode
            this.activityStreamStatus = x.activityStreamStatus
            this.allocatedStorage = x.allocatedStorage
            this.associatedRoles = x.associatedRoles
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticRestartTime = x.automaticRestartTime
            this.availabilityZones = x.availabilityZones
            this.backtrackConsumedChangeRecords = x.backtrackConsumedChangeRecords
            this.backtrackWindow = x.backtrackWindow
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.capacity = x.capacity
            this.characterSetName = x.characterSetName
            this.cloneGroupId = x.cloneGroupId
            this.clusterCreateTime = x.clusterCreateTime
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.crossAccountClone = x.crossAccountClone
            this.customEndpoints = x.customEndpoints
            this.databaseName = x.databaseName
            this.dbClusterArn = x.dbClusterArn
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterMembers = x.dbClusterMembers
            this.dbClusterOptionGroupMemberships = x.dbClusterOptionGroupMemberships
            this.dbClusterParameterGroup = x.dbClusterParameterGroup
            this.dbClusterResourceId = x.dbClusterResourceId
            this.dbSubnetGroup = x.dbSubnetGroup
            this.deletionProtection = x.deletionProtection
            this.domainMemberships = x.domainMemberships
            this.earliestBacktrackTime = x.earliestBacktrackTime
            this.earliestRestorableTime = x.earliestRestorableTime
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.globalWriteForwardingRequested = x.globalWriteForwardingRequested
            this.globalWriteForwardingStatus = x.globalWriteForwardingStatus
            this.hostedZoneId = x.hostedZoneId
            this.httpEndpointEnabled = x.httpEndpointEnabled
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.masterUsername = x.masterUsername
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.pendingModifiedValues = x.pendingModifiedValues
            this.percentProgress = x.percentProgress
            this.performanceInsightsEnabled = x.performanceInsightsEnabled
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.readReplicaIdentifiers = x.readReplicaIdentifiers
            this.readerEndpoint = x.readerEndpoint
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.scalingConfigurationInfo = x.scalingConfigurationInfo
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tagList = x.tagList
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbCluster = DbCluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo] inside the given [block]
         */
        public fun scalingConfigurationInfo(block: aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo.Builder.() -> kotlin.Unit) {
            this.scalingConfigurationInfo = aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo.invoke(block)
        }
    }
}
