// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains information about an instance that is part of a DB cluster.
 */
public class DbClusterMember private constructor(builder: Builder) {
    /**
     * Specifies the status of the DB cluster parameter group for this member of the DB cluster.
     */
    public val dbClusterParameterGroupStatus: kotlin.String? = builder.dbClusterParameterGroupStatus
    /**
     * Specifies the instance identifier for this member of the DB cluster.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * Value that is `true` if the cluster member is the primary instance for the DB cluster and `false` otherwise.
     */
    public val isClusterWriter: kotlin.Boolean = builder.isClusterWriter
    /**
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [ Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbClusterMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterMember(")
        append("dbClusterParameterGroupStatus=$dbClusterParameterGroupStatus,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("isClusterWriter=$isClusterWriter,")
        append("promotionTier=$promotionTier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupStatus?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (isClusterWriter.hashCode())
        result = 31 * result + (promotionTier ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterMember

        if (dbClusterParameterGroupStatus != other.dbClusterParameterGroupStatus) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (isClusterWriter != other.isClusterWriter) return false
        if (promotionTier != other.promotionTier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbClusterMember = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the status of the DB cluster parameter group for this member of the DB cluster.
         */
        public var dbClusterParameterGroupStatus: kotlin.String? = null
        /**
         * Specifies the instance identifier for this member of the DB cluster.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * Value that is `true` if the cluster member is the primary instance for the DB cluster and `false` otherwise.
         */
        public var isClusterWriter: kotlin.Boolean = false
        /**
         * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [ Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
         */
        public var promotionTier: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbClusterMember) : this() {
            this.dbClusterParameterGroupStatus = x.dbClusterParameterGroupStatus
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.isClusterWriter = x.isClusterWriter
            this.promotionTier = x.promotionTier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbClusterMember = DbClusterMember(this)
    }
}
