// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of an Amazon RDS DB instance.
 *
 * This data type is used as a response element in the operations `CreateDBInstance`, `CreateDBInstanceReadReplica`, `DeleteDBInstance`, `DescribeDBInstances`, `ModifyDBInstance`, `PromoteReadReplica`, `RebootDBInstance`, `RestoreDBInstanceFromDBSnapshot`, `RestoreDBInstanceFromS3`, `RestoreDBInstanceToPointInTime`, `StartDBInstance`, and `StopDBInstance`.
 */
public class DbInstance private constructor(builder: Builder) {
    /**
     * Indicates whether engine-native audit fields are included in the database activity stream.
     */
    public val activityStreamEngineNativeAuditFieldsIncluded: kotlin.Boolean? = builder.activityStreamEngineNativeAuditFieldsIncluded
    /**
     * The name of the Amazon Kinesis data stream used for the database activity stream.
     */
    public val activityStreamKinesisStreamName: kotlin.String? = builder.activityStreamKinesisStreamName
    /**
     * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val activityStreamKmsKeyId: kotlin.String? = builder.activityStreamKmsKeyId
    /**
     * The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.
     */
    public val activityStreamMode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = builder.activityStreamMode
    /**
     * The status of the policy state of the activity stream.
     */
    public val activityStreamPolicyStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamPolicyStatus? = builder.activityStreamPolicyStatus
    /**
     * The status of the database activity stream.
     */
    public val activityStreamStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamStatus? = builder.activityStreamStatus
    /**
     * Specifies the allocated storage size specified in gibibytes (GiB).
     */
    public val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance.
     */
    public val associatedRoles: List<DbInstanceRole>? = builder.associatedRoles
    /**
     * A value that indicates that minor version patches are applied automatically.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean = builder.autoMinorVersionUpgrade
    /**
     * The time when a stopped DB instance is restarted automatically.
     */
    public val automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.automaticRestartTime
    /**
     * The automation mode of the RDS Custom DB instance: `full` or `all paused`. If `full`, the DB instance automates monitoring and instance recovery. If `all paused`, the instance pauses automation for the duration set by `--resume-full-automation-mode-minutes`.
     */
    public val automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = builder.automationMode
    /**
     * Specifies the name of the Availability Zone the DB instance is located in.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     */
    public val awsBackupRecoveryPointArn: kotlin.String? = builder.awsBackupRecoveryPointArn
    /**
     * Specifies the number of days for which automatic DB snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int = builder.backupRetentionPeriod
    /**
     * Specifies where automated backups and manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.
     */
    public val backupTarget: kotlin.String? = builder.backupTarget
    /**
     * The identifier of the CA certificate for this DB instance.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * If present, specifies the name of the character set that this instance is associated with.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
     *
     * **Amazon Aurora**
     *
     * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see `DBCluster`.
     */
    public val copyTagsToSnapshot: kotlin.Boolean = builder.copyTagsToSnapshot
    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:
     * + The profile must exist in your account.
     * + The profile must have an IAM role that Amazon EC2 has permissions to assume.
     * + The instance profile name and the associated IAM role name must start with the prefix `AWSRDSCustom`.
     *
     * For the list of permissions required for the IAM role, see [ Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
     */
    public val customIamInstanceProfile: kotlin.String? = builder.customIamInstanceProfile
    /**
     * Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.
     *
     * A *CoIP *provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.
     *
     * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
     *
     * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
     */
    public val customerOwnedIpEnabled: kotlin.Boolean? = builder.customerOwnedIpEnabled
    /**
     * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the DB instance.
     */
    public val dbInstanceArn: kotlin.String? = builder.dbInstanceArn
    /**
     * The list of replicated automated backups associated with the DB instance.
     */
    public val dbInstanceAutomatedBackupsReplications: List<DbInstanceAutomatedBackupsReplication>? = builder.dbInstanceAutomatedBackupsReplications
    /**
     * Contains the name of the compute and memory capacity class of the DB instance.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.
     */
    public val dbInstancePort: kotlin.Int = builder.dbInstancePort
    /**
     * Specifies the current state of this database.
     *
     * For information about DB instance statuses, see [Viewing DB instance status](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status) in the *Amazon RDS User Guide.*
     */
    public val dbInstanceStatus: kotlin.String? = builder.dbInstanceStatus
    /**
     * The meaning of this parameter differs according to the database engine you use.
     *
     * **MySQL, MariaDB, SQL Server, PostgreSQL**
     *
     * Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.
     *
     * Type: String
     *
     * **Oracle**
     *
     * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * Provides the list of DB parameter groups applied to this DB instance.
     */
    public val dbParameterGroups: List<DbParameterGroupStatus>? = builder.dbParameterGroups
    /**
     * A list of DB security group elements containing `DBSecurityGroup.Name` and `DBSecurityGroup.Status` subelements.
     */
    public val dbSecurityGroups: List<DbSecurityGroupMembership>? = builder.dbSecurityGroups
    /**
     * Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.
     */
    public val dbSubnetGroup: aws.sdk.kotlin.services.rds.model.DbSubnetGroup? = builder.dbSubnetGroup
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB instance is accessed.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
     */
    public val deletionProtection: kotlin.Boolean = builder.deletionProtection
    /**
     * The Active Directory Domain membership records associated with the DB instance.
     */
    public val domainMemberships: List<DomainMembership>? = builder.domainMemberships
    /**
     * A list of log types that this DB instance is configured to export to CloudWatch Logs.
     *
     * Log types vary by DB engine. For information about the log types for each DB engine, see [Amazon RDS Database Log Files](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html) in the *Amazon RDS User Guide.*
     */
    public val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint.
     *
     * The endpoint might not be shown for instances whose status is `creating`.
     */
    public val endpoint: aws.sdk.kotlin.services.rds.model.Endpoint? = builder.endpoint
    /**
     * The name of the database engine to be used for this DB instance.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.
     */
    public val enhancedMonitoringResourceArn: kotlin.String? = builder.enhancedMonitoringResourceArn
    /**
     * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
     *
     * IAM database authentication can be enabled for the following database engines
     * + For MySQL 5.6, minor version 5.6.34 or higher
     * + For MySQL 5.7, minor version 5.7.16 or higher
     * + Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean = builder.iamDatabaseAuthenticationEnabled
    /**
     * Provides the date and time the DB instance was created.
     */
    public val instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.instanceCreateTime
    /**
     * Specifies the Provisioned IOPS (I/O operations per second) value.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * If `StorageEncrypted` is true, the Amazon Web Services KMS key identifier for the encrypted DB instance.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * License model information for this DB instance. This setting doesn't apply to RDS Custom.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Specifies the listener connection endpoint for SQL Server Always On.
     */
    public val listenerEndpoint: aws.sdk.kotlin.services.rds.model.Endpoint? = builder.listenerEndpoint
    /**
     * Contains the master username for the DB instance.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     */
    public val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Specifies if the DB instance is a Multi-AZ deployment. This setting doesn't apply to RDS Custom.
     */
    public val multiAz: kotlin.Boolean = builder.multiAz
    /**
     * The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2.
     */
    public val ncharCharacterSetName: kotlin.String? = builder.ncharCharacterSetName
    /**
     * The network type of the DB instance.
     *
     * Valid values:
     * + `IPV4`
     * + `DUAL`
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide* and [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * Provides the list of option group memberships for this DB instance.
     */
    public val optionGroupMemberships: List<OptionGroupMembership>? = builder.optionGroupMemberships
    /**
     * A value that specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.rds.model.PendingModifiedValues? = builder.pendingModifiedValues
    /**
     * True if Performance Insights is enabled for the DB instance, and otherwise false.
     */
    public val performanceInsightsEnabled: kotlin.Boolean? = builder.performanceInsightsEnabled
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
     * + 7
     * + *month* * 31, where *month* is a number of months from 1-23
     * + 731
     *
     * For example, the following values are valid:
     * + 93 (3 months * 31)
     * + 341 (11 months * 31)
     * + 589 (19 months * 31)
     * + 731
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    public val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [ Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * Specifies the accessibility options for the DB instance.
     *
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     *
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBInstance.
     */
    public val publiclyAccessible: kotlin.Boolean = builder.publiclyAccessible
    /**
     * Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output doesn't contain information about cross-Region Aurora read replicas.
     *
     * Currently, each RDS DB instance can have only one Aurora read replica.
     */
    public val readReplicaDbClusterIdentifiers: List<String>? = builder.readReplicaDbClusterIdentifiers
    /**
     * Contains one or more identifiers of the read replicas associated with this DB instance.
     */
    public val readReplicaDbInstanceIdentifiers: List<String>? = builder.readReplicaDbInstanceIdentifiers
    /**
     * Contains the identifier of the source DB instance if this DB instance is a read replica.
     */
    public val readReplicaSourceDbInstanceIdentifier: kotlin.String? = builder.readReplicaSourceDbInstanceIdentifier
    /**
     * The open mode of an Oracle read replica. The default is `open-read-only`. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
     *
     * This attribute is only supported in RDS for Oracle.
     */
    public val replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = builder.replicaMode
    /**
     * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440.
     */
    public val resumeFullAutomationModeTime: aws.smithy.kotlin.runtime.time.Instant? = builder.resumeFullAutomationModeTime
    /**
     * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
     */
    public val secondaryAvailabilityZone: kotlin.String? = builder.secondaryAvailabilityZone
    /**
     * The status of a read replica. If the instance isn't a read replica, this is blank.
     */
    public val statusInfos: List<DbInstanceStatusInfo>? = builder.statusInfos
    /**
     * Specifies whether the DB instance is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * Specifies the storage type associated with DB instance.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * The ARN from the key store with which the instance is associated for TDE encryption.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The time zone of the DB instance. In most cases, the `Timezone` element is empty. `Timezone` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * Provides a list of VPC security group elements that the DB instance belongs to.
     */
    public val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstance(")
        append("activityStreamEngineNativeAuditFieldsIncluded=$activityStreamEngineNativeAuditFieldsIncluded,")
        append("activityStreamKinesisStreamName=$activityStreamKinesisStreamName,")
        append("activityStreamKmsKeyId=$activityStreamKmsKeyId,")
        append("activityStreamMode=$activityStreamMode,")
        append("activityStreamPolicyStatus=$activityStreamPolicyStatus,")
        append("activityStreamStatus=$activityStreamStatus,")
        append("allocatedStorage=$allocatedStorage,")
        append("associatedRoles=$associatedRoles,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticRestartTime=$automaticRestartTime,")
        append("automationMode=$automationMode,")
        append("availabilityZone=$availabilityZone,")
        append("awsBackupRecoveryPointArn=$awsBackupRecoveryPointArn,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("backupTarget=$backupTarget,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("customIamInstanceProfile=$customIamInstanceProfile,")
        append("customerOwnedIpEnabled=$customerOwnedIpEnabled,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceArn=$dbInstanceArn,")
        append("dbInstanceAutomatedBackupsReplications=$dbInstanceAutomatedBackupsReplications,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbInstancePort=$dbInstancePort,")
        append("dbInstanceStatus=$dbInstanceStatus,")
        append("dbName=$dbName,")
        append("dbParameterGroups=$dbParameterGroups,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("dbiResourceId=$dbiResourceId,")
        append("deletionProtection=$deletionProtection,")
        append("domainMemberships=$domainMemberships,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("enhancedMonitoringResourceArn=$enhancedMonitoringResourceArn,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("licenseModel=$licenseModel,")
        append("listenerEndpoint=$listenerEndpoint,")
        append("masterUsername=$masterUsername,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("ncharCharacterSetName=$ncharCharacterSetName,")
        append("networkType=$networkType,")
        append("optionGroupMemberships=$optionGroupMemberships,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("performanceInsightsEnabled=$performanceInsightsEnabled,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("processorFeatures=$processorFeatures,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("readReplicaDbClusterIdentifiers=$readReplicaDbClusterIdentifiers,")
        append("readReplicaDbInstanceIdentifiers=$readReplicaDbInstanceIdentifiers,")
        append("readReplicaSourceDbInstanceIdentifier=$readReplicaSourceDbInstanceIdentifier,")
        append("replicaMode=$replicaMode,")
        append("resumeFullAutomationModeTime=$resumeFullAutomationModeTime,")
        append("secondaryAvailabilityZone=$secondaryAvailabilityZone,")
        append("statusInfos=$statusInfos,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tagList=$tagList,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("timezone=$timezone,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityStreamEngineNativeAuditFieldsIncluded?.hashCode() ?: 0
        result = 31 * result + (activityStreamKinesisStreamName?.hashCode() ?: 0)
        result = 31 * result + (activityStreamKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (activityStreamMode?.hashCode() ?: 0)
        result = 31 * result + (activityStreamPolicyStatus?.hashCode() ?: 0)
        result = 31 * result + (activityStreamStatus?.hashCode() ?: 0)
        result = 31 * result + (allocatedStorage)
        result = 31 * result + (associatedRoles?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade.hashCode())
        result = 31 * result + (automaticRestartTime?.hashCode() ?: 0)
        result = 31 * result + (automationMode?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (awsBackupRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod)
        result = 31 * result + (backupTarget?.hashCode() ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot.hashCode())
        result = 31 * result + (customIamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIpEnabled?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceAutomatedBackupsReplications?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstancePort)
        result = 31 * result + (dbInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection.hashCode())
        result = 31 * result + (domainMemberships?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoringResourceArn?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled.hashCode())
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (listenerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz.hashCode())
        result = 31 * result + (ncharCharacterSetName?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (optionGroupMemberships?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsEnabled?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible.hashCode())
        result = 31 * result + (readReplicaDbClusterIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readReplicaDbInstanceIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readReplicaSourceDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (replicaMode?.hashCode() ?: 0)
        result = 31 * result + (resumeFullAutomationModeTime?.hashCode() ?: 0)
        result = 31 * result + (secondaryAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (statusInfos?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbInstance

        if (activityStreamEngineNativeAuditFieldsIncluded != other.activityStreamEngineNativeAuditFieldsIncluded) return false
        if (activityStreamKinesisStreamName != other.activityStreamKinesisStreamName) return false
        if (activityStreamKmsKeyId != other.activityStreamKmsKeyId) return false
        if (activityStreamMode != other.activityStreamMode) return false
        if (activityStreamPolicyStatus != other.activityStreamPolicyStatus) return false
        if (activityStreamStatus != other.activityStreamStatus) return false
        if (allocatedStorage != other.allocatedStorage) return false
        if (associatedRoles != other.associatedRoles) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticRestartTime != other.automaticRestartTime) return false
        if (automationMode != other.automationMode) return false
        if (availabilityZone != other.availabilityZone) return false
        if (awsBackupRecoveryPointArn != other.awsBackupRecoveryPointArn) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (backupTarget != other.backupTarget) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (customIamInstanceProfile != other.customIamInstanceProfile) return false
        if (customerOwnedIpEnabled != other.customerOwnedIpEnabled) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceArn != other.dbInstanceArn) return false
        if (dbInstanceAutomatedBackupsReplications != other.dbInstanceAutomatedBackupsReplications) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbInstancePort != other.dbInstancePort) return false
        if (dbInstanceStatus != other.dbInstanceStatus) return false
        if (dbName != other.dbName) return false
        if (dbParameterGroups != other.dbParameterGroups) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domainMemberships != other.domainMemberships) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (enhancedMonitoringResourceArn != other.enhancedMonitoringResourceArn) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (licenseModel != other.licenseModel) return false
        if (listenerEndpoint != other.listenerEndpoint) return false
        if (masterUsername != other.masterUsername) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (ncharCharacterSetName != other.ncharCharacterSetName) return false
        if (networkType != other.networkType) return false
        if (optionGroupMemberships != other.optionGroupMemberships) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (performanceInsightsEnabled != other.performanceInsightsEnabled) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (processorFeatures != other.processorFeatures) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (readReplicaDbClusterIdentifiers != other.readReplicaDbClusterIdentifiers) return false
        if (readReplicaDbInstanceIdentifiers != other.readReplicaDbInstanceIdentifiers) return false
        if (readReplicaSourceDbInstanceIdentifier != other.readReplicaSourceDbInstanceIdentifier) return false
        if (replicaMode != other.replicaMode) return false
        if (resumeFullAutomationModeTime != other.resumeFullAutomationModeTime) return false
        if (secondaryAvailabilityZone != other.secondaryAvailabilityZone) return false
        if (statusInfos != other.statusInfos) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tagList != other.tagList) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (timezone != other.timezone) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbInstance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether engine-native audit fields are included in the database activity stream.
         */
        public var activityStreamEngineNativeAuditFieldsIncluded: kotlin.Boolean? = null
        /**
         * The name of the Amazon Kinesis data stream used for the database activity stream.
         */
        public var activityStreamKinesisStreamName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var activityStreamKmsKeyId: kotlin.String? = null
        /**
         * The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.
         */
        public var activityStreamMode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = null
        /**
         * The status of the policy state of the activity stream.
         */
        public var activityStreamPolicyStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamPolicyStatus? = null
        /**
         * The status of the database activity stream.
         */
        public var activityStreamStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamStatus? = null
        /**
         * Specifies the allocated storage size specified in gibibytes (GiB).
         */
        public var allocatedStorage: kotlin.Int = 0
        /**
         * The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance.
         */
        public var associatedRoles: List<DbInstanceRole>? = null
        /**
         * A value that indicates that minor version patches are applied automatically.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean = false
        /**
         * The time when a stopped DB instance is restarted automatically.
         */
        public var automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The automation mode of the RDS Custom DB instance: `full` or `all paused`. If `full`, the DB instance automates monitoring and instance recovery. If `all paused`, the instance pauses automation for the duration set by `--resume-full-automation-mode-minutes`.
         */
        public var automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = null
        /**
         * Specifies the name of the Availability Zone the DB instance is located in.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         */
        public var awsBackupRecoveryPointArn: kotlin.String? = null
        /**
         * Specifies the number of days for which automatic DB snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int = 0
        /**
         * Specifies where automated backups and manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.
         */
        public var backupTarget: kotlin.String? = null
        /**
         * The identifier of the CA certificate for this DB instance.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * If present, specifies the name of the character set that this instance is associated with.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
         *
         * **Amazon Aurora**
         *
         * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see `DBCluster`.
         */
        public var copyTagsToSnapshot: kotlin.Boolean = false
        /**
         * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:
         * + The profile must exist in your account.
         * + The profile must have an IAM role that Amazon EC2 has permissions to assume.
         * + The instance profile name and the associated IAM role name must start with the prefix `AWSRDSCustom`.
         *
         * For the list of permissions required for the IAM role, see [ Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
         */
        public var customIamInstanceProfile: kotlin.String? = null
        /**
         * Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.
         *
         * A *CoIP *provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.
         *
         * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
         *
         * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
         */
        public var customerOwnedIpEnabled: kotlin.Boolean? = null
        /**
         * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB instance.
         */
        public var dbInstanceArn: kotlin.String? = null
        /**
         * The list of replicated automated backups associated with the DB instance.
         */
        public var dbInstanceAutomatedBackupsReplications: List<DbInstanceAutomatedBackupsReplication>? = null
        /**
         * Contains the name of the compute and memory capacity class of the DB instance.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.
         */
        public var dbInstancePort: kotlin.Int = 0
        /**
         * Specifies the current state of this database.
         *
         * For information about DB instance statuses, see [Viewing DB instance status](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status) in the *Amazon RDS User Guide.*
         */
        public var dbInstanceStatus: kotlin.String? = null
        /**
         * The meaning of this parameter differs according to the database engine you use.
         *
         * **MySQL, MariaDB, SQL Server, PostgreSQL**
         *
         * Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.
         *
         * Type: String
         *
         * **Oracle**
         *
         * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.
         */
        public var dbName: kotlin.String? = null
        /**
         * Provides the list of DB parameter groups applied to this DB instance.
         */
        public var dbParameterGroups: List<DbParameterGroupStatus>? = null
        /**
         * A list of DB security group elements containing `DBSecurityGroup.Name` and `DBSecurityGroup.Status` subelements.
         */
        public var dbSecurityGroups: List<DbSecurityGroupMembership>? = null
        /**
         * Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.
         */
        public var dbSubnetGroup: aws.sdk.kotlin.services.rds.model.DbSubnetGroup? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB instance is accessed.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         */
        public var deletionProtection: kotlin.Boolean = false
        /**
         * The Active Directory Domain membership records associated with the DB instance.
         */
        public var domainMemberships: List<DomainMembership>? = null
        /**
         * A list of log types that this DB instance is configured to export to CloudWatch Logs.
         *
         * Log types vary by DB engine. For information about the log types for each DB engine, see [Amazon RDS Database Log Files](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html) in the *Amazon RDS User Guide.*
         */
        public var enabledCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies the connection endpoint.
         *
         * The endpoint might not be shown for instances whose status is `creating`.
         */
        public var endpoint: aws.sdk.kotlin.services.rds.model.Endpoint? = null
        /**
         * The name of the database engine to be used for this DB instance.
         */
        public var engine: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.
         */
        public var enhancedMonitoringResourceArn: kotlin.String? = null
        /**
         * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
         *
         * IAM database authentication can be enabled for the following database engines
         * + For MySQL 5.6, minor version 5.6.34 or higher
         * + For MySQL 5.7, minor version 5.7.16 or higher
         * + Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean = false
        /**
         * Provides the date and time the DB instance was created.
         */
        public var instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the Provisioned IOPS (I/O operations per second) value.
         */
        public var iops: kotlin.Int? = null
        /**
         * If `StorageEncrypted` is true, the Amazon Web Services KMS key identifier for the encrypted DB instance.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         */
        public var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * License model information for this DB instance. This setting doesn't apply to RDS Custom.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Specifies the listener connection endpoint for SQL Server Always On.
         */
        public var listenerEndpoint: aws.sdk.kotlin.services.rds.model.Endpoint? = null
        /**
         * Contains the master username for the DB instance.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         */
        public var maxAllocatedStorage: kotlin.Int? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Specifies if the DB instance is a Multi-AZ deployment. This setting doesn't apply to RDS Custom.
         */
        public var multiAz: kotlin.Boolean = false
        /**
         * The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2.
         */
        public var ncharCharacterSetName: kotlin.String? = null
        /**
         * The network type of the DB instance.
         *
         * Valid values:
         * + `IPV4`
         * + `DUAL`
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide* and [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
         */
        public var networkType: kotlin.String? = null
        /**
         * Provides the list of option group memberships for this DB instance.
         */
        public var optionGroupMemberships: List<OptionGroupMembership>? = null
        /**
         * A value that specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.rds.model.PendingModifiedValues? = null
        /**
         * True if Performance Insights is enabled for the DB instance, and otherwise false.
         */
        public var performanceInsightsEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
         * + 7
         * + *month* * 31, where *month* is a number of months from 1-23
         * + 731
         *
         * For example, the following values are valid:
         * + 93 (3 months * 31)
         * + 341 (11 months * 31)
         * + 589 (19 months * 31)
         * + 731
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         */
        public var processorFeatures: List<ProcessorFeature>? = null
        /**
         * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [ Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
         */
        public var promotionTier: kotlin.Int? = null
        /**
         * Specifies the accessibility options for the DB instance.
         *
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         *
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBInstance.
         */
        public var publiclyAccessible: kotlin.Boolean = false
        /**
         * Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output doesn't contain information about cross-Region Aurora read replicas.
         *
         * Currently, each RDS DB instance can have only one Aurora read replica.
         */
        public var readReplicaDbClusterIdentifiers: List<String>? = null
        /**
         * Contains one or more identifiers of the read replicas associated with this DB instance.
         */
        public var readReplicaDbInstanceIdentifiers: List<String>? = null
        /**
         * Contains the identifier of the source DB instance if this DB instance is a read replica.
         */
        public var readReplicaSourceDbInstanceIdentifier: kotlin.String? = null
        /**
         * The open mode of an Oracle read replica. The default is `open-read-only`. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
         *
         * This attribute is only supported in RDS for Oracle.
         */
        public var replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = null
        /**
         * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440.
         */
        public var resumeFullAutomationModeTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
         */
        public var secondaryAvailabilityZone: kotlin.String? = null
        /**
         * The status of a read replica. If the instance isn't a read replica, this is blank.
         */
        public var statusInfos: List<DbInstanceStatusInfo>? = null
        /**
         * Specifies whether the DB instance is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean = false
        /**
         * Specifies the storage type associated with DB instance.
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * The ARN from the key store with which the instance is associated for TDE encryption.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The time zone of the DB instance. In most cases, the `Timezone` element is empty. `Timezone` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.
         */
        public var timezone: kotlin.String? = null
        /**
         * Provides a list of VPC security group elements that the DB instance belongs to.
         */
        public var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbInstance) : this() {
            this.activityStreamEngineNativeAuditFieldsIncluded = x.activityStreamEngineNativeAuditFieldsIncluded
            this.activityStreamKinesisStreamName = x.activityStreamKinesisStreamName
            this.activityStreamKmsKeyId = x.activityStreamKmsKeyId
            this.activityStreamMode = x.activityStreamMode
            this.activityStreamPolicyStatus = x.activityStreamPolicyStatus
            this.activityStreamStatus = x.activityStreamStatus
            this.allocatedStorage = x.allocatedStorage
            this.associatedRoles = x.associatedRoles
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticRestartTime = x.automaticRestartTime
            this.automationMode = x.automationMode
            this.availabilityZone = x.availabilityZone
            this.awsBackupRecoveryPointArn = x.awsBackupRecoveryPointArn
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.backupTarget = x.backupTarget
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.customIamInstanceProfile = x.customIamInstanceProfile
            this.customerOwnedIpEnabled = x.customerOwnedIpEnabled
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceArn = x.dbInstanceArn
            this.dbInstanceAutomatedBackupsReplications = x.dbInstanceAutomatedBackupsReplications
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbInstancePort = x.dbInstancePort
            this.dbInstanceStatus = x.dbInstanceStatus
            this.dbName = x.dbName
            this.dbParameterGroups = x.dbParameterGroups
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroup = x.dbSubnetGroup
            this.dbiResourceId = x.dbiResourceId
            this.deletionProtection = x.deletionProtection
            this.domainMemberships = x.domainMemberships
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.enhancedMonitoringResourceArn = x.enhancedMonitoringResourceArn
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.instanceCreateTime = x.instanceCreateTime
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.licenseModel = x.licenseModel
            this.listenerEndpoint = x.listenerEndpoint
            this.masterUsername = x.masterUsername
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.ncharCharacterSetName = x.ncharCharacterSetName
            this.networkType = x.networkType
            this.optionGroupMemberships = x.optionGroupMemberships
            this.pendingModifiedValues = x.pendingModifiedValues
            this.performanceInsightsEnabled = x.performanceInsightsEnabled
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.processorFeatures = x.processorFeatures
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.readReplicaDbClusterIdentifiers = x.readReplicaDbClusterIdentifiers
            this.readReplicaDbInstanceIdentifiers = x.readReplicaDbInstanceIdentifiers
            this.readReplicaSourceDbInstanceIdentifier = x.readReplicaSourceDbInstanceIdentifier
            this.replicaMode = x.replicaMode
            this.resumeFullAutomationModeTime = x.resumeFullAutomationModeTime
            this.secondaryAvailabilityZone = x.secondaryAvailabilityZone
            this.statusInfos = x.statusInfos
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tagList = x.tagList
            this.tdeCredentialArn = x.tdeCredentialArn
            this.timezone = x.timezone
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbInstance = DbInstance(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.DbSubnetGroup] inside the given [block]
         */
        public fun dbSubnetGroup(block: aws.sdk.kotlin.services.rds.model.DbSubnetGroup.Builder.() -> kotlin.Unit) {
            this.dbSubnetGroup = aws.sdk.kotlin.services.rds.model.DbSubnetGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.Endpoint] inside the given [block]
         */
        public fun endpoint(block: aws.sdk.kotlin.services.rds.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.rds.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.Endpoint] inside the given [block]
         */
        public fun listenerEndpoint(block: aws.sdk.kotlin.services.rds.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.listenerEndpoint = aws.sdk.kotlin.services.rds.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.PendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.rds.model.PendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.rds.model.PendingModifiedValues.invoke(block)
        }
    }
}
