// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.
 */
public class DbInstanceAutomatedBackup private constructor(builder: Builder) {
    /**
     * Specifies the allocated storage size in gibibytes (GiB).
     */
    public val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The retention period for the automated backups.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * Specifies where automated backups are stored: Amazon Web Services Outposts or the Amazon Web Services Region.
     */
    public val backupTarget: kotlin.String? = builder.backupTarget
    /**
     * The Amazon Resource Name (ARN) for the automated backups.
     */
    public val dbInstanceArn: kotlin.String? = builder.dbInstanceArn
    /**
     * The Amazon Resource Name (ARN) for the replicated automated backups.
     */
    public val dbInstanceAutomatedBackupsArn: kotlin.String? = builder.dbInstanceAutomatedBackupsArn
    /**
     * The list of replications to different Amazon Web Services Regions associated with the automated backup.
     */
    public val dbInstanceAutomatedBackupsReplications: List<DbInstanceAutomatedBackupsReplication>? = builder.dbInstanceAutomatedBackupsReplications
    /**
     * The customer id of the instance that is/was associated with the automated backup.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * Specifies whether the automated backup is encrypted.
     */
    public val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * The name of the database engine for this automated backup.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version of the database engine for the automated backup.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean = builder.iamDatabaseAuthenticationEnabled
    /**
     * Provides the date and time that the DB instance was created.
     */
    public val instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.instanceCreateTime
    /**
     * The IOPS (I/O operations per second) value for the automated backup.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key ID for an automated backup.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * License model information for the automated backup.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The license model of an automated backup.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number that the automated backup used for connections.
     *
     * Default: Inherits from the source DB instance
     *
     * Valid Values: `1150-65535`
     */
    public val port: kotlin.Int = builder.port
    /**
     * The Amazon Web Services Region associated with the automated backup.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Earliest and latest time an instance can be restored to.
     */
    public val restoreWindow: aws.sdk.kotlin.services.rds.model.RestoreWindow? = builder.restoreWindow
    /**
     * Provides a list of status information for an automated backup:
     * + `active` - automated backups for current instances
     * + `retained` - automated backups for deleted instances
     * + `creating` - automated backups that are waiting for the first automated snapshot to be available.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Specifies the storage type associated with the automated backup.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The ARN from the key store with which the automated backup is associated for TDE encryption.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The time zone of the automated backup. In most cases, the `Timezone` element is empty. `Timezone` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * Provides the VPC ID associated with the DB instance
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstanceAutomatedBackup(")
        append("allocatedStorage=$allocatedStorage,")
        append("availabilityZone=$availabilityZone,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("backupTarget=$backupTarget,")
        append("dbInstanceArn=$dbInstanceArn,")
        append("dbInstanceAutomatedBackupsArn=$dbInstanceAutomatedBackupsArn,")
        append("dbInstanceAutomatedBackupsReplications=$dbInstanceAutomatedBackupsReplications,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbiResourceId=$dbiResourceId,")
        append("encrypted=$encrypted,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUsername=$masterUsername,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("region=$region,")
        append("restoreWindow=$restoreWindow,")
        append("status=$status,")
        append("storageType=$storageType,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("timezone=$timezone,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (backupTarget?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceAutomatedBackupsArn?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceAutomatedBackupsReplications?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled.hashCode())
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (restoreWindow?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbInstanceAutomatedBackup

        if (allocatedStorage != other.allocatedStorage) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (backupTarget != other.backupTarget) return false
        if (dbInstanceArn != other.dbInstanceArn) return false
        if (dbInstanceAutomatedBackupsArn != other.dbInstanceAutomatedBackupsArn) return false
        if (dbInstanceAutomatedBackupsReplications != other.dbInstanceAutomatedBackupsReplications) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (encrypted != other.encrypted) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUsername != other.masterUsername) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (region != other.region) return false
        if (restoreWindow != other.restoreWindow) return false
        if (status != other.status) return false
        if (storageType != other.storageType) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (timezone != other.timezone) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the allocated storage size in gibibytes (GiB).
         */
        public var allocatedStorage: kotlin.Int = 0
        /**
         * The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The retention period for the automated backups.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * Specifies where automated backups are stored: Amazon Web Services Outposts or the Amazon Web Services Region.
         */
        public var backupTarget: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the automated backups.
         */
        public var dbInstanceArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the replicated automated backups.
         */
        public var dbInstanceAutomatedBackupsArn: kotlin.String? = null
        /**
         * The list of replications to different Amazon Web Services Regions associated with the automated backup.
         */
        public var dbInstanceAutomatedBackupsReplications: List<DbInstanceAutomatedBackupsReplication>? = null
        /**
         * The customer id of the instance that is/was associated with the automated backup.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * Specifies whether the automated backup is encrypted.
         */
        public var encrypted: kotlin.Boolean = false
        /**
         * The name of the database engine for this automated backup.
         */
        public var engine: kotlin.String? = null
        /**
         * The version of the database engine for the automated backup.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean = false
        /**
         * Provides the date and time that the DB instance was created.
         */
        public var instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IOPS (I/O operations per second) value for the automated backup.
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key ID for an automated backup.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * License model information for the automated backup.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * The license model of an automated backup.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number that the automated backup used for connections.
         *
         * Default: Inherits from the source DB instance
         *
         * Valid Values: `1150-65535`
         */
        public var port: kotlin.Int = 0
        /**
         * The Amazon Web Services Region associated with the automated backup.
         */
        public var region: kotlin.String? = null
        /**
         * Earliest and latest time an instance can be restored to.
         */
        public var restoreWindow: aws.sdk.kotlin.services.rds.model.RestoreWindow? = null
        /**
         * Provides a list of status information for an automated backup:
         * + `active` - automated backups for current instances
         * + `retained` - automated backups for deleted instances
         * + `creating` - automated backups that are waiting for the first automated snapshot to be available.
         */
        public var status: kotlin.String? = null
        /**
         * Specifies the storage type associated with the automated backup.
         */
        public var storageType: kotlin.String? = null
        /**
         * The ARN from the key store with which the automated backup is associated for TDE encryption.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The time zone of the automated backup. In most cases, the `Timezone` element is empty. `Timezone` content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.
         */
        public var timezone: kotlin.String? = null
        /**
         * Provides the VPC ID associated with the DB instance
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.availabilityZone = x.availabilityZone
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.backupTarget = x.backupTarget
            this.dbInstanceArn = x.dbInstanceArn
            this.dbInstanceAutomatedBackupsArn = x.dbInstanceAutomatedBackupsArn
            this.dbInstanceAutomatedBackupsReplications = x.dbInstanceAutomatedBackupsReplications
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbiResourceId = x.dbiResourceId
            this.encrypted = x.encrypted
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.instanceCreateTime = x.instanceCreateTime
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUsername = x.masterUsername
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.region = x.region
            this.restoreWindow = x.restoreWindow
            this.status = x.status
            this.storageType = x.storageType
            this.tdeCredentialArn = x.tdeCredentialArn
            this.timezone = x.timezone
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup = DbInstanceAutomatedBackup(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.RestoreWindow] inside the given [block]
         */
        public fun restoreWindow(block: aws.sdk.kotlin.services.rds.model.RestoreWindow.Builder.() -> kotlin.Unit) {
            this.restoreWindow = aws.sdk.kotlin.services.rds.model.RestoreWindow.invoke(block)
        }
    }
}
