// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the details of an Amazon RDS DB parameter group.
 *
 * This data type is used as a response element in the `DescribeDBParameterGroups` action.
 */
public class DbParameterGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the DB parameter group.
     */
    public val dbParameterGroupArn: kotlin.String? = builder.dbParameterGroupArn
    /**
     * The name of the DB parameter group family that this DB parameter group is compatible with.
     */
    public val dbParameterGroupFamily: kotlin.String? = builder.dbParameterGroupFamily
    /**
     * The name of the DB parameter group.
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * Provides the customer-specified description for this DB parameter group.
     */
    public val description: kotlin.String? = builder.description

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbParameterGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbParameterGroup(")
        append("dbParameterGroupArn=$dbParameterGroupArn,")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("description=$description)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbParameterGroupArn?.hashCode() ?: 0
        result = 31 * result + (dbParameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbParameterGroup

        if (dbParameterGroupArn != other.dbParameterGroupArn) return false
        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (description != other.description) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbParameterGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the DB parameter group.
         */
        public var dbParameterGroupArn: kotlin.String? = null
        /**
         * The name of the DB parameter group family that this DB parameter group is compatible with.
         */
        public var dbParameterGroupFamily: kotlin.String? = null
        /**
         * The name of the DB parameter group.
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * Provides the customer-specified description for this DB parameter group.
         */
        public var description: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbParameterGroup) : this() {
            this.dbParameterGroupArn = x.dbParameterGroupArn
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.dbParameterGroupName = x.dbParameterGroupName
            this.description = x.description
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbParameterGroup = DbParameterGroup(this)
    }
}
