// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the details for an Amazon RDS DB security group.
 *
 * This data type is used as a response element in the `DescribeDBSecurityGroups` action.
 */
public class DbSecurityGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the DB security group.
     */
    public val dbSecurityGroupArn: kotlin.String? = builder.dbSecurityGroupArn
    /**
     * Provides the description of the DB security group.
     */
    public val dbSecurityGroupDescription: kotlin.String? = builder.dbSecurityGroupDescription
    /**
     * Specifies the name of the DB security group.
     */
    public val dbSecurityGroupName: kotlin.String? = builder.dbSecurityGroupName
    /**
     * Contains a list of `EC2SecurityGroup` elements.
     */
    public val ec2SecurityGroups: List<Ec2SecurityGroup>? = builder.ec2SecurityGroups
    /**
     * Contains a list of `IPRange` elements.
     */
    public val ipRanges: List<IpRange>? = builder.ipRanges
    /**
     * Provides the Amazon Web Services ID of the owner of a specific DB security group.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * Provides the VpcId of the DB security group.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbSecurityGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbSecurityGroup(")
        append("dbSecurityGroupArn=$dbSecurityGroupArn,")
        append("dbSecurityGroupDescription=$dbSecurityGroupDescription,")
        append("dbSecurityGroupName=$dbSecurityGroupName,")
        append("ec2SecurityGroups=$ec2SecurityGroups,")
        append("ipRanges=$ipRanges,")
        append("ownerId=$ownerId,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbSecurityGroupArn?.hashCode() ?: 0
        result = 31 * result + (dbSecurityGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (dbSecurityGroupName?.hashCode() ?: 0)
        result = 31 * result + (ec2SecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (ipRanges?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbSecurityGroup

        if (dbSecurityGroupArn != other.dbSecurityGroupArn) return false
        if (dbSecurityGroupDescription != other.dbSecurityGroupDescription) return false
        if (dbSecurityGroupName != other.dbSecurityGroupName) return false
        if (ec2SecurityGroups != other.ec2SecurityGroups) return false
        if (ipRanges != other.ipRanges) return false
        if (ownerId != other.ownerId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbSecurityGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the DB security group.
         */
        public var dbSecurityGroupArn: kotlin.String? = null
        /**
         * Provides the description of the DB security group.
         */
        public var dbSecurityGroupDescription: kotlin.String? = null
        /**
         * Specifies the name of the DB security group.
         */
        public var dbSecurityGroupName: kotlin.String? = null
        /**
         * Contains a list of `EC2SecurityGroup` elements.
         */
        public var ec2SecurityGroups: List<Ec2SecurityGroup>? = null
        /**
         * Contains a list of `IPRange` elements.
         */
        public var ipRanges: List<IpRange>? = null
        /**
         * Provides the Amazon Web Services ID of the owner of a specific DB security group.
         */
        public var ownerId: kotlin.String? = null
        /**
         * Provides the VpcId of the DB security group.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbSecurityGroup) : this() {
            this.dbSecurityGroupArn = x.dbSecurityGroupArn
            this.dbSecurityGroupDescription = x.dbSecurityGroupDescription
            this.dbSecurityGroupName = x.dbSecurityGroupName
            this.ec2SecurityGroups = x.ec2SecurityGroups
            this.ipRanges = x.ipRanges
            this.ownerId = x.ownerId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbSecurityGroup = DbSecurityGroup(this)
    }
}
