// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of an Amazon RDS DB snapshot.
 *
 * This data type is used as a response element in the `DescribeDBSnapshots` action.
 */
public class DbSnapshot private constructor(builder: Builder) {
    /**
     * Specifies the allocated storage size in gibibytes (GiB).
     */
    public val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Specifies the DB instance identifier of the DB instance this DB snapshot was created from.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The Amazon Resource Name (ARN) for the DB snapshot.
     */
    public val dbSnapshotArn: kotlin.String? = builder.dbSnapshotArn
    /**
     * Specifies the identifier for the DB snapshot.
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * Specifies whether the DB snapshot is encrypted.
     */
    public val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * Specifies the name of the database engine.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Specifies the version of the database engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean = builder.iamDatabaseAuthenticationEnabled
    /**
     * Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.
     */
    public val instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.instanceCreateTime
    /**
     * Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * If `Encrypted` is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * License model information for the restored DB instance.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Provides the master username for the DB snapshot.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Provides the option group name for the DB snapshot.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * Specifies the time of the CreateDBSnapshot operation in Coordinated Universal Time (UTC). Doesn't change when the snapshot is copied.
     */
    public val originalSnapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.originalSnapshotCreateTime
    /**
     * The percentage of the estimated data that has been transferred.
     */
    public val percentProgress: kotlin.Int = builder.percentProgress
    /**
     * Specifies the port that the database engine was listening on at the time of the snapshot.
     */
    public val port: kotlin.Int = builder.port
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.
     */
    public val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * Specifies when the snapshot was taken in Coordinated Universal Time (UTC). Changes for the copy when the snapshot is copied.
     */
    public val snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotCreateTime
    /**
     * Specifies where manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.
     */
    public val snapshotTarget: kotlin.String? = builder.snapshotTarget
    /**
     * Provides the type of the DB snapshot.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has a value in the case of a cross-account or cross-Region copy.
     */
    public val sourceDbSnapshotIdentifier: kotlin.String? = builder.sourceDbSnapshotIdentifier
    /**
     * The Amazon Web Services Region that the DB snapshot was created in or copied from.
     */
    public val sourceRegion: kotlin.String? = builder.sourceRegion
    /**
     * Specifies the status of this DB snapshot.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Specifies the storage type associated with DB snapshot.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The time zone of the DB snapshot. In most cases, the `Timezone` element is empty. `Timezone` content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * Provides the VPC ID associated with the DB snapshot.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbSnapshot(")
        append("allocatedStorage=$allocatedStorage,")
        append("availabilityZone=$availabilityZone,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSnapshotArn=$dbSnapshotArn,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("dbiResourceId=$dbiResourceId,")
        append("encrypted=$encrypted,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUsername=$masterUsername,")
        append("optionGroupName=$optionGroupName,")
        append("originalSnapshotCreateTime=$originalSnapshotCreateTime,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("processorFeatures=$processorFeatures,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotTarget=$snapshotTarget,")
        append("snapshotType=$snapshotType,")
        append("sourceDbSnapshotIdentifier=$sourceDbSnapshotIdentifier,")
        append("sourceRegion=$sourceRegion,")
        append("status=$status,")
        append("storageType=$storageType,")
        append("tagList=$tagList,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("timezone=$timezone,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled.hashCode())
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (originalSnapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (percentProgress)
        result = 31 * result + (port)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotTarget?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbSnapshot

        if (allocatedStorage != other.allocatedStorage) return false
        if (availabilityZone != other.availabilityZone) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSnapshotArn != other.dbSnapshotArn) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (encrypted != other.encrypted) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUsername != other.masterUsername) return false
        if (optionGroupName != other.optionGroupName) return false
        if (originalSnapshotCreateTime != other.originalSnapshotCreateTime) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (processorFeatures != other.processorFeatures) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotTarget != other.snapshotTarget) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceDbSnapshotIdentifier != other.sourceDbSnapshotIdentifier) return false
        if (sourceRegion != other.sourceRegion) return false
        if (status != other.status) return false
        if (storageType != other.storageType) return false
        if (tagList != other.tagList) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (timezone != other.timezone) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbSnapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the allocated storage size in gibibytes (GiB).
         */
        public var allocatedStorage: kotlin.Int = 0
        /**
         * Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * Specifies the DB instance identifier of the DB instance this DB snapshot was created from.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB snapshot.
         */
        public var dbSnapshotArn: kotlin.String? = null
        /**
         * Specifies the identifier for the DB snapshot.
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * Specifies whether the DB snapshot is encrypted.
         */
        public var encrypted: kotlin.Boolean = false
        /**
         * Specifies the name of the database engine.
         */
        public var engine: kotlin.String? = null
        /**
         * Specifies the version of the database engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean = false
        /**
         * Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.
         */
        public var instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
         */
        public var iops: kotlin.Int? = null
        /**
         * If `Encrypted` is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * License model information for the restored DB instance.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Provides the master username for the DB snapshot.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * Provides the option group name for the DB snapshot.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * Specifies the time of the CreateDBSnapshot operation in Coordinated Universal Time (UTC). Doesn't change when the snapshot is copied.
         */
        public var originalSnapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The percentage of the estimated data that has been transferred.
         */
        public var percentProgress: kotlin.Int = 0
        /**
         * Specifies the port that the database engine was listening on at the time of the snapshot.
         */
        public var port: kotlin.Int = 0
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.
         */
        public var processorFeatures: List<ProcessorFeature>? = null
        /**
         * Specifies when the snapshot was taken in Coordinated Universal Time (UTC). Changes for the copy when the snapshot is copied.
         */
        public var snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies where manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.
         */
        public var snapshotTarget: kotlin.String? = null
        /**
         * Provides the type of the DB snapshot.
         */
        public var snapshotType: kotlin.String? = null
        /**
         * The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has a value in the case of a cross-account or cross-Region copy.
         */
        public var sourceDbSnapshotIdentifier: kotlin.String? = null
        /**
         * The Amazon Web Services Region that the DB snapshot was created in or copied from.
         */
        public var sourceRegion: kotlin.String? = null
        /**
         * Specifies the status of this DB snapshot.
         */
        public var status: kotlin.String? = null
        /**
         * Specifies the storage type associated with DB snapshot.
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The time zone of the DB snapshot. In most cases, the `Timezone` element is empty. `Timezone` content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.
         */
        public var timezone: kotlin.String? = null
        /**
         * Provides the VPC ID associated with the DB snapshot.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbSnapshot) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.availabilityZone = x.availabilityZone
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSnapshotArn = x.dbSnapshotArn
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.dbiResourceId = x.dbiResourceId
            this.encrypted = x.encrypted
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.instanceCreateTime = x.instanceCreateTime
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUsername = x.masterUsername
            this.optionGroupName = x.optionGroupName
            this.originalSnapshotCreateTime = x.originalSnapshotCreateTime
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.processorFeatures = x.processorFeatures
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotTarget = x.snapshotTarget
            this.snapshotType = x.snapshotType
            this.sourceDbSnapshotIdentifier = x.sourceDbSnapshotIdentifier
            this.sourceRegion = x.sourceRegion
            this.status = x.status
            this.storageType = x.storageType
            this.tagList = x.tagList
            this.tdeCredentialArn = x.tdeCredentialArn
            this.timezone = x.timezone
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbSnapshot = DbSnapshot(this)
    }
}
