// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This data type is used as a response element in the action `DescribeDBEngineVersions`.
 */
public class DeleteCustomDbEngineVersionResponse private constructor(builder: Builder) {
    /**
     * The creation time of the DB engine version.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The name of the Amazon S3 bucket that contains your database installation files.
     */
    public val databaseInstallationFilesS3BucketName: kotlin.String? = builder.databaseInstallationFilesS3BucketName
    /**
     * The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is assumed.
     */
    public val databaseInstallationFilesS3Prefix: kotlin.String? = builder.databaseInstallationFilesS3Prefix
    /**
     * The description of the database engine.
     */
    public val dbEngineDescription: kotlin.String? = builder.dbEngineDescription
    /**
     * The ARN of the custom engine version.
     */
    public val dbEngineVersionArn: kotlin.String? = builder.dbEngineVersionArn
    /**
     * The description of the database engine version.
     */
    public val dbEngineVersionDescription: kotlin.String? = builder.dbEngineVersionDescription
    /**
     * The name of the DB parameter group family for the database engine.
     */
    public val dbParameterGroupFamily: kotlin.String? = builder.dbParameterGroupFamily
    /**
     * The default character set for new instances of this engine version, if the `CharacterSetName` parameter of the CreateDBInstance API isn't specified.
     */
    public val defaultCharacterSet: aws.sdk.kotlin.services.rds.model.CharacterSet? = builder.defaultCharacterSet
    /**
     * The name of the database engine.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The types of logs that the database engine has available for export to CloudWatch Logs.
     */
    public val exportableLogTypes: List<String>? = builder.exportableLogTypes
    /**
     * The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom, but optional for Amazon RDS.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The major engine version of the CEV.
     */
    public val majorEngineVersion: kotlin.String? = builder.majorEngineVersion
    /**
     * The status of the DB engine version, either `available` or `deprecated`.
     */
    public val status: kotlin.String? = builder.status
    /**
     * A list of the character sets supported by this engine for the `CharacterSetName` parameter of the `CreateDBInstance` operation.
     */
    public val supportedCharacterSets: List<CharacterSet>? = builder.supportedCharacterSets
    /**
     * A list of the supported DB engine modes.
     */
    public val supportedEngineModes: List<String>? = builder.supportedEngineModes
    /**
     * A list of features supported by the DB engine.
     *
     * The supported features vary by DB engine and DB engine version.
     *
     * To determine the supported features for a specific DB engine and DB engine version using the CLI, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version>`
     *
     * For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine postgres --engine-version 13.3`
     *
     * The supported features are listed under `SupportedFeatureNames` in the output.
     */
    public val supportedFeatureNames: List<String>? = builder.supportedFeatureNames
    /**
     * A list of the character sets supported by the Oracle DB engine for the `NcharCharacterSetName` parameter of the `CreateDBInstance` operation.
     */
    public val supportedNcharCharacterSets: List<CharacterSet>? = builder.supportedNcharCharacterSets
    /**
     * A list of the time zones supported by this engine for the `Timezone` parameter of the `CreateDBInstance` action.
     */
    public val supportedTimezones: List<Timezone>? = builder.supportedTimezones
    /**
     * A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.
     */
    public val supportsBabelfish: kotlin.Boolean = builder.supportsBabelfish
    /**
     * A value that indicates whether you can use Aurora global databases with a specific DB engine version.
     */
    public val supportsGlobalDatabases: kotlin.Boolean = builder.supportsGlobalDatabases
    /**
     * A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.
     */
    public val supportsLogExportsToCloudwatchLogs: kotlin.Boolean = builder.supportsLogExportsToCloudwatchLogs
    /**
     * A value that indicates whether you can use Aurora parallel query with a specific DB engine version.
     */
    public val supportsParallelQuery: kotlin.Boolean = builder.supportsParallelQuery
    /**
     * Indicates whether the database engine version supports read replicas.
     */
    public val supportsReadReplica: kotlin.Boolean = builder.supportsReadReplica
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * A list of engine versions that this database engine version can be upgraded to.
     */
    public val validUpgradeTarget: List<UpgradeTarget>? = builder.validUpgradeTarget

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DeleteCustomDbEngineVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteCustomDbEngineVersionResponse(")
        append("createTime=$createTime,")
        append("databaseInstallationFilesS3BucketName=$databaseInstallationFilesS3BucketName,")
        append("databaseInstallationFilesS3Prefix=$databaseInstallationFilesS3Prefix,")
        append("dbEngineDescription=$dbEngineDescription,")
        append("dbEngineVersionArn=$dbEngineVersionArn,")
        append("dbEngineVersionDescription=$dbEngineVersionDescription,")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("defaultCharacterSet=$defaultCharacterSet,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("exportableLogTypes=$exportableLogTypes,")
        append("kmsKeyId=$kmsKeyId,")
        append("majorEngineVersion=$majorEngineVersion,")
        append("status=$status,")
        append("supportedCharacterSets=$supportedCharacterSets,")
        append("supportedEngineModes=$supportedEngineModes,")
        append("supportedFeatureNames=$supportedFeatureNames,")
        append("supportedNcharCharacterSets=$supportedNcharCharacterSets,")
        append("supportedTimezones=$supportedTimezones,")
        append("supportsBabelfish=$supportsBabelfish,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases,")
        append("supportsLogExportsToCloudwatchLogs=$supportsLogExportsToCloudwatchLogs,")
        append("supportsParallelQuery=$supportsParallelQuery,")
        append("supportsReadReplica=$supportsReadReplica,")
        append("tagList=$tagList,")
        append("validUpgradeTarget=$validUpgradeTarget)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (databaseInstallationFilesS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (databaseInstallationFilesS3Prefix?.hashCode() ?: 0)
        result = 31 * result + (dbEngineDescription?.hashCode() ?: 0)
        result = 31 * result + (dbEngineVersionArn?.hashCode() ?: 0)
        result = 31 * result + (dbEngineVersionDescription?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (defaultCharacterSet?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (exportableLogTypes?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (majorEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (supportedCharacterSets?.hashCode() ?: 0)
        result = 31 * result + (supportedEngineModes?.hashCode() ?: 0)
        result = 31 * result + (supportedFeatureNames?.hashCode() ?: 0)
        result = 31 * result + (supportedNcharCharacterSets?.hashCode() ?: 0)
        result = 31 * result + (supportedTimezones?.hashCode() ?: 0)
        result = 31 * result + (supportsBabelfish.hashCode())
        result = 31 * result + (supportsGlobalDatabases.hashCode())
        result = 31 * result + (supportsLogExportsToCloudwatchLogs.hashCode())
        result = 31 * result + (supportsParallelQuery.hashCode())
        result = 31 * result + (supportsReadReplica.hashCode())
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (validUpgradeTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteCustomDbEngineVersionResponse

        if (createTime != other.createTime) return false
        if (databaseInstallationFilesS3BucketName != other.databaseInstallationFilesS3BucketName) return false
        if (databaseInstallationFilesS3Prefix != other.databaseInstallationFilesS3Prefix) return false
        if (dbEngineDescription != other.dbEngineDescription) return false
        if (dbEngineVersionArn != other.dbEngineVersionArn) return false
        if (dbEngineVersionDescription != other.dbEngineVersionDescription) return false
        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (defaultCharacterSet != other.defaultCharacterSet) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (exportableLogTypes != other.exportableLogTypes) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (majorEngineVersion != other.majorEngineVersion) return false
        if (status != other.status) return false
        if (supportedCharacterSets != other.supportedCharacterSets) return false
        if (supportedEngineModes != other.supportedEngineModes) return false
        if (supportedFeatureNames != other.supportedFeatureNames) return false
        if (supportedNcharCharacterSets != other.supportedNcharCharacterSets) return false
        if (supportedTimezones != other.supportedTimezones) return false
        if (supportsBabelfish != other.supportsBabelfish) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false
        if (supportsLogExportsToCloudwatchLogs != other.supportsLogExportsToCloudwatchLogs) return false
        if (supportsParallelQuery != other.supportsParallelQuery) return false
        if (supportsReadReplica != other.supportsReadReplica) return false
        if (tagList != other.tagList) return false
        if (validUpgradeTarget != other.validUpgradeTarget) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DeleteCustomDbEngineVersionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The creation time of the DB engine version.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon S3 bucket that contains your database installation files.
         */
        public var databaseInstallationFilesS3BucketName: kotlin.String? = null
        /**
         * The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is assumed.
         */
        public var databaseInstallationFilesS3Prefix: kotlin.String? = null
        /**
         * The description of the database engine.
         */
        public var dbEngineDescription: kotlin.String? = null
        /**
         * The ARN of the custom engine version.
         */
        public var dbEngineVersionArn: kotlin.String? = null
        /**
         * The description of the database engine version.
         */
        public var dbEngineVersionDescription: kotlin.String? = null
        /**
         * The name of the DB parameter group family for the database engine.
         */
        public var dbParameterGroupFamily: kotlin.String? = null
        /**
         * The default character set for new instances of this engine version, if the `CharacterSetName` parameter of the CreateDBInstance API isn't specified.
         */
        public var defaultCharacterSet: aws.sdk.kotlin.services.rds.model.CharacterSet? = null
        /**
         * The name of the database engine.
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the database engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The types of logs that the database engine has available for export to CloudWatch Logs.
         */
        public var exportableLogTypes: List<String>? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom, but optional for Amazon RDS.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The major engine version of the CEV.
         */
        public var majorEngineVersion: kotlin.String? = null
        /**
         * The status of the DB engine version, either `available` or `deprecated`.
         */
        public var status: kotlin.String? = null
        /**
         * A list of the character sets supported by this engine for the `CharacterSetName` parameter of the `CreateDBInstance` operation.
         */
        public var supportedCharacterSets: List<CharacterSet>? = null
        /**
         * A list of the supported DB engine modes.
         */
        public var supportedEngineModes: List<String>? = null
        /**
         * A list of features supported by the DB engine.
         *
         * The supported features vary by DB engine and DB engine version.
         *
         * To determine the supported features for a specific DB engine and DB engine version using the CLI, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version>`
         *
         * For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine postgres --engine-version 13.3`
         *
         * The supported features are listed under `SupportedFeatureNames` in the output.
         */
        public var supportedFeatureNames: List<String>? = null
        /**
         * A list of the character sets supported by the Oracle DB engine for the `NcharCharacterSetName` parameter of the `CreateDBInstance` operation.
         */
        public var supportedNcharCharacterSets: List<CharacterSet>? = null
        /**
         * A list of the time zones supported by this engine for the `Timezone` parameter of the `CreateDBInstance` action.
         */
        public var supportedTimezones: List<Timezone>? = null
        /**
         * A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.
         */
        public var supportsBabelfish: kotlin.Boolean = false
        /**
         * A value that indicates whether you can use Aurora global databases with a specific DB engine version.
         */
        public var supportsGlobalDatabases: kotlin.Boolean = false
        /**
         * A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.
         */
        public var supportsLogExportsToCloudwatchLogs: kotlin.Boolean = false
        /**
         * A value that indicates whether you can use Aurora parallel query with a specific DB engine version.
         */
        public var supportsParallelQuery: kotlin.Boolean = false
        /**
         * Indicates whether the database engine version supports read replicas.
         */
        public var supportsReadReplica: kotlin.Boolean = false
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * A list of engine versions that this database engine version can be upgraded to.
         */
        public var validUpgradeTarget: List<UpgradeTarget>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DeleteCustomDbEngineVersionResponse) : this() {
            this.createTime = x.createTime
            this.databaseInstallationFilesS3BucketName = x.databaseInstallationFilesS3BucketName
            this.databaseInstallationFilesS3Prefix = x.databaseInstallationFilesS3Prefix
            this.dbEngineDescription = x.dbEngineDescription
            this.dbEngineVersionArn = x.dbEngineVersionArn
            this.dbEngineVersionDescription = x.dbEngineVersionDescription
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.defaultCharacterSet = x.defaultCharacterSet
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.exportableLogTypes = x.exportableLogTypes
            this.kmsKeyId = x.kmsKeyId
            this.majorEngineVersion = x.majorEngineVersion
            this.status = x.status
            this.supportedCharacterSets = x.supportedCharacterSets
            this.supportedEngineModes = x.supportedEngineModes
            this.supportedFeatureNames = x.supportedFeatureNames
            this.supportedNcharCharacterSets = x.supportedNcharCharacterSets
            this.supportedTimezones = x.supportedTimezones
            this.supportsBabelfish = x.supportsBabelfish
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
            this.supportsLogExportsToCloudwatchLogs = x.supportsLogExportsToCloudwatchLogs
            this.supportsParallelQuery = x.supportsParallelQuery
            this.supportsReadReplica = x.supportsReadReplica
            this.tagList = x.tagList
            this.validUpgradeTarget = x.validUpgradeTarget
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DeleteCustomDbEngineVersionResponse = DeleteCustomDbEngineVersionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.CharacterSet] inside the given [block]
         */
        public fun defaultCharacterSet(block: aws.sdk.kotlin.services.rds.model.CharacterSet.Builder.() -> kotlin.Unit) {
            this.defaultCharacterSet = aws.sdk.kotlin.services.rds.model.CharacterSet.invoke(block)
        }
    }
}
