// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class DescribeDbInstancesRequest private constructor(builder: Builder) {
    /**
     * The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + If supplied, must match the identifier of an existing DBInstance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * A filter that specifies one or more DB instances to describe.
     *
     * Supported filters:
     * + `db-cluster-id` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB instances associated with the DB clusters identified by these ARNs.
     * + `db-instance-id` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list only includes information about the DB instances identified by these ARNs.
     * + `dbi-resource-id` - Accepts DB instance resource identifiers. The results list will only include information about the DB instances identified by these DB instance resource identifiers.
     * + `domain` - Accepts Active Directory directory IDs. The results list only includes information about the DB instances associated with these domains.
     * + `engine` - Accepts engine names. The results list only includes information about the DB instances for these engines.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous `DescribeDBInstances` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbInstancesRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbInstancesRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + If supplied, must match the identifier of an existing DBInstance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * A filter that specifies one or more DB instances to describe.
         *
         * Supported filters:
         * + `db-cluster-id` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB instances associated with the DB clusters identified by these ARNs.
         * + `db-instance-id` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list only includes information about the DB instances identified by these ARNs.
         * + `dbi-resource-id` - Accepts DB instance resource identifiers. The results list will only include information about the DB instances identified by these DB instance resource identifiers.
         * + `domain` - Accepts Active Directory directory IDs. The results list only includes information about the DB instances associated with these domains.
         * + `engine` - Accepts engine names. The results list only includes information about the DB instances for these engines.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous `DescribeDBInstances` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbInstancesRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbInstancesRequest = DescribeDbInstancesRequest(this)
    }
}
