// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class DescribeDbSnapshotsRequest private constructor(builder: Builder) {
    /**
     * The ID of the DB instance to retrieve the list of DB snapshots for. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + If supplied, must match the identifier of an existing DBInstance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * A specific DB snapshot identifier to describe. This value is stored as a lowercase string.
     *
     * Constraints:
     * + If supplied, must match the identifier of an existing DBSnapshot.
     * + If this identifier is for an automated snapshot, the `SnapshotType` parameter must also be specified.
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * A specific DB resource ID to describe.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * A filter that specifies one or more DB snapshots to describe.
     *
     * Supported filters:
     * + `db-instance-id` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
     * + `db-snapshot-id` - Accepts DB snapshot identifiers.
     * + `dbi-resource-id` - Accepts identifiers of source DB instances.
     * + `snapshot-type` - Accepts types of DB snapshots.
     * + `engine` - Accepts names of database engines.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.
     *
     * You can share a manual DB snapshot as public by using the ModifyDBSnapshotAttribute API.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val includePublic: kotlin.Boolean = builder.includePublic
    /**
     * A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.
     *
     * You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the `ModifyDBSnapshotAttribute` API action.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val includeShared: kotlin.Boolean = builder.includeShared
    /**
     * An optional pagination token provided by a previous `DescribeDBSnapshots` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The type of snapshots to be returned. You can specify one of the following values:
     * + `automated` - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.
     * + `manual` - Return all DB snapshots that have been taken by my Amazon Web Services account.
     * + `shared` - Return all manual DB snapshots that have been shared to my Amazon Web Services account.
     * + `public` - Return all DB snapshots that have been marked as public.
     * + `awsbackup` - Return the DB snapshots managed by the Amazon Web Services Backup service.For information about Amazon Web Services Backup, see the *Amazon Web Services Backup Developer Guide.*[](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html)The `awsbackup` type does not apply to Aurora.
     *
     * If you don't specify a `SnapshotType` value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the `IncludeShared` parameter. You can include public snapshots with these results by enabling the `IncludePublic` parameter.
     *
     * The `IncludeShared` and `IncludePublic` parameters don't apply for `SnapshotType` values of `manual` or `automated`. The `IncludePublic` parameter doesn't apply when `SnapshotType` is set to `shared`. The `IncludeShared` parameter doesn't apply when `SnapshotType` is set to `public`.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbSnapshotsRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("dbiResourceId=$dbiResourceId,")
        append("filters=$filters,")
        append("includePublic=$includePublic,")
        append("includeShared=$includeShared,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("snapshotType=$snapshotType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includePublic.hashCode())
        result = 31 * result + (includeShared.hashCode())
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbSnapshotsRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (filters != other.filters) return false
        if (includePublic != other.includePublic) return false
        if (includeShared != other.includeShared) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (snapshotType != other.snapshotType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the DB instance to retrieve the list of DB snapshots for. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + If supplied, must match the identifier of an existing DBInstance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * A specific DB snapshot identifier to describe. This value is stored as a lowercase string.
         *
         * Constraints:
         * + If supplied, must match the identifier of an existing DBSnapshot.
         * + If this identifier is for an automated snapshot, the `SnapshotType` parameter must also be specified.
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * A specific DB resource ID to describe.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * A filter that specifies one or more DB snapshots to describe.
         *
         * Supported filters:
         * + `db-instance-id` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
         * + `db-snapshot-id` - Accepts DB snapshot identifiers.
         * + `dbi-resource-id` - Accepts identifiers of source DB instances.
         * + `snapshot-type` - Accepts types of DB snapshots.
         * + `engine` - Accepts names of database engines.
         */
        public var filters: List<Filter>? = null
        /**
         * A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.
         *
         * You can share a manual DB snapshot as public by using the ModifyDBSnapshotAttribute API.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var includePublic: kotlin.Boolean = false
        /**
         * A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.
         *
         * You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the `ModifyDBSnapshotAttribute` API action.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var includeShared: kotlin.Boolean = false
        /**
         * An optional pagination token provided by a previous `DescribeDBSnapshots` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The type of snapshots to be returned. You can specify one of the following values:
         * + `automated` - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.
         * + `manual` - Return all DB snapshots that have been taken by my Amazon Web Services account.
         * + `shared` - Return all manual DB snapshots that have been shared to my Amazon Web Services account.
         * + `public` - Return all DB snapshots that have been marked as public.
         * + `awsbackup` - Return the DB snapshots managed by the Amazon Web Services Backup service.For information about Amazon Web Services Backup, see the *Amazon Web Services Backup Developer Guide.*[](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html)The `awsbackup` type does not apply to Aurora.
         *
         * If you don't specify a `SnapshotType` value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the `IncludeShared` parameter. You can include public snapshots with these results by enabling the `IncludePublic` parameter.
         *
         * The `IncludeShared` and `IncludePublic` parameters don't apply for `SnapshotType` values of `manual` or `automated`. The `IncludePublic` parameter doesn't apply when `SnapshotType` is set to `shared`. The `IncludeShared` parameter doesn't apply when `SnapshotType` is set to `public`.
         */
        public var snapshotType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.dbiResourceId = x.dbiResourceId
            this.filters = x.filters
            this.includePublic = x.includePublic
            this.includeShared = x.includeShared
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.snapshotType = x.snapshotType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsRequest = DescribeDbSnapshotsRequest(this)
    }
}
