// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class DescribeEventsRequest private constructor(builder: Builder) {
    /**
     * The number of minutes to retrieve events for.
     *
     * Default: 60
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
     *
     * Example: 2009-07-08T18:00Z
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * A list of event categories that trigger notifications for a event notification subscription.
     */
    public val eventCategories: List<String>? = builder.eventCategories
    /**
     * This parameter isn't currently supported.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.
     *
     * Constraints:
     * + If `SourceIdentifier` is supplied, `SourceType` must also be provided.
     * + If the source type is a DB instance, a `DBInstanceIdentifier` value must be supplied.
     * + If the source type is a DB cluster, a `DBClusterIdentifier` value must be supplied.
     * + If the source type is a DB parameter group, a `DBParameterGroupName` value must be supplied.
     * + If the source type is a DB security group, a `DBSecurityGroupName` value must be supplied.
     * + If the source type is a DB snapshot, a `DBSnapshotIdentifier` value must be supplied.
     * + If the source type is a DB cluster snapshot, a `DBClusterSnapshotIdentifier` value must be supplied.
     * + If the source type is an RDS Proxy, a `DBProxyName` value must be supplied.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     */
    public val sourceIdentifier: kotlin.String? = builder.sourceIdentifier
    /**
     * The event source to retrieve events for. If no value is specified, all events are returned.
     */
    public val sourceType: aws.sdk.kotlin.services.rds.model.SourceType? = builder.sourceType
    /**
     * The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
     *
     * Example: 2009-07-08T18:00Z
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventsRequest(")
        append("duration=$duration,")
        append("endTime=$endTime,")
        append("eventCategories=$eventCategories,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEventsRequest

        if (duration != other.duration) return false
        if (endTime != other.endTime) return false
        if (eventCategories != other.eventCategories) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeEventsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of minutes to retrieve events for.
         *
         * Default: 60
         */
        public var duration: kotlin.Int? = null
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
         *
         * Example: 2009-07-08T18:00Z
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of event categories that trigger notifications for a event notification subscription.
         */
        public var eventCategories: List<String>? = null
        /**
         * This parameter isn't currently supported.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.
         *
         * Constraints:
         * + If `SourceIdentifier` is supplied, `SourceType` must also be provided.
         * + If the source type is a DB instance, a `DBInstanceIdentifier` value must be supplied.
         * + If the source type is a DB cluster, a `DBClusterIdentifier` value must be supplied.
         * + If the source type is a DB parameter group, a `DBParameterGroupName` value must be supplied.
         * + If the source type is a DB security group, a `DBSecurityGroupName` value must be supplied.
         * + If the source type is a DB snapshot, a `DBSnapshotIdentifier` value must be supplied.
         * + If the source type is a DB cluster snapshot, a `DBClusterSnapshotIdentifier` value must be supplied.
         * + If the source type is an RDS Proxy, a `DBProxyName` value must be supplied.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         */
        public var sourceIdentifier: kotlin.String? = null
        /**
         * The event source to retrieve events for. If no value is specified, all events are returned.
         */
        public var sourceType: aws.sdk.kotlin.services.rds.model.SourceType? = null
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
         *
         * Example: 2009-07-08T18:00Z
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeEventsRequest) : this() {
            this.duration = x.duration
            this.endTime = x.endTime
            this.eventCategories = x.eventCategories
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeEventsRequest = DescribeEventsRequest(this)
    }
}
