// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class DescribeOrderableDbInstanceOptionsRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available offerings for the Local Zones in the group.
     *
     * Omit this parameter to show the available offerings in the specified Amazon Web Services Region.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val availabilityZoneGroup: kotlin.String? = builder.availabilityZoneGroup
    /**
     * The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The name of the engine to retrieve DB instance options for.
     *
     * Valid Values:
     * + `aurora` (for MySQL 5.6-compatible Aurora)
     * + `aurora-mysql` (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
     * + `aurora-postgresql`
     * + `mariadb`
     * + `mysql`
     * + `oracle-ee`
     * + `oracle-ee-cdb`
     * + `oracle-se2`
     * + `oracle-se2-cdb`
     * + `postgres`
     * + `sqlserver-ee`
     * + `sqlserver-se`
     * + `sqlserver-ex`
     * + `sqlserver-web`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * This parameter isn't currently supported.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.
     *
     * RDS Custom supports only the BYOL licensing model.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 10000.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC offerings.
     *
     * RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output shows VPC offerings.
     */
    public val vpc: kotlin.Boolean? = builder.vpc

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeOrderableDbInstanceOptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeOrderableDbInstanceOptionsRequest(")
        append("availabilityZoneGroup=$availabilityZoneGroup,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("filters=$filters,")
        append("licenseModel=$licenseModel,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("vpc=$vpc)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneGroup?.hashCode() ?: 0
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeOrderableDbInstanceOptionsRequest

        if (availabilityZoneGroup != other.availabilityZoneGroup) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (filters != other.filters) return false
        if (licenseModel != other.licenseModel) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (vpc != other.vpc) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeOrderableDbInstanceOptionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available offerings for the Local Zones in the group.
         *
         * Omit this parameter to show the available offerings in the specified Amazon Web Services Region.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var availabilityZoneGroup: kotlin.String? = null
        /**
         * The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The name of the engine to retrieve DB instance options for.
         *
         * Valid Values:
         * + `aurora` (for MySQL 5.6-compatible Aurora)
         * + `aurora-mysql` (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
         * + `aurora-postgresql`
         * + `mariadb`
         * + `mysql`
         * + `oracle-ee`
         * + `oracle-ee-cdb`
         * + `oracle-se2`
         * + `oracle-se2-cdb`
         * + `postgres`
         * + `sqlserver-ee`
         * + `sqlserver-se`
         * + `sqlserver-ex`
         * + `sqlserver-web`
         */
        public var engine: kotlin.String? = null
        /**
         * The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * This parameter isn't currently supported.
         */
        public var filters: List<Filter>? = null
        /**
         * The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.
         *
         * RDS Custom supports only the BYOL licensing model.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 10000.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC offerings.
         *
         * RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output shows VPC offerings.
         */
        public var vpc: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeOrderableDbInstanceOptionsRequest) : this() {
            this.availabilityZoneGroup = x.availabilityZoneGroup
            this.dbInstanceClass = x.dbInstanceClass
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.filters = x.filters
            this.licenseModel = x.licenseModel
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeOrderableDbInstanceOptionsRequest = DescribeOrderableDbInstanceOptionsRequest(this)
    }
}
