// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class FailoverGlobalClusterRequest private constructor(builder: Builder) {
    /**
     * Identifier of the Aurora global database (GlobalCluster) that should be failed over. The identifier is the unique key assigned by the user when the Aurora global database was created. In other words, it's the name of the Aurora global database that you want to fail over.
     *
     * Constraints:
     * + Must match the identifier of an existing GlobalCluster (Aurora global database).
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * Identifier of the secondary Aurora DB cluster that you want to promote to primary for the Aurora global database (GlobalCluster.) Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region.
     */
    public val targetDbClusterIdentifier: kotlin.String? = builder.targetDbClusterIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailoverGlobalClusterRequest(")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("targetDbClusterIdentifier=$targetDbClusterIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = globalClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (targetDbClusterIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailoverGlobalClusterRequest

        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (targetDbClusterIdentifier != other.targetDbClusterIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifier of the Aurora global database (GlobalCluster) that should be failed over. The identifier is the unique key assigned by the user when the Aurora global database was created. In other words, it's the name of the Aurora global database that you want to fail over.
         *
         * Constraints:
         * + Must match the identifier of an existing GlobalCluster (Aurora global database).
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * Identifier of the secondary Aurora DB cluster that you want to promote to primary for the Aurora global database (GlobalCluster.) Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region.
         */
        public var targetDbClusterIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest) : this() {
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.targetDbClusterIdentifier = x.targetDbClusterIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest = FailoverGlobalClusterRequest(this)
    }
}
