// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * A data structure with information about any primary and secondary clusters associated with an Aurora global database.
 */
public class GlobalClusterMember private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for each Aurora cluster.
     */
    public val dbClusterArn: kotlin.String? = builder.dbClusterArn
    /**
     * Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.
     */
    public val globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = builder.globalWriteForwardingStatus
    /**
     * Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated.
     */
    public val isWriter: kotlin.Boolean = builder.isWriter
    /**
     * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database.
     */
    public val readers: List<String>? = builder.readers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.GlobalClusterMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalClusterMember(")
        append("dbClusterArn=$dbClusterArn,")
        append("globalWriteForwardingStatus=$globalWriteForwardingStatus,")
        append("isWriter=$isWriter,")
        append("readers=$readers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterArn?.hashCode() ?: 0
        result = 31 * result + (globalWriteForwardingStatus?.hashCode() ?: 0)
        result = 31 * result + (isWriter.hashCode())
        result = 31 * result + (readers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalClusterMember

        if (dbClusterArn != other.dbClusterArn) return false
        if (globalWriteForwardingStatus != other.globalWriteForwardingStatus) return false
        if (isWriter != other.isWriter) return false
        if (readers != other.readers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.GlobalClusterMember = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for each Aurora cluster.
         */
        public var dbClusterArn: kotlin.String? = null
        /**
         * Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.
         */
        public var globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = null
        /**
         * Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated.
         */
        public var isWriter: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database.
         */
        public var readers: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.GlobalClusterMember) : this() {
            this.dbClusterArn = x.dbClusterArn
            this.globalWriteForwardingStatus = x.globalWriteForwardingStatus
            this.isWriter = x.isWriter
            this.readers = x.readers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.GlobalClusterMember = GlobalClusterMember(this)
    }
}
