// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class ModifyDbClusterRequest private constructor(builder: Builder) {
    /**
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     *
     * Type: Integer
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * A value that indicates whether major version upgrades are allowed.
     *
     * Constraints: You must allow major version upgrades when specifying a value for the `EngineVersion` parameter that is a different major version than the DB cluster's current version.
     *
     * Valid for: Aurora DB clusters only
     */
    public val allowMajorVersionUpgrade: kotlin.Boolean = builder.allowMajorVersionUpgrade
    /**
     * A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.
     *
     * The `ApplyImmediately` parameter only affects the `EnableIAMDatabaseAuthentication`, `MasterUserPassword`, and `NewDBClusterIdentifier` values. If the `ApplyImmediately` parameter is disabled, then changes to the `EnableIAMDatabaseAuthentication`, `MasterUserPassword`, and `NewDBClusterIdentifier` values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the `ApplyImmediately` parameter.
     *
     * By default, this parameter is disabled.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     *
     * Default: 0
     *
     * Constraints:
     * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *
     * Valid for: Aurora MySQL DB clusters only
     */
    public val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * The number of days for which automated backups are retained. Specify a minimum value of 1.
     *
     * Default: 1
     *
     * Constraints:
     * + Must be a value from 1 to 35
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. The values in the list depend on the DB engine being used.
     *
     * **RDS for MySQL**
     *
     * Possible values are `error`, `general`, and `slowquery`.
     *
     * **RDS for PostgreSQL**
     *
     * Possible values are `postgresql` and `upgrade`.
     *
     * **Aurora MySQL**
     *
     * Possible values are `audit`, `error`, `general`, and `slowquery`.
     *
     * **Aurora PostgreSQL**
     *
     * Possible value is `postgresql`.
     *
     * For more information about exporting CloudWatch Logs for Amazon RDS, see [ Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     *
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
     *
     * Constraints: This identifier must match the identifier of an existing DB cluster.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     *
     * For the full list of DB instance classes and availability for your engine, see [ DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The name of the DB cluster parameter group to use for the DB cluster.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     *
     * When you apply a parameter group using the `DBInstanceParameterGroupName` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
     *
     * Default: The existing name setting
     *
     * Constraints:
     * + The DB parameter group must be in the same DB parameter group family as this DB cluster.
     * + The `DBInstanceParameterGroupName` parameter is valid in combination with the `AllowMajorVersionUpgrade` parameter for a major version upgrade only.
     *
     * Valid for: Aurora DB clusters only
     */
    public val dbInstanceParameterGroupName: kotlin.String? = builder.dbInstanceParameterGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to move the DB cluster to. Specify `none` to remove the cluster from its current domain. The domain must be created prior to this operation.
     *
     * For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters only
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     *
     * Valid for: Aurora DB clusters only
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (GlobalCluster). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
     *
     * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the FailoverGlobalCluster API operation, but it does nothing until then.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableGlobalWriteForwarding: kotlin.Boolean? = builder.enableGlobalWriteForwarding
    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.
     *
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.
     *
     * For more information, see [Using the Data API for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableHttpEndpoint: kotlin.Boolean? = builder.enableHttpEndpoint
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * A value that indicates whether to turn on Performance Insights for the DB cluster.
     *
     * For more information, see [ Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless `ApplyImmediately` is enabled.
     *
     * To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     *
     * For information about valid Iops values, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
     *
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The new password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".
     *
     * Constraints: Must contain from 8 to 41 characters.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     *
     * If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a value other than 0.
     *
     * Valid Values: `0, 1, 5, 10, 15, 30, 60`
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide.*
     *
     * If `MonitoringInterval` is set to a value other than 0, supply a `MonitoringRoleArn` value.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens
     * + The first character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-cluster2`
     *
     * Valid for: Aurora DB clusters only
     */
    public val newDbClusterIdentifier: kotlin.String? = builder.newDbClusterIdentifier
    /**
     * A value that indicates that the DB cluster should be associated with the specified option group.
     *
     * DB clusters are associated with a default option group that can't be modified.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
     * + 7
     * + *month* * 31, where *month* is a number of months from 1-23
     * + 731
     *
     * For example, the following values are valid:
     * + 93 (3 months * 31)
     * + 341 (11 months * 31)
     * + 589 (19 months * 31)
     * + 731
     *
     * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The port number on which the DB cluster accepts connections.
     *
     * Constraints: Value must be `1150-65535`
     *
     * Default: The same port as the original DB cluster.
     *
     * Valid for: Aurora DB clusters only
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see [ Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide*.
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see [ Adjusting the Preferred DB Cluster Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide*.
     *
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *
     * Constraints: Minimum 30-minute window.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in `serverless` DB engine mode.
     *
     * Valid for: Aurora DB clusters only
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = builder.scalingConfiguration
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     *
     * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * Specifies the storage type to be associated with the DB cluster.
     *
     * Valid values: `io1`
     *
     * When specified, a value for the `Iops` parameter is required.
     *
     * Default: `io1`
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of VPC security groups that the DB cluster will belong to.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("allowMajorVersionUpgrade=$allowMajorVersionUpgrade,")
        append("applyImmediately=$applyImmediately,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("backtrackWindow=$backtrackWindow,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbInstanceParameterGroupName=$dbInstanceParameterGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableGlobalWriteForwarding=$enableGlobalWriteForwarding,")
        append("enableHttpEndpoint=$enableHttpEndpoint,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("masterUserPassword=$masterUserPassword,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("newDbClusterIdentifier=$newDbClusterIdentifier,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("storageType=$storageType,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (allowMajorVersionUpgrade.hashCode())
        result = 31 * result + (applyImmediately.hashCode())
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableGlobalWriteForwarding?.hashCode() ?: 0)
        result = 31 * result + (enableHttpEndpoint?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (newDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbClusterRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (allowMajorVersionUpgrade != other.allowMajorVersionUpgrade) return false
        if (applyImmediately != other.applyImmediately) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbInstanceParameterGroupName != other.dbInstanceParameterGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableGlobalWriteForwarding != other.enableGlobalWriteForwarding) return false
        if (enableHttpEndpoint != other.enableHttpEndpoint) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (newDbClusterIdentifier != other.newDbClusterIdentifier) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (storageType != other.storageType) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         *
         * Type: Integer
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * A value that indicates whether major version upgrades are allowed.
         *
         * Constraints: You must allow major version upgrades when specifying a value for the `EngineVersion` parameter that is a different major version than the DB cluster's current version.
         *
         * Valid for: Aurora DB clusters only
         */
        public var allowMajorVersionUpgrade: kotlin.Boolean = false
        /**
         * A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.
         *
         * The `ApplyImmediately` parameter only affects the `EnableIAMDatabaseAuthentication`, `MasterUserPassword`, and `NewDBClusterIdentifier` values. If the `ApplyImmediately` parameter is disabled, then changes to the `EnableIAMDatabaseAuthentication`, `MasterUserPassword`, and `NewDBClusterIdentifier` values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the `ApplyImmediately` parameter.
         *
         * By default, this parameter is disabled.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var applyImmediately: kotlin.Boolean = false
        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         *
         * Default: 0
         *
         * Constraints:
         * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *
         * Valid for: Aurora MySQL DB clusters only
         */
        public var backtrackWindow: kotlin.Long? = null
        /**
         * The number of days for which automated backups are retained. Specify a minimum value of 1.
         *
         * Default: 1
         *
         * Constraints:
         * + Must be a value from 1 to 35
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. The values in the list depend on the DB engine being used.
         *
         * **RDS for MySQL**
         *
         * Possible values are `error`, `general`, and `slowquery`.
         *
         * **RDS for PostgreSQL**
         *
         * Possible values are `postgresql` and `upgrade`.
         *
         * **Aurora MySQL**
         *
         * Possible values are `audit`, `error`, `general`, and `slowquery`.
         *
         * **Aurora PostgreSQL**
         *
         * Possible value is `postgresql`.
         *
         * For more information about exporting CloudWatch Logs for Amazon RDS, see [ Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         *
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = null
        /**
         * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
         *
         * Constraints: This identifier must match the identifier of an existing DB cluster.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
         *
         * For the full list of DB instance classes and availability for your engine, see [ DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to use for the DB cluster.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The name of the DB parameter group to apply to all instances of the DB cluster.
         *
         * When you apply a parameter group using the `DBInstanceParameterGroupName` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
         *
         * Default: The existing name setting
         *
         * Constraints:
         * + The DB parameter group must be in the same DB parameter group family as this DB cluster.
         * + The `DBInstanceParameterGroupName` parameter is valid in combination with the `AllowMajorVersionUpgrade` parameter for a major version upgrade only.
         *
         * Valid for: Aurora DB clusters only
         */
        public var dbInstanceParameterGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to move the DB cluster to. Specify `none` to remove the cluster from its current domain. The domain must be created prior to this operation.
         *
         * For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters only
         */
        public var domain: kotlin.String? = null
        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         *
         * Valid for: Aurora DB clusters only
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (GlobalCluster). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
         *
         * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the FailoverGlobalCluster API operation, but it does nothing until then.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableGlobalWriteForwarding: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.
         *
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.
         *
         * For more information, see [Using the Data API for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableHttpEndpoint: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * A value that indicates whether to turn on Performance Insights for the DB cluster.
         *
         * For more information, see [ Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless `ApplyImmediately` is enabled.
         *
         * To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         *
         * For information about valid Iops values, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
         *
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var iops: kotlin.Int? = null
        /**
         * The new password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".
         *
         * Constraints: Must contain from 8 to 41 characters.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
         *
         * If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a value other than 0.
         *
         * Valid Values: `0, 1, 5, 10, 15, 30, 60`
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide.*
         *
         * If `MonitoringInterval` is set to a value other than 0, supply a `MonitoringRoleArn` value.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens
         * + The first character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-cluster2`
         *
         * Valid for: Aurora DB clusters only
         */
        public var newDbClusterIdentifier: kotlin.String? = null
        /**
         * A value that indicates that the DB cluster should be associated with the specified option group.
         *
         * DB clusters are associated with a default option group that can't be modified.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
         * + 7
         * + *month* * 31, where *month* is a number of months from 1-23
         * + 731
         *
         * For example, the following values are valid:
         * + 93 (3 months * 31)
         * + 341 (11 months * 31)
         * + 589 (19 months * 31)
         * + 731
         *
         * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The port number on which the DB cluster accepts connections.
         *
         * Constraints: Value must be `1150-65535`
         *
         * Default: The same port as the original DB cluster.
         *
         * Valid for: Aurora DB clusters only
         */
        public var port: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see [ Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide*.
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see [ Adjusting the Preferred DB Cluster Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide*.
         *
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *
         * Constraints: Minimum 30-minute window.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in `serverless` DB engine mode.
         *
         * Valid for: Aurora DB clusters only
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         *
         * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * Specifies the storage type to be associated with the DB cluster.
         *
         * Valid values: `io1`
         *
         * When specified, a value for the `Iops` parameter is required.
         *
         * Default: `io1`
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of VPC security groups that the DB cluster will belong to.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.allowMajorVersionUpgrade = x.allowMajorVersionUpgrade
            this.applyImmediately = x.applyImmediately
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.backtrackWindow = x.backtrackWindow
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbInstanceParameterGroupName = x.dbInstanceParameterGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableGlobalWriteForwarding = x.enableGlobalWriteForwarding
            this.enableHttpEndpoint = x.enableHttpEndpoint
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.masterUserPassword = x.masterUserPassword
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.newDbClusterIdentifier = x.newDbClusterIdentifier
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.scalingConfiguration = x.scalingConfiguration
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.storageType = x.storageType
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest = ModifyDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        public fun cloudwatchLogsExportConfiguration(block: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfiguration] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.rds.model.ScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }
    }
}
