// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class RestoreDbClusterFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
     *
     * Valid for: Aurora DB clusters only
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     *
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     *
     * Default: 0
     *
     * Constraints:
     * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *
     * Valid for: Aurora DB clusters only
     */
    public val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The database name for the restored DB cluster.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-snapshot-id`
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     *
     * For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide.*
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used.
     *
     * Constraints:
     * + If supplied, must match the name of an existing default DB cluster parameter group.
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The name of the DB subnet group to use for the new DB cluster.
     *
     * Constraints: If supplied, must match the name of an existing DB subnet group.
     *
     * Example: `mydbsubnetgroup`
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
     *
     * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
     *
     * Valid for: Aurora DB clusters only
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     *
     * Valid for: Aurora DB clusters only
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list depend on the DB engine being used.
     *
     * **RDS for MySQL**
     *
     * Possible values are `error`, `general`, and `slowquery`.
     *
     * **RDS for PostgreSQL**
     *
     * Possible values are `postgresql` and `upgrade`.
     *
     * **Aurora MySQL**
     *
     * Possible values are `audit`, `error`, `general`, and `slowquery`.
     *
     * **Aurora PostgreSQL**
     *
     * Possible value is `postgresql`.
     *
     * For more information about exporting CloudWatch Logs for Amazon RDS, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     *
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The database engine to use for the new DB cluster.
     *
     * Default: The same as source
     *
     * Constraint: Must be compatible with the engine of the source
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The DB engine mode of the DB cluster, either `provisioned`, `serverless`, `parallelquery`, `global`, or `multimaster`.
     *
     * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
     *
     * Valid for: Aurora DB clusters only
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * The version of the database engine to use for the new DB cluster.
     *
     * To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
     *
     * **Aurora MySQL**
     *
     * See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
     *
     * **Aurora PostgreSQL**
     *
     * See [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
     *
     * **MySQL**
     *
     * See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
     *
     * **PostgreSQL**
     *
     * See [Amazon RDS for PostgreSQL versions and extensions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide.*
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     *
     * For information about valid Iops values, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
     *
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *
     * When you don't specify a value for the `KmsKeyId` parameter, then the following occurs:
     * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
     * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` isn't encrypted, then the restored DB cluster isn't encrypted.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the option group to use for the restored DB cluster.
     *
     * DB clusters are associated with a default option group that can't be modified.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the new DB cluster accepts connections.
     *
     * Constraints: This value must be `1150-65535`
     *
     * Default: The same port as the original DB cluster.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val port: kotlin.Int? = builder.port
    /**
     * A value that indicates whether the DB cluster is publicly accessible.
     *
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
     *
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     *
     * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
     *
     * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
     * + If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *
     * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * For DB clusters in `serverless` DB engine mode, the scaling properties of the DB cluster.
     *
     * Valid for: Aurora DB clusters only
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = builder.scalingConfiguration
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     *
     * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     *
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     *
     * Constraints:
     * + Must match the identifier of an existing Snapshot.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.
     *
     * Valid values: `io1`
     *
     * When specified, a value for the `Iops` parameter is required.
     *
     * Default: `io1`
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The tags to be assigned to the restored DB cluster.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of VPC security groups that the new DB cluster will belong to.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterFromSnapshotRequest(")
        append("availabilityZones=$availabilityZones,")
        append("backtrackWindow=$backtrackWindow,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engine=$engine,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterFromSnapshotRequest

        if (availabilityZones != other.availabilityZones) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engine != other.engine) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.
         *
         * Valid for: Aurora DB clusters only
         */
        public var availabilityZones: List<String>? = null
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         *
         * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         *
         * Default: 0
         *
         * Constraints:
         * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *
         * Valid for: Aurora DB clusters only
         */
        public var backtrackWindow: kotlin.Long? = null
        /**
         * A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The database name for the restored DB cluster.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var databaseName: kotlin.String? = null
        /**
         * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-snapshot-id`
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
         *
         * For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide.*
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used.
         *
         * Constraints:
         * + If supplied, must match the name of an existing default DB cluster parameter group.
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The name of the DB subnet group to use for the new DB cluster.
         *
         * Constraints: If supplied, must match the name of an existing DB subnet group.
         *
         * Example: `mydbsubnetgroup`
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         *
         * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
         *
         * Valid for: Aurora DB clusters only
         */
        public var domain: kotlin.String? = null
        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         *
         * Valid for: Aurora DB clusters only
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list depend on the DB engine being used.
         *
         * **RDS for MySQL**
         *
         * Possible values are `error`, `general`, and `slowquery`.
         *
         * **RDS for PostgreSQL**
         *
         * Possible values are `postgresql` and `upgrade`.
         *
         * **Aurora MySQL**
         *
         * Possible values are `audit`, `error`, `general`, and `slowquery`.
         *
         * **Aurora PostgreSQL**
         *
         * Possible value is `postgresql`.
         *
         * For more information about exporting CloudWatch Logs for Amazon RDS, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         *
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The database engine to use for the new DB cluster.
         *
         * Default: The same as source
         *
         * Constraint: Must be compatible with the engine of the source
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var engine: kotlin.String? = null
        /**
         * The DB engine mode of the DB cluster, either `provisioned`, `serverless`, `parallelquery`, `global`, or `multimaster`.
         *
         * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
         *
         * Valid for: Aurora DB clusters only
         */
        public var engineMode: kotlin.String? = null
        /**
         * The version of the database engine to use for the new DB cluster.
         *
         * To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
         *
         * **Aurora MySQL**
         *
         * See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
         *
         * **Aurora PostgreSQL**
         *
         * See [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
         *
         * **MySQL**
         *
         * See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
         *
         * **PostgreSQL**
         *
         * See [Amazon RDS for PostgreSQL versions and extensions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide.*
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         *
         * For information about valid Iops values, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
         *
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         *
         * When you don't specify a value for the `KmsKeyId` parameter, then the following occurs:
         * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
         * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` isn't encrypted, then the restored DB cluster isn't encrypted.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the option group to use for the restored DB cluster.
         *
         * DB clusters are associated with a default option group that can't be modified.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the new DB cluster accepts connections.
         *
         * Constraints: This value must be `1150-65535`
         *
         * Default: The same port as the original DB cluster.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var port: kotlin.Int? = null
        /**
         * A value that indicates whether the DB cluster is publicly accessible.
         *
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
         *
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         *
         * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
         *
         * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
         * + If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         *
         * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
         * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * For DB clusters in `serverless` DB engine mode, the scaling properties of the DB cluster.
         *
         * Valid for: Aurora DB clusters only
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         *
         * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The identifier for the DB snapshot or DB cluster snapshot to restore from.
         *
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         *
         * Constraints:
         * + Must match the identifier of an existing Snapshot.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.
         *
         * Valid values: `io1`
         *
         * When specified, a value for the `Iops` parameter is required.
         *
         * Default: `io1`
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var storageType: kotlin.String? = null
        /**
         * The tags to be assigned to the restored DB cluster.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var tags: List<Tag>? = null
        /**
         * A list of VPC security groups that the new DB cluster will belong to.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromSnapshotRequest) : this() {
            this.availabilityZones = x.availabilityZones
            this.backtrackWindow = x.backtrackWindow
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engine = x.engine
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.publiclyAccessible = x.publiclyAccessible
            this.scalingConfiguration = x.scalingConfiguration
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.snapshotIdentifier = x.snapshotIdentifier
            this.storageType = x.storageType
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromSnapshotRequest = RestoreDbClusterFromSnapshotRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfiguration] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.rds.model.ScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }
    }
}
