// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class RestoreDbInstanceFromS3Request private constructor(builder: Builder) {
    /**
     * The amount of storage (in gigabytes) to allocate initially for the DB instance. Follow the allocation rules specified in `CreateDBInstance`.
     *
     * Be sure to allocate enough memory for your new DB instance so that the restore operation can succeed. You can also allocate additional memory for future growth.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are not applied automatically.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon RDS User Guide.*
     *
     * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     *
     * Example: `us-east-1d`
     *
     * Constraint: The `AvailabilityZone` parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. For more information, see `CreateDBInstance`.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide.*
     *
     * Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The DB instance identifier. This parameter is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `mydbinstance`
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name of the database to create when the DB instance is created. Follow the naming rules specified in `CreateDBInstance`.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * The name of the DB parameter group to associate with this DB instance.
     *
     * If you do not specify a value for `DBParameterGroupName`, then the default `DBParameterGroup` for the specified DB engine is used.
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * A list of DB security groups to associate with this DB instance.
     *
     * Default: The default DB security group for the database engine.
     */
    public val dbSecurityGroups: List<String>? = builder.dbSecurityGroups
    /**
     * A DB subnet group to associate with this DB instance.
     *
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *
     * Example: `mydbsubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * A value that indicates whether to enable Performance Insights for the DB instance.
     *
     * For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The name of the database engine to be used for this instance.
     *
     * Valid Values: `mysql`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine to use. Choose the latest minor version of your database engine. For information about engine versions, see `CreateDBInstance`, or call `DescribeDBEngineVersions`.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB instance. For information about valid Iops values, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide.*
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key identifier for an encrypted DB instance.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *
     * If the `StorageEncrypted` parameter is enabled, and you do not specify a value for the `KmsKeyId` parameter, then Amazon RDS will use your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The license model for this DB instance. Use `general-public-license`.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     *
     * Constraints: Must contain from 8 to 41 characters.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The name for the master user.
     *
     * Constraints:
     * + Must be 1 to 16 letters or numbers.
     * + First character must be a letter.
     * + Can't be a reserved word for the chosen database engine.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     *
     * For more information about this setting, including limitations that apply to it, see [ Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
     */
    public val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0.
     *
     * If `MonitoringRoleArn` is specified, then you must also set `MonitoringInterval` to a value other than 0.
     *
     * Valid Values: 0, 1, 5, 10, 15, 30, 60
     *
     * Default: `0`
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide.*
     *
     * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * A value that indicates whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you can't set the `AvailabilityZone` parameter.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The network type of the DB instance.
     *
     * Valid values:
     * + `IPV4`
     * + `DUAL`
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The name of the option group to associate with this DB instance. If this argument is omitted, the default option group for the specified engine is used.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you do not specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
     * + 7
     * + *month* * 31, where *month* is a number of months from 1-23
     * + 731
     *
     * For example, the following values are valid:
     * + 93 (3 months * 31)
     * + 341 (11 months * 31)
     * + 589 (19 months * 31)
     * + 731
     *
     * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The port number on which the database accepts connections.
     *
     * Type: Integer
     *
     * Valid Values: `1150`-`65535`
     *
     * Default: `3306`
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The time range each day during which automated backups are created if automated backups are enabled. For more information, see [Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide.*
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see [Amazon RDS Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance) in the *Amazon RDS User Guide.*
     *
     * Constraints:
     * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
     * + Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred backup window.
     * + Must be at least 30 minutes.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    public val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * A value that indicates whether the DB instance is publicly accessible.
     *
     * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.
     *
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBInstance.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The name of your Amazon S3 bucket that contains your database backup file.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * An Amazon Web Services Identity and Access Management (IAM) role to allow Amazon RDS to access your Amazon S3 bucket.
     */
    public val s3IngestionRoleArn: kotlin.String? = builder.s3IngestionRoleArn
    /**
     * The prefix of your Amazon S3 bucket.
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix
    /**
     * The name of the engine of your source database.
     *
     * Valid Values: `mysql`
     */
    public val sourceEngine: kotlin.String? = builder.sourceEngine
    /**
     * The version of the database that the backup files were created from.
     *
     * MySQL versions 5.6 and 5.7 are supported.
     *
     * Example: `5.6.40`
     */
    public val sourceEngineVersion: kotlin.String? = builder.sourceEngineVersion
    /**
     * A value that indicates whether the new DB instance is encrypted or not.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * Specifies the storage type to be associated with the DB instance.
     *
     * Valid values: `standard` | `gp2` | `io1`
     *
     * If you specify `io1`, you must also include a value for the `Iops` parameter.
     *
     * Default: `io1` if the `Iops` parameter is specified; otherwise `gp2`
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags to associate with this DB instance. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
     */
    public val useDefaultProcessorFeatures: kotlin.Boolean? = builder.useDefaultProcessorFeatures
    /**
     * A list of VPC security groups to associate with this DB instance.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromS3Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbInstanceFromS3Request(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbName=$dbName,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUsername=$masterUsername,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("networkType=$networkType,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("processorFeatures=$processorFeatures,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("s3BucketName=$s3BucketName,")
        append("s3IngestionRoleArn=$s3IngestionRoleArn,")
        append("s3Prefix=$s3Prefix,")
        append("sourceEngine=$sourceEngine,")
        append("sourceEngineVersion=$sourceEngineVersion,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("useDefaultProcessorFeatures=$useDefaultProcessorFeatures,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3IngestionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (sourceEngine?.hashCode() ?: 0)
        result = 31 * result + (sourceEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useDefaultProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbInstanceFromS3Request

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbName != other.dbName) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (networkType != other.networkType) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (processorFeatures != other.processorFeatures) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3IngestionRoleArn != other.s3IngestionRoleArn) return false
        if (s3Prefix != other.s3Prefix) return false
        if (sourceEngine != other.sourceEngine) return false
        if (sourceEngineVersion != other.sourceEngineVersion) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (useDefaultProcessorFeatures != other.useDefaultProcessorFeatures) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromS3Request = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of storage (in gigabytes) to allocate initially for the DB instance. Follow the allocation rules specified in `CreateDBInstance`.
         *
         * Be sure to allocate enough memory for your new DB instance so that the restore operation can succeed. You can also allocate additional memory for future growth.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are not applied automatically.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon RDS User Guide.*
         *
         * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         *
         * Example: `us-east-1d`
         *
         * Constraint: The `AvailabilityZone` parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. For more information, see `CreateDBInstance`.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide.*
         *
         * Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The DB instance identifier. This parameter is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `mydbinstance`
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name of the database to create when the DB instance is created. Follow the naming rules specified in `CreateDBInstance`.
         */
        public var dbName: kotlin.String? = null
        /**
         * The name of the DB parameter group to associate with this DB instance.
         *
         * If you do not specify a value for `DBParameterGroupName`, then the default `DBParameterGroup` for the specified DB engine is used.
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * A list of DB security groups to associate with this DB instance.
         *
         * Default: The default DB security group for the database engine.
         */
        public var dbSecurityGroups: List<String>? = null
        /**
         * A DB subnet group to associate with this DB instance.
         *
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *
         * Example: `mydbsubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable Performance Insights for the DB instance.
         *
         * For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The name of the database engine to be used for this instance.
         *
         * Valid Values: `mysql`
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the database engine to use. Choose the latest minor version of your database engine. For information about engine versions, see `CreateDBInstance`, or call `DescribeDBEngineVersions`.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB instance. For information about valid Iops values, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide.*
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted DB instance.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         *
         * If the `StorageEncrypted` parameter is enabled, and you do not specify a value for the `KmsKeyId` parameter, then Amazon RDS will use your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The license model for this DB instance. Use `general-public-license`.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
         *
         * Constraints: Must contain from 8 to 41 characters.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The name for the master user.
         *
         * Constraints:
         * + Must be 1 to 16 letters or numbers.
         * + First character must be a letter.
         * + Can't be a reserved word for the chosen database engine.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         *
         * For more information about this setting, including limitations that apply to it, see [ Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
         */
        public var maxAllocatedStorage: kotlin.Int? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0.
         *
         * If `MonitoringRoleArn` is specified, then you must also set `MonitoringInterval` to a value other than 0.
         *
         * Valid Values: 0, 1, 5, 10, 15, 30, 60
         *
         * Default: `0`
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide.*
         *
         * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you can't set the `AvailabilityZone` parameter.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The network type of the DB instance.
         *
         * Valid values:
         * + `IPV4`
         * + `DUAL`
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
         */
        public var networkType: kotlin.String? = null
        /**
         * The name of the option group to associate with this DB instance. If this argument is omitted, the default option group for the specified engine is used.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you do not specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:
         * + 7
         * + *month* * 31, where *month* is a number of months from 1-23
         * + 731
         *
         * For example, the following values are valid:
         * + 93 (3 months * 31)
         * + 341 (11 months * 31)
         * + 589 (19 months * 31)
         * + 731
         *
         * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The port number on which the database accepts connections.
         *
         * Type: Integer
         *
         * Valid Values: `1150`-`65535`
         *
         * Default: `3306`
         */
        public var port: kotlin.Int? = null
        /**
         * The time range each day during which automated backups are created if automated backups are enabled. For more information, see [Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide.*
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see [Amazon RDS Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance) in the *Amazon RDS User Guide.*
         *
         * Constraints:
         * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
         * + Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred backup window.
         * + Must be at least 30 minutes.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         */
        public var processorFeatures: List<ProcessorFeature>? = null
        /**
         * A value that indicates whether the DB instance is publicly accessible.
         *
         * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.
         *
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBInstance.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The name of your Amazon S3 bucket that contains your database backup file.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * An Amazon Web Services Identity and Access Management (IAM) role to allow Amazon RDS to access your Amazon S3 bucket.
         */
        public var s3IngestionRoleArn: kotlin.String? = null
        /**
         * The prefix of your Amazon S3 bucket.
         */
        public var s3Prefix: kotlin.String? = null
        /**
         * The name of the engine of your source database.
         *
         * Valid Values: `mysql`
         */
        public var sourceEngine: kotlin.String? = null
        /**
         * The version of the database that the backup files were created from.
         *
         * MySQL versions 5.6 and 5.7 are supported.
         *
         * Example: `5.6.40`
         */
        public var sourceEngineVersion: kotlin.String? = null
        /**
         * A value that indicates whether the new DB instance is encrypted or not.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * Specifies the storage type to be associated with the DB instance.
         *
         * Valid values: `standard` | `gp2` | `io1`
         *
         * If you specify `io1`, you must also include a value for the `Iops` parameter.
         *
         * Default: `io1` if the `Iops` parameter is specified; otherwise `gp2`
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags to associate with this DB instance. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null
        /**
         * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
         */
        public var useDefaultProcessorFeatures: kotlin.Boolean? = null
        /**
         * A list of VPC security groups to associate with this DB instance.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromS3Request) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbName = x.dbName
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.networkType = x.networkType
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.processorFeatures = x.processorFeatures
            this.publiclyAccessible = x.publiclyAccessible
            this.s3BucketName = x.s3BucketName
            this.s3IngestionRoleArn = x.s3IngestionRoleArn
            this.s3Prefix = x.s3Prefix
            this.sourceEngine = x.sourceEngine
            this.sourceEngineVersion = x.sourceEngineVersion
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tags = x.tags
            this.useDefaultProcessorFeatures = x.useDefaultProcessorFeatures
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromS3Request = RestoreDbInstanceFromS3Request(this)
    }
}
