// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of a snapshot export to Amazon S3.
 *
 * This data type is used as a response element in the `DescribeExportTasks` action.
 */
public class StartExportTaskResponse private constructor(builder: Builder) {
    /**
     * The data exported from the snapshot. Valid values are the following:
     * + `database` - Export all the data from a specified database.
     * + `database.table`*table-name* - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
     * + `database.schema`*schema-name* - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     * + `database.schema.table`*table-name* - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
     */
    public val exportOnly: List<String>? = builder.exportOnly
    /**
     * A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to.
     */
    public val exportTaskIdentifier: kotlin.String? = builder.exportTaskIdentifier
    /**
     * The reason the export failed, if it failed.
     */
    public val failureCause: kotlin.String? = builder.failureCause
    /**
     * The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The progress of the snapshot export task as a percentage.
     */
    public val percentProgress: kotlin.Int = builder.percentProgress
    /**
     * The Amazon S3 bucket that the snapshot is exported to.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix
    /**
     * The time that the snapshot was created.
     */
    public val snapshotTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotTime
    /**
     * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The progress status of the export task.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The time that the snapshot export task completed.
     */
    public val taskEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.taskEndTime
    /**
     * The time that the snapshot export task started.
     */
    public val taskStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.taskStartTime
    /**
     * The total amount of data exported, in gigabytes.
     */
    public val totalExtractedDataInGb: kotlin.Int = builder.totalExtractedDataInGb
    /**
     * A warning about the snapshot export task.
     */
    public val warningMessage: kotlin.String? = builder.warningMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.StartExportTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartExportTaskResponse(")
        append("exportOnly=$exportOnly,")
        append("exportTaskIdentifier=$exportTaskIdentifier,")
        append("failureCause=$failureCause,")
        append("iamRoleArn=$iamRoleArn,")
        append("kmsKeyId=$kmsKeyId,")
        append("percentProgress=$percentProgress,")
        append("s3Bucket=$s3Bucket,")
        append("s3Prefix=$s3Prefix,")
        append("snapshotTime=$snapshotTime,")
        append("sourceArn=$sourceArn,")
        append("status=$status,")
        append("taskEndTime=$taskEndTime,")
        append("taskStartTime=$taskStartTime,")
        append("totalExtractedDataInGb=$totalExtractedDataInGb,")
        append("warningMessage=$warningMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = exportOnly?.hashCode() ?: 0
        result = 31 * result + (exportTaskIdentifier?.hashCode() ?: 0)
        result = 31 * result + (failureCause?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (percentProgress)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (snapshotTime?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskEndTime?.hashCode() ?: 0)
        result = 31 * result + (taskStartTime?.hashCode() ?: 0)
        result = 31 * result + (totalExtractedDataInGb)
        result = 31 * result + (warningMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartExportTaskResponse

        if (exportOnly != other.exportOnly) return false
        if (exportTaskIdentifier != other.exportTaskIdentifier) return false
        if (failureCause != other.failureCause) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (percentProgress != other.percentProgress) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Prefix != other.s3Prefix) return false
        if (snapshotTime != other.snapshotTime) return false
        if (sourceArn != other.sourceArn) return false
        if (status != other.status) return false
        if (taskEndTime != other.taskEndTime) return false
        if (taskStartTime != other.taskStartTime) return false
        if (totalExtractedDataInGb != other.totalExtractedDataInGb) return false
        if (warningMessage != other.warningMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.StartExportTaskResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data exported from the snapshot. Valid values are the following:
         * + `database` - Export all the data from a specified database.
         * + `database.table`*table-name* - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
         * + `database.schema`*schema-name* - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         * + `database.schema.table`*table-name* - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
         */
        public var exportOnly: List<String>? = null
        /**
         * A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to.
         */
        public var exportTaskIdentifier: kotlin.String? = null
        /**
         * The reason the export failed, if it failed.
         */
        public var failureCause: kotlin.String? = null
        /**
         * The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The progress of the snapshot export task as a percentage.
         */
        public var percentProgress: kotlin.Int = 0
        /**
         * The Amazon S3 bucket that the snapshot is exported to.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.
         */
        public var s3Prefix: kotlin.String? = null
        /**
         * The time that the snapshot was created.
         */
        public var snapshotTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The progress status of the export task.
         */
        public var status: kotlin.String? = null
        /**
         * The time that the snapshot export task completed.
         */
        public var taskEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the snapshot export task started.
         */
        public var taskStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The total amount of data exported, in gigabytes.
         */
        public var totalExtractedDataInGb: kotlin.Int = 0
        /**
         * A warning about the snapshot export task.
         */
        public var warningMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.StartExportTaskResponse) : this() {
            this.exportOnly = x.exportOnly
            this.exportTaskIdentifier = x.exportTaskIdentifier
            this.failureCause = x.failureCause
            this.iamRoleArn = x.iamRoleArn
            this.kmsKeyId = x.kmsKeyId
            this.percentProgress = x.percentProgress
            this.s3Bucket = x.s3Bucket
            this.s3Prefix = x.s3Prefix
            this.snapshotTime = x.snapshotTime
            this.sourceArn = x.sourceArn
            this.status = x.status
            this.taskEndTime = x.taskEndTime
            this.taskStartTime = x.taskStartTime
            this.totalExtractedDataInGb = x.totalExtractedDataInGb
            this.warningMessage = x.warningMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.StartExportTaskResponse = StartExportTaskResponse(this)
    }
}
