// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * The version of the database engine that a DB instance can be upgraded to.
 */
public class UpgradeTarget private constructor(builder: Builder) {
    /**
     * A value that indicates whether the target version is applied to any source DB instances that have `AutoMinorVersionUpgrade` set to true.
     */
    public val autoUpgrade: kotlin.Boolean = builder.autoUpgrade
    /**
     * The version of the database engine that a DB instance can be upgraded to.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the upgrade target database engine.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the upgrade target database engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * A value that indicates whether upgrading to the target version requires upgrading the major version of the database engine.
     */
    public val isMajorVersionUpgrade: kotlin.Boolean = builder.isMajorVersionUpgrade
    /**
     * A list of the supported DB engine modes for the target engine version.
     */
    public val supportedEngineModes: List<String>? = builder.supportedEngineModes
    /**
     * A value that indicates whether you can use Babelfish for Aurora PostgreSQL with the target engine version.
     */
    public val supportsBabelfish: kotlin.Boolean? = builder.supportsBabelfish
    /**
     * A value that indicates whether you can use Aurora global databases with the target engine version.
     */
    public val supportsGlobalDatabases: kotlin.Boolean? = builder.supportsGlobalDatabases
    /**
     * A value that indicates whether you can use Aurora parallel query with the target engine version.
     */
    public val supportsParallelQuery: kotlin.Boolean? = builder.supportsParallelQuery

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.UpgradeTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeTarget(")
        append("autoUpgrade=$autoUpgrade,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("isMajorVersionUpgrade=$isMajorVersionUpgrade,")
        append("supportedEngineModes=$supportedEngineModes,")
        append("supportsBabelfish=$supportsBabelfish,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases,")
        append("supportsParallelQuery=$supportsParallelQuery)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpgrade.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (isMajorVersionUpgrade.hashCode())
        result = 31 * result + (supportedEngineModes?.hashCode() ?: 0)
        result = 31 * result + (supportsBabelfish?.hashCode() ?: 0)
        result = 31 * result + (supportsGlobalDatabases?.hashCode() ?: 0)
        result = 31 * result + (supportsParallelQuery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeTarget

        if (autoUpgrade != other.autoUpgrade) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (isMajorVersionUpgrade != other.isMajorVersionUpgrade) return false
        if (supportedEngineModes != other.supportedEngineModes) return false
        if (supportsBabelfish != other.supportsBabelfish) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false
        if (supportsParallelQuery != other.supportsParallelQuery) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.UpgradeTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value that indicates whether the target version is applied to any source DB instances that have `AutoMinorVersionUpgrade` set to true.
         */
        public var autoUpgrade: kotlin.Boolean = false
        /**
         * The version of the database engine that a DB instance can be upgraded to.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the upgrade target database engine.
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the upgrade target database engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * A value that indicates whether upgrading to the target version requires upgrading the major version of the database engine.
         */
        public var isMajorVersionUpgrade: kotlin.Boolean = false
        /**
         * A list of the supported DB engine modes for the target engine version.
         */
        public var supportedEngineModes: List<String>? = null
        /**
         * A value that indicates whether you can use Babelfish for Aurora PostgreSQL with the target engine version.
         */
        public var supportsBabelfish: kotlin.Boolean? = null
        /**
         * A value that indicates whether you can use Aurora global databases with the target engine version.
         */
        public var supportsGlobalDatabases: kotlin.Boolean? = null
        /**
         * A value that indicates whether you can use Aurora parallel query with the target engine version.
         */
        public var supportsParallelQuery: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.UpgradeTarget) : this() {
            this.autoUpgrade = x.autoUpgrade
            this.description = x.description
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.isMajorVersionUpgrade = x.isMajorVersionUpgrade
            this.supportedEngineModes = x.supportedEngineModes
            this.supportsBabelfish = x.supportsBabelfish
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
            this.supportsParallelQuery = x.supportsParallelQuery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.UpgradeTarget = UpgradeTarget(this)
    }
}
