// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the `DescribeValidDBInstanceModifications` action.
 */
public class ValidStorageOptions private constructor(builder: Builder) {
    /**
     * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage.
     */
    public val iopsToStorageRatio: List<DoubleRange>? = builder.iopsToStorageRatio
    /**
     * The valid range of provisioned IOPS. For example, 1000-20000.
     */
    public val provisionedIops: List<Range>? = builder.provisionedIops
    /**
     * The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
     */
    public val storageSize: List<Range>? = builder.storageSize
    /**
     * The valid storage types for your DB instance. For example, gp2, io1.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.
     */
    public val supportsStorageAutoscaling: kotlin.Boolean = builder.supportsStorageAutoscaling

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ValidStorageOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidStorageOptions(")
        append("iopsToStorageRatio=$iopsToStorageRatio,")
        append("provisionedIops=$provisionedIops,")
        append("storageSize=$storageSize,")
        append("storageType=$storageType,")
        append("supportsStorageAutoscaling=$supportsStorageAutoscaling)")
    }

    override fun hashCode(): kotlin.Int {
        var result = iopsToStorageRatio?.hashCode() ?: 0
        result = 31 * result + (provisionedIops?.hashCode() ?: 0)
        result = 31 * result + (storageSize?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (supportsStorageAutoscaling.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidStorageOptions

        if (iopsToStorageRatio != other.iopsToStorageRatio) return false
        if (provisionedIops != other.provisionedIops) return false
        if (storageSize != other.storageSize) return false
        if (storageType != other.storageType) return false
        if (supportsStorageAutoscaling != other.supportsStorageAutoscaling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ValidStorageOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage.
         */
        public var iopsToStorageRatio: List<DoubleRange>? = null
        /**
         * The valid range of provisioned IOPS. For example, 1000-20000.
         */
        public var provisionedIops: List<Range>? = null
        /**
         * The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
         */
        public var storageSize: List<Range>? = null
        /**
         * The valid storage types for your DB instance. For example, gp2, io1.
         */
        public var storageType: kotlin.String? = null
        /**
         * Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.
         */
        public var supportsStorageAutoscaling: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ValidStorageOptions) : this() {
            this.iopsToStorageRatio = x.iopsToStorageRatio
            this.provisionedIops = x.provisionedIops
            this.storageSize = x.storageSize
            this.storageType = x.storageType
            this.supportsStorageAutoscaling = x.supportsStorageAutoscaling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ValidStorageOptions = ValidStorageOptions(this)
    }
}
