// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.rds.model.PurchaseReservedDbInstancesOfferingResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.ReservedDbInstance
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class PurchaseReservedDBInstancesOfferingOperationDeserializer: HttpDeserialize<PurchaseReservedDbInstancesOfferingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PurchaseReservedDbInstancesOfferingResponse {
        if (!response.status.isSuccess()) {
            throwPurchaseReservedDbInstancesOfferingError(context, response)
        }
        val builder = PurchaseReservedDbInstancesOfferingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePurchaseReservedDBInstancesOfferingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPurchaseReservedDbInstancesOfferingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReservedDBInstanceAlreadyExists" -> ReservedDbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedDBInstanceQuotaExceeded" -> ReservedDbInstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedDBInstancesOfferingNotFound" -> ReservedDbInstancesOfferingNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePurchaseReservedDBInstancesOfferingOperationBody(builder: PurchaseReservedDbInstancesOfferingResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PurchaseReservedDBInstancesOfferingResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("PurchaseReservedDBInstancesOfferingResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap PurchaseReservedDBInstancesOffering response")
    }
    // end unwrap response wrapper

    val RESERVEDDBINSTANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ReservedDBInstance"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("PurchaseReservedDBInstancesOfferingResult"))
        field(RESERVEDDBINSTANCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESERVEDDBINSTANCE_DESCRIPTOR.index -> builder.reservedDbInstance = deserializeReservedDbInstanceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
