// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.rds.model.DbProxyTarget
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RegisterDbProxyTargetsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RegisterDBProxyTargetsOperationDeserializer: HttpDeserialize<RegisterDbProxyTargetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterDbProxyTargetsResponse {
        if (!response.status.isSuccess()) {
            throwRegisterDbProxyTargetsError(context, response)
        }
        val builder = RegisterDbProxyTargetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterDBProxyTargetsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRegisterDbProxyTargetsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBProxyTargetAlreadyRegisteredFault" -> DbProxyTargetAlreadyRegisteredFaultDeserializer().deserialize(context, wrappedResponse)
        "DBProxyTargetGroupNotFoundFault" -> DbProxyTargetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientAvailableIPsInSubnetFault" -> InsufficientAvailableIPsInSubnetFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBProxyStateFault" -> InvalidDbProxyStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterDBProxyTargetsOperationBody(builder: RegisterDbProxyTargetsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RegisterDBProxyTargetsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RegisterDBProxyTargetsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RegisterDBProxyTargets response")
    }
    // end unwrap response wrapper

    val DBPROXYTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("DBProxyTargets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("RegisterDBProxyTargetsResult"))
        field(DBPROXYTARGETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBPROXYTARGETS_DESCRIPTOR.index -> builder.dbProxyTargets =
                    deserializer.deserializeList(DBPROXYTARGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<DbProxyTarget>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDbProxyTargetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
