// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.ProcessorFeature
import aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromS3Request
import aws.sdk.kotlin.services.rds.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RestoreDBInstanceFromS3OperationSerializer: HttpSerialize<RestoreDbInstanceFromS3Request> {
    override suspend fun serialize(context: ExecutionContext, input: RestoreDbInstanceFromS3Request): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeRestoreDBInstanceFromS3OperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeRestoreDBInstanceFromS3OperationBody(context: ExecutionContext, input: RestoreDbInstanceFromS3Request): ByteArray {
    val serializer = FormUrlSerializer()
    val ALLOCATEDSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("AllocatedStorage"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AutoMinorVersionUpgrade"))
    val AVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AvailabilityZone"))
    val BACKUPRETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("BackupRetentionPeriod"))
    val COPYTAGSTOSNAPSHOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("CopyTagsToSnapshot"))
    val DBINSTANCECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBInstanceClass"))
    val DBINSTANCEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBInstanceIdentifier"))
    val DBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBName"))
    val DBPARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBParameterGroupName"))
    val DBSECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("DBSecurityGroups"), FormUrlCollectionName("DBSecurityGroupName"))
    val DBSUBNETGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBSubnetGroupName"))
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DeletionProtection"))
    val ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("EnableCloudwatchLogsExports"))
    val ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnableIAMDatabaseAuthentication"))
    val ENABLEPERFORMANCEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnablePerformanceInsights"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Engine"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EngineVersion"))
    val IOPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Iops"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KmsKeyId"))
    val LICENSEMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LicenseModel"))
    val MASTERUSERPASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MasterUserPassword"))
    val MASTERUSERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MasterUsername"))
    val MAXALLOCATEDSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxAllocatedStorage"))
    val MONITORINGINTERVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MonitoringInterval"))
    val MONITORINGROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MonitoringRoleArn"))
    val MULTIAZ_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("MultiAZ"))
    val NETWORKTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NetworkType"))
    val OPTIONGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OptionGroupName"))
    val PERFORMANCEINSIGHTSKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PerformanceInsightsKMSKeyId"))
    val PERFORMANCEINSIGHTSRETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("PerformanceInsightsRetentionPeriod"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Port"))
    val PREFERREDBACKUPWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredBackupWindow"))
    val PREFERREDMAINTENANCEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredMaintenanceWindow"))
    val PROCESSORFEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ProcessorFeatures"), FormUrlCollectionName("ProcessorFeature"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("PubliclyAccessible"))
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("S3BucketName"))
    val S3INGESTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("S3IngestionRoleArn"))
    val S3PREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("S3Prefix"))
    val SOURCEENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceEngine"))
    val SOURCEENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceEngineVersion"))
    val STORAGEENCRYPTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("StorageEncrypted"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StorageType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val USEDEFAULTPROCESSORFEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("UseDefaultProcessorFeatures"))
    val VPCSECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("VpcSecurityGroupIds"), FormUrlCollectionName("VpcSecurityGroupId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("RestoreDBInstanceFromS3Message"))
        trait(QueryLiteral("Action", "RestoreDBInstanceFromS3"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(ALLOCATEDSTORAGE_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(AVAILABILITYZONE_DESCRIPTOR)
        field(BACKUPRETENTIONPERIOD_DESCRIPTOR)
        field(COPYTAGSTOSNAPSHOT_DESCRIPTOR)
        field(DBINSTANCECLASS_DESCRIPTOR)
        field(DBINSTANCEIDENTIFIER_DESCRIPTOR)
        field(DBNAME_DESCRIPTOR)
        field(DBPARAMETERGROUPNAME_DESCRIPTOR)
        field(DBSECURITYGROUPS_DESCRIPTOR)
        field(DBSUBNETGROUPNAME_DESCRIPTOR)
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR)
        field(ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR)
        field(ENABLEPERFORMANCEINSIGHTS_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(IOPS_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LICENSEMODEL_DESCRIPTOR)
        field(MASTERUSERPASSWORD_DESCRIPTOR)
        field(MASTERUSERNAME_DESCRIPTOR)
        field(MAXALLOCATEDSTORAGE_DESCRIPTOR)
        field(MONITORINGINTERVAL_DESCRIPTOR)
        field(MONITORINGROLEARN_DESCRIPTOR)
        field(MULTIAZ_DESCRIPTOR)
        field(NETWORKTYPE_DESCRIPTOR)
        field(OPTIONGROUPNAME_DESCRIPTOR)
        field(PERFORMANCEINSIGHTSKMSKEYID_DESCRIPTOR)
        field(PERFORMANCEINSIGHTSRETENTIONPERIOD_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(PREFERREDBACKUPWINDOW_DESCRIPTOR)
        field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR)
        field(PROCESSORFEATURES_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(S3BUCKETNAME_DESCRIPTOR)
        field(S3INGESTIONROLEARN_DESCRIPTOR)
        field(S3PREFIX_DESCRIPTOR)
        field(SOURCEENGINE_DESCRIPTOR)
        field(SOURCEENGINEVERSION_DESCRIPTOR)
        field(STORAGEENCRYPTED_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USEDEFAULTPROCESSORFEATURES_DESCRIPTOR)
        field(VPCSECURITYGROUPIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.allocatedStorage?.let { field(ALLOCATEDSTORAGE_DESCRIPTOR, it) }
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.availabilityZone?.let { field(AVAILABILITYZONE_DESCRIPTOR, it) }
        input.backupRetentionPeriod?.let { field(BACKUPRETENTIONPERIOD_DESCRIPTOR, it) }
        input.copyTagsToSnapshot?.let { field(COPYTAGSTOSNAPSHOT_DESCRIPTOR, it) }
        input.dbInstanceClass?.let { field(DBINSTANCECLASS_DESCRIPTOR, it) }
        input.dbInstanceIdentifier?.let { field(DBINSTANCEIDENTIFIER_DESCRIPTOR, it) }
        input.dbName?.let { field(DBNAME_DESCRIPTOR, it) }
        input.dbParameterGroupName?.let { field(DBPARAMETERGROUPNAME_DESCRIPTOR, it) }
        if (input.dbSecurityGroups != null) {
            listField(DBSECURITYGROUPS_DESCRIPTOR) {
                for (el0 in input.dbSecurityGroups) {
                    serializeString(el0)
                }
            }
        }
        input.dbSubnetGroupName?.let { field(DBSUBNETGROUPNAME_DESCRIPTOR, it) }
        input.deletionProtection?.let { field(DELETIONPROTECTION_DESCRIPTOR, it) }
        if (input.enableCloudwatchLogsExports != null) {
            listField(ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR) {
                for (el0 in input.enableCloudwatchLogsExports) {
                    serializeString(el0)
                }
            }
        }
        input.enableIamDatabaseAuthentication?.let { field(ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR, it) }
        input.enablePerformanceInsights?.let { field(ENABLEPERFORMANCEINSIGHTS_DESCRIPTOR, it) }
        input.engine?.let { field(ENGINE_DESCRIPTOR, it) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.iops?.let { field(IOPS_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.licenseModel?.let { field(LICENSEMODEL_DESCRIPTOR, it) }
        input.masterUserPassword?.let { field(MASTERUSERPASSWORD_DESCRIPTOR, it) }
        input.masterUsername?.let { field(MASTERUSERNAME_DESCRIPTOR, it) }
        input.maxAllocatedStorage?.let { field(MAXALLOCATEDSTORAGE_DESCRIPTOR, it) }
        input.monitoringInterval?.let { field(MONITORINGINTERVAL_DESCRIPTOR, it) }
        input.monitoringRoleArn?.let { field(MONITORINGROLEARN_DESCRIPTOR, it) }
        input.multiAz?.let { field(MULTIAZ_DESCRIPTOR, it) }
        input.networkType?.let { field(NETWORKTYPE_DESCRIPTOR, it) }
        input.optionGroupName?.let { field(OPTIONGROUPNAME_DESCRIPTOR, it) }
        input.performanceInsightsKmsKeyId?.let { field(PERFORMANCEINSIGHTSKMSKEYID_DESCRIPTOR, it) }
        input.performanceInsightsRetentionPeriod?.let { field(PERFORMANCEINSIGHTSRETENTIONPERIOD_DESCRIPTOR, it) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        input.preferredBackupWindow?.let { field(PREFERREDBACKUPWINDOW_DESCRIPTOR, it) }
        input.preferredMaintenanceWindow?.let { field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR, it) }
        if (input.processorFeatures != null) {
            listField(PROCESSORFEATURES_DESCRIPTOR) {
                for (el0 in input.processorFeatures) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProcessorFeatureDocument))
                }
            }
        }
        input.publiclyAccessible?.let { field(PUBLICLYACCESSIBLE_DESCRIPTOR, it) }
        input.s3BucketName?.let { field(S3BUCKETNAME_DESCRIPTOR, it) }
        input.s3IngestionRoleArn?.let { field(S3INGESTIONROLEARN_DESCRIPTOR, it) }
        input.s3Prefix?.let { field(S3PREFIX_DESCRIPTOR, it) }
        input.sourceEngine?.let { field(SOURCEENGINE_DESCRIPTOR, it) }
        input.sourceEngineVersion?.let { field(SOURCEENGINEVERSION_DESCRIPTOR, it) }
        input.storageEncrypted?.let { field(STORAGEENCRYPTED_DESCRIPTOR, it) }
        input.storageType?.let { field(STORAGETYPE_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.useDefaultProcessorFeatures?.let { field(USEDEFAULTPROCESSORFEATURES_DESCRIPTOR, it) }
        if (input.vpcSecurityGroupIds != null) {
            listField(VPCSECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.vpcSecurityGroupIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
