// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.waiters

import aws.sdk.kotlin.services.rds.RdsClient
import aws.sdk.kotlin.services.rds.model.DescribeDbClusterSnapshotsRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbClusterSnapshotsResponse
import aws.sdk.kotlin.services.rds.model.DescribeDbClustersRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbClustersResponse
import aws.sdk.kotlin.services.rds.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbInstancesResponse
import aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import aws.smithy.kotlin.runtime.util.length
import kotlin.time.Duration.Companion.milliseconds


public suspend fun RdsClient.waitUntilDBClusterAvailable(request: DescribeDbClustersRequest): Outcome<DescribeDbClustersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbClustersRequest, DescribeDbClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusters(request) }
}

public suspend fun RdsClient.waitUntilDBClusterAvailable(block: DescribeDbClustersRequest.Builder.() -> Unit): Outcome<DescribeDbClustersResponse> =
    waitUntilDBClusterAvailable(DescribeDbClustersRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBClusterDeleted(request: DescribeDbClustersRequest): Outcome<DescribeDbClustersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbClustersRequest, DescribeDbClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusters = it?.dbClusters
            val length = dbClusters?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBClusterNotFoundFault"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it?.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible() ?: listOf()
            val projection = dbClustersOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusters(request) }
}

public suspend fun RdsClient.waitUntilDBClusterDeleted(block: DescribeDbClustersRequest.Builder.() -> Unit): Outcome<DescribeDbClustersResponse> =
    waitUntilDBClusterDeleted(DescribeDbClustersRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBClusterSnapshotAvailable(request: DescribeDbClusterSnapshotsRequest): Outcome<DescribeDbClusterSnapshotsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusterSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBClusterSnapshotAvailable(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbClusterSnapshotsResponse> =
    waitUntilDBClusterSnapshotAvailable(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBClusterSnapshotDeleted(request: DescribeDbClusterSnapshotsRequest): Outcome<DescribeDbClusterSnapshotsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val length = dbClusterSnapshots?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBClusterSnapshotNotFoundFault"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it?.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbClusterSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusterSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBClusterSnapshotDeleted(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbClusterSnapshotsResponse> =
    waitUntilDBClusterSnapshotDeleted(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBInstanceAvailable(request: DescribeDbInstancesRequest): Outcome<DescribeDbInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbInstancesRequest, DescribeDbInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbInstances(request) }
}

public suspend fun RdsClient.waitUntilDBInstanceAvailable(block: DescribeDbInstancesRequest.Builder.() -> Unit): Outcome<DescribeDbInstancesResponse> =
    waitUntilDBInstanceAvailable(DescribeDbInstancesRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBInstanceDeleted(request: DescribeDbInstancesRequest): Outcome<DescribeDbInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbInstancesRequest, DescribeDbInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbInstances = it?.dbInstances
            val length = dbInstances?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBInstanceNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbInstances(request) }
}

public suspend fun RdsClient.waitUntilDBInstanceDeleted(block: DescribeDbInstancesRequest.Builder.() -> Unit): Outcome<DescribeDbInstancesResponse> =
    waitUntilDBInstanceDeleted(DescribeDbInstancesRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBSnapshotAvailable(request: DescribeDbSnapshotsRequest): Outcome<DescribeDbSnapshotsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbSnapshotsRequest, DescribeDbSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBSnapshotAvailable(block: DescribeDbSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbSnapshotsResponse> =
    waitUntilDBSnapshotAvailable(DescribeDbSnapshotsRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBSnapshotDeleted(request: DescribeDbSnapshotsRequest): Outcome<DescribeDbSnapshotsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbSnapshotsRequest, DescribeDbSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbSnapshots = it?.dbSnapshots
            val length = dbSnapshots?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBSnapshotNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it?.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible() ?: listOf()
            val projection = dbSnapshotsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBSnapshotDeleted(block: DescribeDbSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbSnapshotsResponse> =
    waitUntilDBSnapshotDeleted(DescribeDbSnapshotsRequest.Builder().apply(block).build())
